/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.operation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.soda.devicekit.ui.DeviceKitUiPlugin;
import org.eclipse.soda.devicekit.ui.operation.OperationMessages;
import org.eclipse.soda.devicekit.ui.operation.SortedVector;
import org.eclipse.soda.devicekit.util.TypeSearcher;

public class ComputeClassPathOperation
implements IWorkspaceRunnable,
IRunnableWithProgress,
Comparator {
    private List containerLibraries;
    private IProgressMonitor progressMonitor = null;
    private IJavaProject project = null;
    private Vector classPath = new Vector();
    private String[] bundleNames = new String[0];
    private Vector packages = new Vector();
    private Vector serviceList = new Vector();
    private final String[] TYPES = new String[]{".zip", ".jar"};
    private final String SOURCEJAR = "source.jar";
    private boolean checkTechnologies = true;
    private boolean update = true;
    private ArrayList list = null;
    IJavaSearchScope searchScope = null;

    public ComputeClassPathOperation(IJavaProject project, boolean update) {
        this.project = project;
        this.setUpdate(update);
        if (project != null) {
            this.list = this.fetchAllTypes();
        }
        this.setContainerLibraries(new ArrayList());
    }

    public void addAllReferences(IProgressMonitor progressMonitor, IJavaProject project) throws CoreException {
        SortedVector missingFromClasspath = new SortedVector();
        String projectName = project.getElementName();
        IClasspathEntry[] currentEntries = project.getRawClasspath();
        IRuntimeClasspathEntry[] unResolvedEntries = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)project);
        int i = 0;
        while (i < unResolvedEntries.length) {
            IJavaProject subJavaProject;
            IResource resource;
            String pathName;
            boolean isInCurrentClasspath;
            IClasspathEntry unResolvedEntry = unResolvedEntries[i].getClasspathEntry();
            if (!(unResolvedEntry == null || (isInCurrentClasspath = this.isInCurrentClasspath(unResolvedEntry, currentEntries)) || (pathName = unResolvedEntry.getPath().toString()).substring(1).equals(projectName) || missingFromClasspath.contains(unResolvedEntry))) {
                missingFromClasspath.add(unResolvedEntry);
            }
            if (unResolvedEntries[i].getType() == 1 && (resource = unResolvedEntries[i].getResource()) instanceof IProject && (subJavaProject = JavaCore.create((IProject)((IProject)resource))).exists()) {
                IRuntimeClasspathEntry[] subUnResolvedEntries = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)subJavaProject);
                int k = 0;
                while (k < subUnResolvedEntries.length) {
                    String pathName2;
                    IClasspathEntry subUnResolvedEntry;
                    boolean subIsInCurrentClasspath;
                    if (!(subUnResolvedEntries[k].getType() != 3 && subUnResolvedEntries[k].getType() != 1 || (subIsInCurrentClasspath = this.isInCurrentClasspath(subUnResolvedEntry = subUnResolvedEntries[k].getClasspathEntry(), currentEntries)) || (pathName2 = subUnResolvedEntry.getPath().toString()).substring(1).equals(projectName) || missingFromClasspath.contains(subUnResolvedEntry))) {
                        missingFromClasspath.add(subUnResolvedEntry);
                    }
                    ++k;
                }
            }
            ++i;
        }
        int size = missingFromClasspath.size();
        if (size > 0) {
            try {
                IClasspathEntry[] missingEntries = new IClasspathEntry[size];
                missingFromClasspath.toArray(missingEntries);
                IClasspathEntry[] newEntries = new IClasspathEntry[currentEntries.length + size];
                System.arraycopy(currentEntries, 0, newEntries, 0, currentEntries.length);
                System.arraycopy(missingEntries, 0, newEntries, currentEntries.length, size);
                project.setRawClasspath(newEntries, progressMonitor);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void addEntry(IClasspathEntry ce) {
        int i = 0;
        while (i < this.classPath.size()) {
            Object object = this.classPath.elementAt(i);
            if (object instanceof IClasspathEntry) {
                IClasspathEntry cel = (IClasspathEntry)object;
                if (ce.equals(cel)) {
                    return;
                }
                if (ce.getContentKind() == cel.getContentKind() && ce.getPath().equals((Object)cel.getPath())) {
                    return;
                }
            }
            ++i;
        }
        if (!this.isContainerLibrary(JavaCore.getResolvedClasspathEntry((IClasspathEntry)ce).getPath().makeAbsolute())) {
            this.classPath.addElement(ce);
        }
    }

    public void addJar(String path, String name, String variable) {
        IClasspathEntry entry;
        if (variable.length() == 0) {
            String fullPath = String.valueOf(path) + File.separator + name;
            entry = JavaCore.newLibraryEntry((IPath)new Path(fullPath), null, null);
        } else {
            String libPath = String.valueOf(variable) + File.separator + name;
            String sourcePath = this.getSourcePath(path, name, variable);
            entry = JavaCore.newVariableEntry((IPath)new Path(libPath), (IPath)new Path(sourcePath), null);
        }
        this.addEntry(entry);
    }

    public int checkFile(String name, String variable) {
        int i;
        File file = new File(name);
        if (file.isDirectory()) {
            String[] list = file.list();
            i = 0;
            while (i < list.length) {
                if (list[i].endsWith(".jar")) {
                    try {
                        int tresult = this.checkJar(String.valueOf(name) + File.separator + list[i]);
                        if (tresult > 0) {
                            this.addJar(name, list[i], variable);
                        }
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
        }
        String[] bundleFolders = this.getBundleFileEntries(variable);
        i = 0;
        while (i < bundleFolders.length) {
            String bname = String.valueOf(name) + File.separator + bundleFolders[i];
            file = new File(bname);
            if (file.exists()) {
                String[] list = file.list();
                int j = 0;
                while (j < list.length) {
                    if (list[j].endsWith(".jar")) {
                        try {
                            int bresult = this.checkJar(String.valueOf(bname) + File.separator + list[j]);
                            if (bresult > 0) {
                                String extension = String.valueOf(bundleFolders[i]) + File.separator + list[j];
                                this.addJar(bname, extension, variable);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ++j;
                }
            }
            ++i;
        }
        return 0;
    }

    private void checkHasIndirectReference(IProject project) throws CoreException {
        IMarker[] marker = project.findMarkers("org.eclipse.jdt.core.problem", true, 2);
        int i = 0;
        while (i < marker.length) {
            String needs;
            int index;
            String arguments;
            String idString;
            Map attributes = marker[i].getAttributes();
            Object id = attributes.get("id");
            if (id != null && "16777540".equals(idString = id.toString()) && (arguments = (String)attributes.get("arguments")) != null && (index = arguments.indexOf(58) + 1) + 1 < arguments.length() && (index = (needs = arguments.substring(index)).lastIndexOf(46)) != -1) {
                String needsPackage = needs.substring(0, index);
                this.packages.add(needsPackage);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int checkJar(String name) {
        int result = 0;
        JarFile jarFile = null;
        InputStream inputStream = null;
        try {
            try {
                jarFile = new JarFile(name);
                ZipEntry zipEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                if (zipEntry != null && (inputStream = jarFile.getInputStream(zipEntry)) != null) {
                    result = this.checkManifest(inputStream);
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (jarFile != null) {
                    jarFile.close();
                    jarFile = null;
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                inputStream = null;
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException iOException) {
            return result;
        }
        if (jarFile != null) {
            jarFile.close();
            jarFile = null;
        }
        if (inputStream == null) return result;
        inputStream.close();
        inputStream = null;
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int checkManifest(InputStream inputStream) {
        int result = 0;
        try {
            try {
                String pname;
                int i;
                int index;
                String token;
                Manifest manifest = new Manifest(inputStream);
                Attributes attributes = manifest.getMainAttributes();
                Object name = attributes.get(new Attributes.Name("Bundle-Name"));
                if (name != null) {
                    int i2 = 0;
                    while (i2 < this.bundleNames.length) {
                        if (name.equals(this.bundleNames[i2])) {
                            IClasspathEntry entry = this.findClasspathSourceEntry(name.toString());
                            result = entry != null ? 0 : 1;
                        }
                        ++i2;
                    }
                }
                if ((name = attributes.get(new Attributes.Name("Export-Package"))) != null) {
                    StringTokenizer tokenizer = new StringTokenizer(name.toString(), ",");
                    while (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextElement().toString().trim();
                        index = token.indexOf(59);
                        if (index > 0) {
                            token = token.substring(0, index).trim();
                        }
                        Vector cpackages = (Vector)this.packages.clone();
                        i = 0;
                        while (i < cpackages.size()) {
                            pname = cpackages.elementAt(i).toString();
                            if (token.equals(pname)) {
                                result = 2;
                                this.packages.removeElement(pname);
                            }
                            ++i;
                        }
                    }
                }
                if ((name = attributes.get(new Attributes.Name("Export-Service"))) != null) {
                    StringTokenizer tokenizer = new StringTokenizer(name.toString(), ",");
                    while (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextElement().toString().trim();
                        index = token.indexOf(59);
                        if (index > 0) {
                            token = token.substring(0, index).trim();
                        }
                        Vector clist = (Vector)this.serviceList.clone();
                        i = 0;
                        while (i < clist.size()) {
                            pname = clist.elementAt(i).toString();
                            if (token.equals(pname)) {
                                result = 2;
                                this.serviceList.removeElement(pname);
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var12_16 = null;
        }
        try {}
        catch (IOException iOException) {
            return result;
        }
        if (inputStream == null) return result;
        inputStream.close();
        return result;
    }

    public void checkTechnologies(String tFolder) {
        File technologies = new File(tFolder);
        String[] names = technologies.list();
        int i = 0;
        while (i < names.length) {
            String path = String.valueOf(tFolder) + File.separator + names[i];
            this.checkTechnologiesSubFolder(path);
            if (this.serviceList.isEmpty()) {
                return;
            }
            ++i;
        }
    }

    public void checkTechnologiesSubFolder(String folder) {
        File file = new File(folder);
        if (!file.exists()) {
            return;
        }
        String[] files = file.list();
        int result = 0;
        int i = 0;
        while (i < files.length) {
            if (files[i].endsWith(".jar")) {
                String jarName = String.valueOf(folder) + File.separator + files[i];
                result = this.checkJar(jarName);
                if (result > 0) {
                    this.addJar(folder, files[i], "");
                }
            } else if (files[i].equals("bundlefiles")) {
                this.checkTechnologiesSubFolder(String.valueOf(folder) + File.separator + "bundlefiles");
            }
            ++i;
        }
    }

    public int compare(Object object1, Object object2) {
        int kind2;
        IClasspathEntry entry1 = (IClasspathEntry)object1;
        IClasspathEntry entry2 = (IClasspathEntry)object2;
        int kind1 = entry1.getEntryKind();
        if (kind1 == (kind2 = entry2.getEntryKind())) {
            return entry1.getPath().toString().compareTo(entry2.getPath().toString());
        }
        switch (kind1) {
            case 5: {
                return -1;
            }
            case 3: {
                return kind2 == 5 ? 1 : -1;
            }
            case 2: {
                if (kind2 == 5 || kind2 == 3) {
                    return 1;
                }
                return -1;
            }
            case 4: {
                if (kind2 == 5 || kind2 == 3 || kind2 == 2) {
                    return 1;
                }
                return -1;
            }
            case 1: {
                return 1;
            }
        }
        return entry1.getPath().toString().compareTo(entry2.getPath().toString());
    }

    private ArrayList fetchAllTypes() {
        ArrayList list = new ArrayList();
        TypeSearcher searcher = new TypeSearcher(this.project);
        try {
            list = searcher.search();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return list;
    }

    public IClasspathEntry findClasspathSourceEntry(String name) throws CoreException {
        IProject project;
        if (this.project != null && (project = DeviceKitUiPlugin.getWorkspace().getRoot().getProject(name)) != null && project.exists()) {
            IClasspathEntry srcEntry = JavaCore.newProjectEntry((IPath)project.getProject().getFullPath());
            return srcEntry;
        }
        return null;
    }

    public IPackageFragment findPackageSource(String packageName) {
        IPackageFragment bestResult = null;
        try {
            if (this.project != null) {
                bestResult = this.getPackageFromCurrentProject(packageName);
                if (bestResult != null) {
                    return bestResult;
                }
                IJavaProject[] javaProjects = JavaCore.create((IWorkspaceRoot)DeviceKitUiPlugin.getWorkspace().getRoot()).getJavaProjects();
                int i = 0;
                while (i < javaProjects.length) {
                    IJavaProject jproject = javaProjects[i];
                    if (jproject.exists()) {
                        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
                        int j = 0;
                        while (j < roots.length) {
                            IPackageFragment result;
                            if (roots[j].getKind() == 1 && (result = roots[j].getPackageFragment(packageName)) != null && result.exists() && result.getCompilationUnits().length > 0) {
                                return result;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException exception) {
            exception.printStackTrace();
        }
        return bestResult;
    }

    public IJavaProject findServiceSource(String serviceName) throws CoreException {
        if (this.project != null) {
            IPackageFragmentRoot[] roots = this.project.getAllPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1 && this.serviceSourceExistsInSourceFolder(serviceName, roots[i])) {
                    return roots[i].getJavaProject();
                }
                ++i;
            }
            IProject[] projects = DeviceKitUiPlugin.getWorkspace().getRoot().getProjects();
            int i2 = 0;
            while (i2 < projects.length) {
                IJavaProject jproject = JavaCore.create((IProject)projects[i2]);
                if (this.serviceSourceExistsInProject(serviceName, jproject)) {
                    return jproject;
                }
                ++i2;
            }
        }
        return null;
    }

    public IType findType(String typeName) {
        try {
            int index = typeName.indexOf(46);
            if (index == -1) {
                int i = 0;
                while (i < this.list.size()) {
                    IType ref = (IType)this.list.get(i);
                    if (typeName.equals(ref.getElementName())) {
                        return ref;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.list.size()) {
                    IType ref = (IType)this.list.get(i);
                    if (typeName.equals(ref.getFullyQualifiedName())) {
                        return ref;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public IFile[] getAllJxeRulesFiles(IContainer project) {
        ArrayList<Object> list = new ArrayList<Object>();
        IResource[] resources = null;
        try {
            resources = project.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFolder) {
                    IFile[] subList = this.getAllJxeRulesFiles((IContainer)resources[i]);
                    int j = 0;
                    while (j < subList.length) {
                        if (!list.contains(subList[j])) {
                            list.add(subList[j]);
                        }
                        ++j;
                    }
                } else if (resources[i] instanceof IFile && resources[i].getName().endsWith(".rules")) {
                    list.add(resources[i]);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        IFile[] files = new IFile[list.size()];
        list.toArray(files);
        return files;
    }

    public Vector getAllSourceImports(ICompilationUnit cu, Vector v) {
        try {
            IImportDeclaration[] imports = cu.getImports();
            IType[] types = cu.getTypes();
            int i = 0;
            while (i < types.length) {
                block14: {
                    IType[] classes;
                    block13: {
                        String superName;
                        String name;
                        block15: {
                            IType type = types[i];
                            if (this.progressMonitor != null) {
                                this.progressMonitor.setTaskName(OperationMessages.getString("ComputeClassPathOperation.resolving.super.type.classpath"));
                            }
                            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(this.progressMonitor);
                            IType[] interfaces = hierarchy.getAllSuperInterfaces(type);
                            int j = 0;
                            while (j < interfaces.length) {
                                IType type2 = interfaces[j];
                                IPackageFragment pack = type2.getPackageFragment();
                                name = pack.getElementName();
                                if (!v.contains(name) && !this.isInCurrentClasspath(name)) {
                                    v.addElement(name);
                                }
                                ++j;
                            }
                            classes = hierarchy.getAllSuperclasses(type);
                            if (classes.length != 0) break block13;
                            superName = type.getSuperclassName();
                            if (superName == null) break block14;
                            IType stype = this.findType(superName);
                            if (stype == null) break block15;
                            name = this.getPackageName(stype.getFullyQualifiedName());
                            if (name != null && !v.contains(name) && !this.isInCurrentClasspath(name)) {
                                v.addElement(name);
                            }
                            this.getAllSourceImports(stype, v);
                            break block14;
                        }
                        if (superName.indexOf(46) <= -1 || (name = this.getPackageName(superName)) == null || v.contains(name)) break block14;
                        v.addElement(name);
                        break block14;
                    }
                    int j = 0;
                    while (j < classes.length) {
                        IType type2 = classes[j];
                        ICompilationUnit cu3 = type2.getCompilationUnit();
                        if (cu3 != null) {
                            this.getAllSourceImports(cu3, v);
                        } else {
                            this.getAllSourceImports(type2, v);
                        }
                        IPackageFragment pack = type2.getPackageFragment();
                        String name = pack.getElementName();
                        if (!v.contains(name) && !this.isInCurrentClasspath(name)) {
                            v.addElement(name);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < imports.length) {
                String name = this.getName(imports[i].getElementName());
                if (!v.contains(name)) {
                    v.addElement(name);
                }
                ++i;
            }
            return v;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Vector getAllSourceImports(IType type, Vector v) {
        try {
            block19: {
                IType[] classes;
                block18: {
                    String superName;
                    String name;
                    block20: {
                        ITypeHierarchy hierarchy;
                        IType[] interfaces;
                        if (this.progressMonitor != null) {
                            this.progressMonitor.setTaskName(OperationMessages.getString("ComputeClassPathOperation.resolving.super.type.classpath"));
                        }
                        if ((interfaces = (hierarchy = type.newSupertypeHierarchy(this.progressMonitor)).getAllSuperInterfaces(type)).length == 0) {
                            String[] interfaceNames = type.getSuperInterfaceNames();
                            int k = 0;
                            while (k < interfaceNames.length) {
                                String interfaceName = interfaceNames[k];
                                if (interfaceName != null) {
                                    String name2;
                                    IType stype = this.findType(interfaceName);
                                    if (stype != null) {
                                        name2 = this.getPackageName(stype.getFullyQualifiedName());
                                        if (name2 != null && !v.contains(name2)) {
                                            v.addElement(name2);
                                        }
                                        this.getAllSourceImports(stype, v);
                                    } else if (interfaceName.indexOf(46) > -1 && (name2 = this.getPackageName(interfaceName)) != null && !v.contains(name2)) {
                                        v.addElement(name2);
                                    }
                                }
                                ++k;
                            }
                        } else {
                            int j = 0;
                            while (j < interfaces.length) {
                                IType type2 = interfaces[j];
                                IPackageFragment pack = type2.getPackageFragment();
                                name = pack.getElementName();
                                if (!v.contains(name)) {
                                    v.addElement(name);
                                }
                                ++j;
                            }
                        }
                        classes = hierarchy.getAllSuperclasses(type);
                        if (classes.length != 0) break block18;
                        superName = type.getSuperclassName();
                        if (superName == null) break block19;
                        IType stype = this.findType(superName);
                        if (stype == null) break block20;
                        name = this.getPackageName(stype.getFullyQualifiedName());
                        if (name != null && !v.contains(name)) {
                            v.addElement(name);
                        }
                        this.getAllSourceImports(stype, v);
                        break block19;
                    }
                    if (superName.indexOf(46) <= -1 || (name = this.getPackageName(superName)) == null || v.contains(name)) break block19;
                    v.addElement(name);
                    break block19;
                }
                int j = 0;
                while (j < classes.length) {
                    IType type2 = classes[j];
                    ICompilationUnit cu3 = type2.getCompilationUnit();
                    if (cu3 != null) {
                        this.getAllSourceImports(cu3, v);
                    } else {
                        this.getAllSourceImports(type2, v);
                    }
                    IPackageFragment pack = type2.getPackageFragment();
                    String name = pack.getElementName();
                    if (!v.contains(name)) {
                        v.addElement(name);
                    }
                    ++j;
                }
            }
            return v;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList getAllTypes() {
        return this.list;
    }

    private String getAnchorName(String name) {
        int plusIndex = name.indexOf(43);
        if (plusIndex >= 0) {
            return name.substring(0, plusIndex);
        }
        int dotIndex = name.indexOf(46);
        if (dotIndex >= 0) {
            return name.substring(0, dotIndex);
        }
        return "";
    }

    public String[] getBundleFileEntries(String variable) {
        return new String[]{"bundlefiles", "bundlefiles/test"};
    }

    public Vector getBundleImports(IJavaProject project) {
        Vector<String> list = new Vector<String>();
        try {
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IContainer mfolder;
                IContainer sfolder;
                IResource mresource;
                IResource sresource;
                if (roots[i].getKind() == 1 && (sresource = roots[i].getUnderlyingResource()) instanceof IContainer && (mresource = (sfolder = (IContainer)sresource).findMember("META-INF")) instanceof IContainer && (mfolder = (IContainer)mresource).exists()) {
                    IResource resource = mfolder.findMember("MANIFEST.MF");
                    IFile file = null;
                    if (resource instanceof IFile && (file = (IFile)resource).exists()) {
                        InputStream inputStream = file.getContents();
                        String[] imports = this.getManifestImports(inputStream);
                        int j = 0;
                        while (j < imports.length) {
                            String name = imports[j];
                            if (!list.contains(name)) {
                                list.addElement(name);
                            }
                            ++j;
                        }
                        inputStream = file.getContents();
                        String[] importServices = this.getManifestImportServices(inputStream);
                        int j2 = 0;
                        while (j2 < importServices.length) {
                            String name = importServices[j2];
                            if (!this.serviceList.contains(name)) {
                                this.serviceList.addElement(name);
                            }
                            if (!list.contains(name = this.getPackageName(name))) {
                                list.addElement(name);
                            }
                            ++j2;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return list;
    }

    public IFile getBundleManifestFile(IJavaProject project) {
        try {
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IContainer mfolder;
                IContainer sfolder;
                IResource mresource;
                IResource sresource;
                if (roots[i].getKind() == 1 && (sresource = roots[i].getUnderlyingResource()) instanceof IContainer && (mresource = (sfolder = (IContainer)sresource).findMember("META-INF")) instanceof IContainer && (mfolder = (IContainer)mresource).exists()) {
                    IResource resource = mfolder.findMember("MANIFEST.MF");
                    IFile file = null;
                    if (resource instanceof IFile && (file = (IFile)resource).exists()) {
                        return file;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected IFile getBundleManifestFileInSourceFolder(IPackageFragmentRoot root) throws CoreException {
        IContainer mfolder;
        IContainer sfolder;
        IResource mresource;
        IResource sresource = root.getUnderlyingResource();
        if (sresource instanceof IContainer && (mresource = (sfolder = (IContainer)sresource).findMember("META-INF")) instanceof IContainer && (mfolder = (IContainer)mresource).exists()) {
            IResource resource = mfolder.findMember("MANIFEST.MF");
            IFile file = null;
            if (resource instanceof IFile && (file = (IFile)resource).exists()) {
                return file;
            }
        }
        return null;
    }

    protected List getContainerLibraries() {
        return this.containerLibraries;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getManifestExportServices(InputStream inputStream) {
        String[] result = new String[]{};
        try {
            try {
                Manifest manifest = new Manifest(inputStream);
                Attributes attributes = manifest.getMainAttributes();
                Object name = attributes.get(new Attributes.Name("Export-Service"));
                if (name != null) {
                    StringTokenizer tokenizer = new StringTokenizer(name.toString(), ",");
                    result = new String[tokenizer.countTokens()];
                    int i = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextElement().toString();
                        int index = token.indexOf(59);
                        result[i] = index > 0 ? token.substring(0, index).trim() : token;
                        ++i;
                    }
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        try {}
        catch (IOException iOException) {
            return result;
        }
        if (inputStream == null) return result;
        inputStream.close();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getManifestExports(InputStream inputStream) {
        String[] result = new String[]{};
        try {
            try {
                Manifest manifest = new Manifest(inputStream);
                Attributes attributes = manifest.getMainAttributes();
                Object name = attributes.get(new Attributes.Name("Export-Package"));
                if (name != null) {
                    StringTokenizer tokenizer = new StringTokenizer(name.toString(), ",");
                    result = new String[tokenizer.countTokens()];
                    int i = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextElement().toString();
                        int index = token.indexOf(59);
                        result[i] = index > 0 ? token.substring(0, index).trim() : token;
                        ++i;
                    }
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        try {}
        catch (IOException iOException) {
            return result;
        }
        if (inputStream == null) return result;
        inputStream.close();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getManifestImportServices(InputStream inputStream) {
        String[] result = new String[]{};
        try {
            try {
                Manifest manifest = new Manifest(inputStream);
                Attributes attributes = manifest.getMainAttributes();
                Object name = attributes.get(new Attributes.Name("Import-Service"));
                if (name != null) {
                    StringTokenizer tokenizer = new StringTokenizer(name.toString(), ",");
                    result = new String[tokenizer.countTokens()];
                    int i = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextElement().toString();
                        int index = token.indexOf(59);
                        result[i] = index > 0 ? token.substring(0, index).trim() : token;
                        ++i;
                    }
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        try {}
        catch (IOException iOException) {
            return result;
        }
        if (inputStream == null) return result;
        inputStream.close();
        return result;
    }

    /*
     * Exception decompiling
     */
    public String[] getManifestImports(InputStream inputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 164->167)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getName(String name) {
        int index = name.lastIndexOf(46);
        if (index > 0) {
            return name.substring(0, index);
        }
        return name;
    }

    private IPackageFragment getPackageFromCurrentProject(String packageName) {
        try {
            IPackageFragmentRoot[] currProjRoots = this.project.getAllPackageFragmentRoots();
            int j = 0;
            while (j < currProjRoots.length) {
                IPackageFragment result;
                if (currProjRoots[j].getKind() == 1 && (result = currProjRoots[j].getPackageFragment(packageName)) != null && result.exists() && result.getCompilationUnits().length > 0) {
                    return result;
                }
                ++j;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public String getPackageName(String fullName) {
        int index = fullName.lastIndexOf(46);
        if (index > 0) {
            return fullName.substring(0, index);
        }
        return fullName;
    }

    public Vector getSourceImports(IJavaProject project) {
        try {
            project.getProject().refreshLocal(2, null);
            Vector list = new Vector();
            IFile[] jxeLinks = this.getAllJxeRulesFiles((IContainer)project.getProject());
            int i = 0;
            while (i < jxeLinks.length) {
                this.getSourceImports(jxeLinks[i], list);
                ++i;
            }
            Object[] objects = null;
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            int i2 = 0;
            while (i2 < roots.length) {
                if (roots[i2].getKind() == 1) {
                    objects = roots[i2].getNonJavaResources();
                    if (objects != null) {
                        int k = 0;
                        while (k < objects.length) {
                            if (objects[k] instanceof IFile) {
                                IFile file = (IFile)objects[k];
                                this.getSourceImports(file, list);
                            }
                            ++k;
                        }
                    }
                    IJavaElement[] elements = roots[i2].getChildren();
                    int j = 0;
                    while (j < elements.length) {
                        if (elements[j] instanceof ICompilationUnit) {
                            ICompilationUnit cu = (ICompilationUnit)elements[j];
                            list = this.getAllSourceImports(cu, list);
                        } else if (elements[j] instanceof IPackageFragment) {
                            IPackageFragment pack = (IPackageFragment)elements[j];
                            ICompilationUnit[] cunits = pack.getCompilationUnits();
                            int k = 0;
                            while (k < cunits.length) {
                                ICompilationUnit cu = cunits[k];
                                list = this.getAllSourceImports(cu, list);
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            return list;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Vector();
        }
    }

    public void getSourceImports(IFile file, Vector v) {
        if (file != null) {
            try {
                File osfile;
                String name;
                IPath path = file.getLocation().makeAbsolute();
                if (path != null && (name = path.lastSegment()).endsWith(".rules") && (osfile = path.makeAbsolute().toFile()).exists()) {
                    FileReader freader = new FileReader(osfile);
                    BufferedReader reader = new BufferedReader(freader);
                    boolean more = true;
                    while (more) {
                        String line = reader.readLine();
                        if (line == null) {
                            more = false;
                            continue;
                        }
                        if (!line.toLowerCase().startsWith("-includewholeclass")) continue;
                        StringTokenizer tokenizer = new StringTokenizer(line, "\" ");
                        String wname = "";
                        while (tokenizer.hasMoreTokens()) {
                            wname = tokenizer.nextToken();
                        }
                        String pname = this.getPackageName(wname);
                        if (v.contains(pname)) continue;
                        v.addElement(pname);
                    }
                    freader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private String getSourcePath(String path, String name, String variable) {
        IPath varPath;
        String variablePath;
        File var;
        String sourcePath;
        File file;
        String anchorName = this.getAnchorName(name);
        String preFolder = "";
        if (anchorName.lastIndexOf(File.separator) >= 0) {
            int slash = anchorName.lastIndexOf(File.separator);
            preFolder = anchorName.substring(0, slash);
            anchorName = anchorName.substring(slash + 1, anchorName.length());
        }
        if ((file = new File(sourcePath = String.valueOf(path) + File.separator + "source")).isDirectory()) {
            String[] list = file.list();
            int i = 0;
            while (i < list.length) {
                int j = 0;
                while (j < this.TYPES.length) {
                    if (list[i].equals("src-" + anchorName + this.TYPES[j])) {
                        if (preFolder.length() > 0) {
                            return String.valueOf(variable) + File.separator + preFolder + File.separator + "source" + File.separator + "src-" + anchorName + this.TYPES[j];
                        }
                        return String.valueOf(variable) + File.separator + "source" + File.separator + "src-" + anchorName + this.TYPES[j];
                    }
                    if (list[i].equals(String.valueOf(anchorName) + "-src" + this.TYPES[j])) {
                        if (preFolder.length() >= 0) {
                            return String.valueOf(variable) + File.separator + preFolder + File.separator + "source" + File.separator + anchorName + "-src" + this.TYPES[j];
                        }
                        return String.valueOf(variable) + File.separator + "source" + File.separator + anchorName + "-src" + this.TYPES[j];
                    }
                    ++j;
                }
                ++i;
            }
        }
        if ((var = new File(String.valueOf(variablePath = (varPath = JavaCore.getClasspathVariable((String)variable)).toOSString()) + File.separator + "source.jar")).exists()) {
            return String.valueOf(variable) + File.separator + "source.jar";
        }
        var = new File(String.valueOf(variablePath) + File.separator + "bundlefiles" + File.separator + "source.jar");
        if (var.exists()) {
            return String.valueOf(variable) + File.separator + "bundlefiles" + File.separator + "source.jar";
        }
        var = new File(String.valueOf(variablePath) + File.separator + "bundlefiles" + File.separator + "source" + File.separator + "source.jar");
        if (var.exists()) {
            return String.valueOf(variable) + File.separator + "bundlefiles" + File.separator + "source" + File.separator + "source.jar";
        }
        return String.valueOf(variable) + File.separator + name;
    }

    protected String getTechnologiesFolder() {
        IPath dk = JavaCore.getClasspathVariable((String)"DEVICEKIT");
        if (dk == null) {
            return null;
        }
        String dks = dk.makeAbsolute().toString();
        int slash = dks.lastIndexOf(File.separator);
        if (slash == -1) {
            slash = dks.lastIndexOf(File.separator);
        }
        if (slash == -1) {
            return null;
        }
        return dks.substring(0, slash);
    }

    public boolean getUpdate() {
        return this.update;
    }

    private void init(boolean update) {
        this.initExistingContainers();
    }

    private void initExistingContainers() {
        try {
            IClasspathEntry[] entries = this.project.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getEntryKind() == 5) {
                    this.addEntry(entries[i]);
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entries[i].getPath(), (IJavaProject)this.project);
                    if (container != null) {
                        IClasspathEntry[] conEntries = container.getClasspathEntries();
                        int j = 0;
                        while (j < conEntries.length) {
                            this.getContainerLibraries().add(conEntries[j].getPath().makeAbsolute());
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected boolean isContainerLibrary(IPath path) {
        List containerLibs = this.getContainerLibraries();
        int i = 0;
        while (i < containerLibs.size()) {
            IPath conPath = (IPath)containerLibs.get(i);
            if (conPath.equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isInCurrentClasspath(String packageName) {
        return this.getPackageFromCurrentProject(packageName) != null;
    }

    private boolean isInCurrentClasspath(IClasspathEntry entry, IClasspathEntry[] currentEntries) {
        if (entry != null) {
            int j = 0;
            while (j < currentEntries.length) {
                if (entry.getPath().equals((Object)currentEntries[j].getPath())) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    protected boolean osgiMinExists() {
        IVMInstallType type = JavaRuntime.getVMInstallType((String)"com.ibm.ive.internal.j9.launcher.J9VMType");
        if (type != null) {
            IVMInstall[] installs = type.getVMInstalls();
            int i = 0;
            while (i < installs.length) {
                if ("OSGIMin".equals(installs[i].getName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void run(IProgressMonitor progressMonitor) {
        try {
            String technologies;
            this.progressMonitor = progressMonitor;
            this.startClassPath();
            this.checkHasIndirectReference(this.project.getProject());
            String[] names = JavaCore.getClasspathVariableNames();
            int i = 0;
            while (i < names.length) {
                IPath path = JavaCore.getClasspathVariable((String)names[i]);
                this.checkFile(path.toOSString(), names[i]);
                ++i;
            }
            if (this.checkTechnologies && this.serviceList.size() > 0 && (technologies = this.getTechnologiesFolder()) != null && technologies.length() > 0) {
                this.checkTechnologies(technologies);
            }
            this.setupInitialClasspath(progressMonitor, this.project);
            String projectName = this.project.getElementName();
            if (projectName.endsWith("Test")) {
                this.addAllReferences(progressMonitor, this.project);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    protected boolean serviceSourceExistsInProject(String serviceName, IJavaProject jproject) throws CoreException {
        if (jproject.exists()) {
            IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (this.serviceSourceExistsInSourceFolder(serviceName, roots[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    protected boolean serviceSourceExistsInSourceFolder(String serviceName, IPackageFragmentRoot root) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 111->114)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setBundleNames(String[] bundleNames) {
        this.bundleNames = bundleNames;
    }

    private void setContainerLibraries(List containerLibraries) {
        this.containerLibraries = containerLibraries;
    }

    public void setPackages(Vector packages) {
        this.packages = packages;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public void setupInitialClasspath(IProgressMonitor progressMonitor, IJavaProject project) throws CoreException {
        try {
            Object[] entries = new IClasspathEntry[this.classPath.size()];
            this.classPath.copyInto(entries);
            Arrays.sort(entries, this);
            project.setRawClasspath((IClasspathEntry[])entries, progressMonitor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startClassPath() {
        block34: {
            this.init(this.getUpdate());
            try {
                IClasspathEntry ce;
                String name;
                IClasspathEntry[] entries = this.project.getRawClasspath();
                if (this.getUpdate()) {
                    int i = 0;
                    while (i < entries.length) {
                        IClasspathEntry entry = entries[i];
                        if (entry.getEntryKind() == 3) {
                            this.addEntry(entry);
                        } else if (JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry) == null) {
                            IPath path;
                            IPath ipath;
                            String[] names;
                            System.out.println("unresolved entry: " + entry);
                            if (entry.getEntryKind() == 4 && (names = (ipath = entry.getPath()).segments()).length > 1 && (path = JavaCore.getClasspathVariable((String)names[0])) != null) {
                                name = names[0];
                                String bundleFolders = "";
                                if (names.length > 2) {
                                    bundleFolders = names[1];
                                }
                                String variable = name;
                                String bname = String.valueOf(path.makeAbsolute().toFile().getPath()) + File.separator + bundleFolders;
                                File file = new File(bname);
                                if (file.exists()) {
                                    String[] list = file.list();
                                    int j = 0;
                                    while (j < list.length) {
                                        if (list[j].endsWith(".jar")) {
                                            try {
                                                int bresult = this.checkJar(String.valueOf(bname) + File.separator + list[j]);
                                                if (bresult > 0) {
                                                    String extension = String.valueOf(bundleFolders) + File.separator + list[j];
                                                    this.addJar(bname, extension, variable);
                                                }
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                        ++j;
                                    }
                                }
                            }
                        } else {
                            this.addEntry(entry);
                        }
                        ++i;
                    }
                } else {
                    IClasspathEntry entry = null;
                    IVMInstall install = JavaRuntime.getVMInstall((IJavaProject)this.project);
                    if (install != null) {
                        String name2 = "org.eclipse.jdt.launching.JRE_CONTAINER/" + install.getVMInstallType().getId() + '/' + install.getName();
                        entry = JavaCore.newContainerEntry((IPath)new Path(name2));
                    } else if (this.osgiMinExists()) {
                        entry = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER/com.ibm.ive.internal.j9.launcher.J9VMType/OSGIMin"));
                    }
                    this.addEntry(entry);
                    int i = 0;
                    while (i < entries.length) {
                        if (entries[i].getEntryKind() == 3) {
                            this.addEntry(entries[i]);
                        }
                        ++i;
                    }
                }
                if (this.project == null) break block34;
                Vector importList = this.getSourceImports(this.project);
                Vector importBundleList = this.getBundleImports(this.project);
                int j = 0;
                while (j < importBundleList.size()) {
                    String name3 = importBundleList.elementAt(j).toString();
                    if (!importList.contains(name3)) {
                        importList.addElement(name3);
                    }
                    ++j;
                }
                Vector cv = (Vector)importList.clone();
                int j2 = 0;
                while (j2 < cv.size()) {
                    String name4 = cv.elementAt(j2).toString();
                    IPackageFragment pf = this.findPackageSource(name4);
                    if (pf != null && pf.exists()) {
                        String pname = pf.getJavaProject().getElementName();
                        if (!pname.equals(this.project.getElementName())) {
                            ce = this.findClasspathSourceEntry(pname);
                            this.addEntry(ce);
                        }
                        importList.removeElement(name4);
                    }
                    ++j2;
                }
                this.setPackages(importList);
                Vector csv = (Vector)this.serviceList.clone();
                int j3 = 0;
                while (j3 < csv.size()) {
                    name = csv.elementAt(j3).toString();
                    IJavaProject jp = this.findServiceSource(name);
                    if (jp != null && jp.exists()) {
                        ce = this.findClasspathSourceEntry(jp.getElementName());
                        this.addEntry(ce);
                        this.serviceList.removeElement(name);
                    }
                    ++j3;
                }
                entries = this.project.getRawClasspath();
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getEntryKind() == 4 || entries[i].getEntryKind() == 1) {
                        try {
                            String path;
                            int tresult;
                            IClasspathEntry rentry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entries[i]);
                            if (rentry != null && (tresult = this.checkJar(path = rentry.getPath().toFile().getPath())) > 0) {
                                this.addEntry(entries[i]);
                            }
                        }
                        catch (Exception exception) {
                            System.out.println(exception);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

