/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.operation;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.soda.devicekit.generator.model.DeviceKitGenerator;
import org.eclipse.soda.devicekit.generator.util.DkJxeRuleGenerator;
import org.eclipse.soda.devicekit.generator.util.PreGenElementHolder;
import org.eclipse.soda.devicekit.ui.DeviceKitException;
import org.eclipse.soda.devicekit.util.DkmlReferenceResolver;
import org.eclipse.ui.WorkbenchException;
import org.w3c.dom.Node;

public class GenerateOperation
implements IWorkspaceRunnable {
    private Object[] generatedProjects;
    private Hashtable properties;
    private IFile[] files;
    private boolean jxeFileChanged = false;
    private String[] requiredClasses;
    private PreGenElementHolder customElements;
    private boolean custom;
    private boolean testAntScript = false;
    private boolean genManifest = false;

    public GenerateOperation(Hashtable variables, IFile[] files) {
        this(variables, files, false);
    }

    public GenerateOperation(Hashtable variables, IFile[] files, boolean custom) {
        this.files = files;
        this.custom = custom;
    }

    private boolean generateJxeRules(Node node, IFile dkmlFile, String[] required) throws Exception {
        DkJxeRuleGenerator gen = new DkJxeRuleGenerator(node, dkmlFile);
        if (required != null) {
            int i = 0;
            while (i < required.length) {
                gen.addRequiredEntry(required[i]);
                ++i;
            }
        }
        return gen.generate();
    }

    private boolean generateJxeRules(Node node, IFile dkmlFile) throws Exception {
        return this.generateJxeRules(node, dkmlFile, this.getRequiredClasses());
    }

    public boolean generateTestScript() {
        return this.testAntScript;
    }

    public PreGenElementHolder getCustomElements() {
        return this.customElements;
    }

    public Object[] getGeneratedProjects() {
        return this.generatedProjects;
    }

    private Hashtable getMethodProperties() {
        return this.properties;
    }

    private Object[] getProjectsFromFiles(Vector cus) {
        Vector<IJavaProject> result = new Vector<IJavaProject>();
        int i = 0;
        while (i < cus.size()) {
            ICompilationUnit cu = (ICompilationUnit)cus.elementAt(i);
            if (!result.contains(cu.getParent().getJavaProject())) {
                result.addElement(cu.getParent().getJavaProject());
            }
            ++i;
        }
        return result.toArray();
    }

    private Vector getReferencedFiles(IFile file) throws CoreException {
        try {
            DkmlReferenceResolver resolver = new DkmlReferenceResolver(file);
            return resolver.getReferences();
        }
        catch (Exception e) {
            throw new WorkbenchException(e.getMessage(), (Throwable)e);
        }
    }

    private String[] getRequiredClasses() {
        return this.requiredClasses;
    }

    protected CoreException handleError(Exception e) throws CoreException {
        throw new DeviceKitException(String.valueOf(e), e);
    }

    public boolean jxeFileChanged() {
        return this.jxeFileChanged;
    }

    public void run(IProgressMonitor progressMonitor) throws CoreException {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        monitor.beginTask("Generating", this.files.length * 4);
        StringBuffer errorBuffer = new StringBuffer(1024);
        int i = 0;
        while (i < this.files.length) {
            if (!monitor.isCanceled()) {
                IFile file = this.files[i];
                String projectName = file.getProject().getName();
                try {
                    monitor.setTaskName(String.valueOf(projectName) + '/' + file.getName());
                    DeviceKitGenerator dkg = new DeviceKitGenerator(monitor, this.files[i], this.getReferencedFiles(this.files[i]), this.custom, this.genManifest);
                    dkg.setMethodProperties(this.getMethodProperties());
                    String schema = null;
                    dkg.setSchema(schema);
                    monitor.worked(1);
                    dkg.generate();
                    monitor.worked(2);
                    this.customElements = dkg.getCustomHolder();
                    this.setGeneratedProjects(this.getProjectsFromFiles(dkg.getGeneratedFiles()));
                    if (dkg.generateTestScript()) {
                        this.testAntScript = true;
                    }
                    monitor.worked(1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errorBuffer.append(projectName);
                    errorBuffer.append('/');
                    errorBuffer.append(file.getName());
                    errorBuffer.append(' ');
                    errorBuffer.append(e);
                    errorBuffer.append('\n');
                }
            }
            ++i;
        }
        if (errorBuffer.length() > 0) {
            throw new DeviceKitException(errorBuffer.toString());
        }
        monitor.done();
    }

    public void setGenerateManifest(boolean genManifest) {
        this.genManifest = genManifest;
    }

    protected void setGeneratedProjects(Object[] generatedProjects) {
        this.generatedProjects = generatedProjects;
    }

    public void setMethodProperties(Hashtable properties) {
        this.properties = properties;
    }

    protected void setRequiredClasses(String[] requiredClasses) {
        this.requiredClasses = requiredClasses;
    }
}

