/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.preference;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public abstract class DeviceKitAdvancedPreferencePage
extends PreferencePage {
    private Button addButton;
    private Button removeButton;
    private List superClassList;
    private int superListSelection = -1;
    private SelectionListener superClassListener;
    private SelectionListener addSelectionListener;
    private SelectionListener removeSelectionListener;

    protected DeviceKitAdvancedPreferencePage() {
    }

    protected DeviceKitAdvancedPreferencePage(String title) {
        super(title);
    }

    protected DeviceKitAdvancedPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected void addListeners() {
        List superList = this.getSuperClassList();
        Object listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                DeviceKitAdvancedPreferencePage.this.listSelected();
            }
        };
        superList.addSelectionListener(listener);
        this.setSuperClassListener((SelectionListener)listener);
        Button add = this.getAddButton();
        listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                DeviceKitAdvancedPreferencePage.this.addPressed();
            }
        };
        add.addSelectionListener(listener);
        this.setAddListener((SelectionListener)listener);
        Button remove = this.getRemoveButton();
        listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                DeviceKitAdvancedPreferencePage.this.removePressed();
            }
        };
        remove.addSelectionListener(listener);
        this.setRemoveListener((SelectionListener)listener);
    }

    protected void addPressed() {
        try {
            List list;
            String newEntry = this.openTypeDialog("Select Super Class", "Select the super class", 5, this.getSuperClassFilter());
            if (newEntry != null && (list = this.getSuperClassList()).indexOf(newEntry) == -1) {
                list.add(newEntry);
            }
        }
        catch (Exception exception) {}
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData data = new GridData(1810);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText(this.getSuperClassText());
        data = new GridData(4);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Composite scComposite = new Composite(composite, 0);
        layout = new GridLayout(1, false);
        scComposite.setLayout((Layout)layout);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        scComposite.setLayoutData((Object)data);
        List list = new List(scComposite, 2816);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        data.heightHint = this.getListHeightHint(list);
        data.widthHint = this.getListWidthHint();
        list.setLayoutData((Object)data);
        String[] items = this.getStoredSuperClassItems();
        list.setItems(items);
        this.setSuperClassList(list);
        Composite buttonComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(2);
        buttonComposite.setLayoutData((Object)data);
        Button add = new Button(buttonComposite, 0x1000008);
        add.setText("Add");
        data = new GridData(2);
        data.horizontalSpan = 1;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, add.computeSize((int)-1, (int)-1, (boolean)true).x);
        add.setLayoutData((Object)data);
        this.setAddButton(add);
        Button remove = new Button(buttonComposite, 0x1000008);
        remove.setText("Remove");
        data = new GridData(2);
        data.horizontalSpan = 1;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, remove.computeSize((int)-1, (int)-1, (boolean)true).x);
        remove.setLayoutData((Object)data);
        this.setRemoveButton(remove);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return DeviceKitPlugin.getDefault().getPreferenceStore();
    }

    protected Button getAddButton() {
        return this.addButton;
    }

    private SelectionListener getAddListener() {
        return this.addSelectionListener;
    }

    protected Font getBoldFont() {
        return JFaceResources.getBannerFont();
    }

    protected int getListHeightHint(List list) {
        return list.getItemHeight() * 12;
    }

    protected int getListWidthHint() {
        return 250;
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    private SelectionListener getRemoveListener() {
        return this.removeSelectionListener;
    }

    private IRunnableContext getRunnable() {
        return new ProgressMonitorDialog(this.getShell());
    }

    protected String[] getStoredSuperClassItems() {
        String[] items;
        String superClasses = DeviceKitPlugin.getDefault().getPluginPreferences().getString(this.getSuperClassKey());
        if (superClasses != null && !superClasses.equals("null") && (items = DeviceKitPreferenceInitializer.parsePrefArray((String)superClasses)) != null) {
            return items;
        }
        return new String[0];
    }

    public String getSuperClassFilter() {
        return "";
    }

    public abstract String getSuperClassKey();

    protected List getSuperClassList() {
        return this.superClassList;
    }

    private int getSuperClassListSelection() {
        return this.superListSelection;
    }

    private SelectionListener getSuperClassListener() {
        return this.superClassListener;
    }

    public abstract String getSuperClassText();

    protected void listSelected() {
        List list = this.getSuperClassList();
        this.setSuperClassListSelection(list.getSelectionIndex());
    }

    protected String openTypeDialog(String title, String message, int elementKinds, String filter) throws Exception {
        JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
        IJavaProject[] projects = model.getJavaProjects();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])projects);
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, this.getRunnable(), scope, elementKinds);
        dialog.setInitialPattern(filter);
        dialog.setTitle(title);
        dialog.setMessage(message);
        if (dialog.open() == 0) {
            IType type = (IType)dialog.getFirstResult();
            return type.getFullyQualifiedName();
        }
        return null;
    }

    protected void performApply() {
        this.storeValues();
        super.performApply();
    }

    protected void performDefaults() {
        super.performDefaults();
        String[] defaults = DeviceKitPreferenceInitializer.getDefault((String)this.getSuperClassKey());
        List list = this.getSuperClassList();
        list.setItems(defaults);
        this.setSuperClassListSelection(-1);
    }

    public boolean performOk() {
        this.storeValues();
        return super.performOk();
    }

    protected void removeListeners() {
        Button remove = this.getRemoveButton();
        SelectionListener removeListener = this.getRemoveListener();
        remove.removeSelectionListener(removeListener);
        Button add = this.getAddButton();
        SelectionListener addListener = this.getAddListener();
        add.removeSelectionListener(addListener);
        List superList = this.getSuperClassList();
        SelectionListener superListener = this.getSuperClassListener();
        superList.removeSelectionListener(superListener);
    }

    protected void removePressed() {
        List list;
        int selection = this.getSuperClassListSelection();
        if (selection != -1 && (list = this.getSuperClassList()).getItemCount() > 0) {
            list.remove(selection);
        }
    }

    private void setAddButton(Button add) {
        this.addButton = add;
    }

    private void setAddListener(SelectionListener listener) {
        this.addSelectionListener = listener;
    }

    private void setRemoveButton(Button remove) {
        this.removeButton = remove;
    }

    private void setRemoveListener(SelectionListener listener) {
        this.removeSelectionListener = listener;
    }

    private void setSuperClassList(List list) {
        this.superClassList = list;
    }

    private void setSuperClassListSelection(int index) {
        this.superListSelection = index;
    }

    private void setSuperClassListener(SelectionListener listener) {
        this.superClassListener = listener;
    }

    protected void storeValues() {
        List list = this.getSuperClassList();
        String[] prefValue = list.getItems();
        DeviceKitPreferenceInitializer.setPreference((String)this.getSuperClassKey(), (String[])prefValue);
    }
}

