/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.preference;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.soda.devicekit.generator.GeneratorPlugin;
import org.eclipse.soda.devicekit.generator.utilty.SortedSet;
import org.eclipse.soda.devicekit.ui.preference.LeafItem;
import org.eclipse.soda.devicekit.ui.preference.ParentItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GeneratorTemplatesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener,
ITreeContentProvider,
ILabelProvider {
    private TemplatePersistenceData[] templatePersistenceDatas = new TemplatePersistenceData[0];
    private ParentItem currentSelection;
    private Tree tree;
    private ParentItem[] parents;
    private TreeViewer treeViewer;
    private Text text;
    private List list;

    public GeneratorTemplatesPreferencePage() {
    }

    public GeneratorTemplatesPreferencePage(String title) {
        super(title);
    }

    public GeneratorTemplatesPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    protected Control createContents(Composite parent) {
        TemplateStore templateStore = GeneratorPlugin.getDefault().getTemplateStore();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData data = new GridData(1808);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        this.templatePersistenceDatas = templateStore.getTemplateData(false);
        if (this.templatePersistenceDatas != null) {
            data = new GridData(1808);
            data.horizontalSpan = 3;
            data.verticalSpan = 1;
            this.tree = new Tree(composite, 2816);
            this.treeViewer = new TreeViewer(this.tree);
            this.tree.setLayoutData((Object)data);
            this.tree.addSelectionListener((SelectionListener)this);
            SortedSet set = new SortedSet();
            SortedSet roots = new SortedSet();
            int i = 0;
            while (i < this.templatePersistenceDatas.length) {
                TemplatePersistenceData templatePersistenceData = this.templatePersistenceDatas[i];
                String name = templatePersistenceData.getTemplate().getName();
                String id = templatePersistenceData.getId();
                set.addElement((Object)id);
                int index = id.indexOf(47);
                if (index >= 0) {
                    String root = id.substring(0, index);
                    int indexName = name.lastIndexOf(47);
                    roots.addElement((Object)new ParentItem(root, name.substring(0, indexName)));
                } else {
                    roots.addElement((Object)new ParentItem(id, name));
                }
                ++i;
            }
            this.treeViewer.setContentProvider((IContentProvider)this);
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this);
            Object[] parents = new ParentItem[roots.size()];
            this.parents = (ParentItem[])roots.toArray(parents);
            Object[] ids = new String[set.size()];
            ids = (String[])set.toArray(ids);
            int i2 = 0;
            while (i2 < parents.length) {
                ((ParentItem)parents[i2]).collectChildren((String[])ids, templateStore);
                ++i2;
            }
            this.treeViewer.setInput((Object)parents);
        }
        this.text = new Text(composite, 2050);
        TemplatePersistenceData templateData = templateStore.getTemplateData("org.eclipse.soda.devicekit.generator.templates.copyright");
        String pattern = templateData.getTemplate().getPattern();
        if (pattern != null) {
            this.text.setText(pattern);
        }
        data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 1;
        this.text.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ParentItem) {
            return ((ParentItem)parentElement).getItems();
        }
        return null;
    }

    public ParentItem getCurrentSelection() {
        return this.currentSelection;
    }

    public Object[] getElements(Object inputElement) {
        return (Object[])inputElement;
    }

    public Image getImage(Object element) {
        return null;
    }

    public List getList() {
        return this.list;
    }

    protected int getListHeightHint(List list) {
        return list.getItemHeight() << 2;
    }

    public Object getParent(Object element) {
        return null;
    }

    public ParentItem[] getParents() {
        return this.parents;
    }

    public TemplatePersistenceData[] getTemplatePersistenceDatas() {
        return this.templatePersistenceDatas;
    }

    public String getText(Object element) {
        if (element instanceof ParentItem) {
            return ((ParentItem)element).getName();
        }
        if (element instanceof TemplatePersistenceData) {
            return ((TemplatePersistenceData)element).getTemplate().getName();
        }
        return element.toString();
    }

    public Text getText() {
        return this.text;
    }

    public Tree getTree() {
        return this.tree;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ParentItem) {
            return ((ParentItem)element).getItems().length > 0;
        }
        return false;
    }

    public void init(IWorkbench workbench) {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    protected void performApply() {
        ParentItem[] parents = this.getParents();
        if (parents != null) {
            ParentItem currentSelection = this.getCurrentSelection();
            if (currentSelection instanceof LeafItem) {
                LeafItem leafItem = (LeafItem)currentSelection;
                leafItem.setContents(this.text.getText());
            }
            int i = 0;
            while (i < parents.length) {
                parents[i].save();
                ++i;
            }
        }
        super.performApply();
    }

    protected void performDefaults() {
        ParentItem[] parents = this.getParents();
        if (parents != null) {
            int i = 0;
            while (i < parents.length) {
                parents[i].revert();
                ++i;
            }
        }
        super.performDefaults();
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void setCurrentSelection(ParentItem currentSelection) {
        this.currentSelection = currentSelection;
    }

    public void setList(List list) {
        this.list = list;
    }

    public void setParents(ParentItem[] parents) {
        this.parents = parents;
    }

    public void setTemplatePersistenceDatas(TemplatePersistenceData[] templatePersistenceDatas) {
        this.templatePersistenceDatas = templatePersistenceDatas;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    public void setTreeViewer(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        TreeItem[] items = ((Tree)e.widget).getSelection();
        if (items != null && items.length > 0) {
            TreeItem item = items[0];
            Object data = item.getData();
            if (data instanceof ParentItem) {
                if (data != this.getCurrentSelection()) {
                    ParentItem currentSelection = this.getCurrentSelection();
                    if (currentSelection instanceof LeafItem) {
                        LeafItem leafItem = (LeafItem)currentSelection;
                        leafItem.setContents(this.text.getText());
                    }
                    this.text.setText(((ParentItem)data).getContents());
                    this.setCurrentSelection((ParentItem)data);
                }
            } else {
                this.text.setText("");
                this.setCurrentSelection(null);
            }
        }
    }
}

