/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.preference;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.generator.util.JREPreferenceUtil;
import org.eclipse.soda.devicekit.preference.jre.DeviceKitJREConstants;
import org.eclipse.soda.devicekit.ui.preference.ExecutionEnvironmentsControl;
import org.eclipse.soda.devicekit.ui.preference.JREinClasspathControl;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JREPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite contents = null;
    private JREinClasspathControl JREinClasspath;
    private ExecutionEnvironmentsControl executionEnvironments;
    private String currentProjectType;

    public JREPreferencePage() {
        super("DeviceKit JRE");
        this.setPreferenceStore(DeviceKitPlugin.getDefault().getPreferenceStore());
    }

    protected void JreInClasspathControlSelected() {
        String selectedJRE = this.JREinClasspath.getResult();
        if (JREPreferenceUtil.getDefaultJreInClasspath((String)this.currentProjectType).equals(selectedJRE)) {
            this.executionEnvironments.getEETableViewer().setInput((Object)JREPreferenceUtil.getDefaultExecutionEnvironments((String)this.currentProjectType));
        } else if (!DeviceKitJREConstants.WORKSPACE_DEFAULT_JRE.equals(selectedJRE)) {
            this.executionEnvironments.getEETableViewer().setInput((Object)new String[]{selectedJRE});
        } else {
            this.executionEnvironments.getEETableViewer().setInput((Object)new String[0]);
        }
    }

    protected void addListeners() {
        this.JREinClasspath.getWorkspaceDefaultJREButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JREPreferencePage.this.JreInClasspathControlSelected();
            }
        });
        this.JREinClasspath.getJreInClasspathCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JREPreferencePage.this.JreInClasspathControlSelected();
            }
        });
        this.JREinClasspath.getExecutionEnvironmentsButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JREPreferencePage.this.JreInClasspathControlSelected();
            }
        });
    }

    protected Control createContents(Composite parent) {
        this.contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.contents.setLayout((Layout)layout);
        this.JREinClasspath = new JREinClasspathControl((DialogPage)this, JREPreferenceUtil.getJreInClasspath((String)this.currentProjectType));
        this.JREinClasspath.createControl(this.contents);
        GridData labelGridData = new GridData(770);
        labelGridData.horizontalSpan = 3;
        Label seperator = new Label(parent, 16384);
        seperator.setText("");
        seperator.setLayoutData((Object)labelGridData);
        this.executionEnvironments = new ExecutionEnvironmentsControl((DialogPage)this, JREPreferenceUtil.getExecutionEnvironments((String)this.currentProjectType));
        this.executionEnvironments.setButtonWidthHint(this.convertHorizontalDLUsToPixels(61));
        this.executionEnvironments.createControl(this.contents);
        this.addListeners();
        return this.contents;
    }

    public void init(IWorkbench workbench) {
        this.currentProjectType = DeviceKitJREConstants.PROJECT_TYPE_BY_JRE_DEFAULT;
    }

    protected void performDefaults() {
        this.JREinClasspath.setInput(JREPreferenceUtil.getDefaultJreInClasspath((String)this.currentProjectType));
        this.executionEnvironments.getEETableViewer().setInput((Object)JREPreferenceUtil.getDefaultExecutionEnvironments((String)this.currentProjectType));
    }

    public boolean performOk() {
        this.storeValues();
        return super.performOk();
    }

    private void storeValues() {
        JREPreferenceUtil.saveJreInClasspath((String)this.currentProjectType, (String)this.JREinClasspath.getResult());
        JREPreferenceUtil.saveExecutionEnvironments((String)this.currentProjectType, (String[])this.executionEnvironments.getEETableItems());
    }
}

