/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.profile.operation;

import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;
import org.eclipse.soda.devicekit.ui.profile.operation.ProfileOperation;
import org.eclipse.soda.devicekit.util.DkmlFileFinder;

public class ProfileImplementationOperation
extends ProfileOperation {
    public ProfileImplementationOperation(Hashtable variables, DkmlFileFinder finder) {
        super(variables);
        this.setFinder(finder);
    }

    protected void addProfileDkmlBody(IXmlElement dkmlElement) {
        IXmlElement element = dkmlElement.addElement("profile");
        boolean abstractState = this.createCommonTop(element);
        Object parent = this.getVariables().get("profileparent");
        if (parent != null) {
            String simpleName = parent.toString();
            IXmlElement profileParent = element.addElement("profileparent");
            IXmlElement profile = profileParent.addElement("profileref");
            String profileName = String.valueOf(simpleName) + "Profile";
            StringBuffer refBuffer = new StringBuffer(128);
            IFile file = this.getFinder().findFile("profile", profileName);
            if (file != null && file.exists()) {
                String projectId = file.getProject().getName();
                refBuffer.append(projectId);
            } else {
                String packageBase = this.getPackageBase();
                refBuffer.append(this.getNewBundleName(profileName, packageBase));
            }
            refBuffer.append("/dk/profile.xml#");
            refBuffer.append(profileName);
            profile.addAttribute("idref", refBuffer.toString());
        }
        IXmlElement adapter = element.addElement("adapter");
        String simpleName = (String)this.getVariables().get("name");
        String adapterName = String.valueOf(simpleName) + "Adapter";
        StringBuffer refBuffer = new StringBuffer(128);
        String packageBase = this.getPackageBase();
        refBuffer.append(this.getNewBundleName(adapterName, packageBase));
        refBuffer.append("/dk/adapter.xml#");
        refBuffer.append(adapterName);
        adapter.addAttribute("idref", refBuffer.toString());
        IXmlElement device = element.addElement("device");
        simpleName = (String)this.getVariables().get("name");
        String deviceName = String.valueOf(simpleName) + "Device";
        refBuffer = new StringBuffer(128);
        packageBase = this.getPackageBase();
        refBuffer.append(this.getNewBundleName(deviceName, packageBase));
        refBuffer.append("/dk/device.xml#");
        refBuffer.append(deviceName);
        device.addAttribute("idref", refBuffer.toString());
        if (!abstractState) {
            this.addCommonBundle(element);
        }
    }

    protected String getNameFull() {
        String name = (String)this.getVariables().get("name");
        Object parent = this.getVariables().get("profileparent");
        if (parent != null) {
            String parentName = parent.toString();
            if (parentName.startsWith("Rfid")) {
                parentName = parentName.substring(4);
            }
            return String.valueOf(name) + parentName + "Profile";
        }
        return super.getNameFull();
    }
}

