/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.receiver.operation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;
import org.eclipse.soda.devicekit.generator.model.xml.XmlModel;
import org.eclipse.soda.devicekit.ui.operation.DeviceKitGenerateOperation;
import org.eclipse.soda.devicekit.ui.receiver.wizard.ReceiverMessages;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;

public class ReceiverOperation
extends DeviceKitGenerateOperation
implements IWorkspaceRunnable {
    private String custom;
    private String file;
    private IWizardMessages messages = ReceiverMessages.getInstance();
    private String serial;
    private String tcpip;
    private String tcpipserver;
    private String ssl;
    private String sslserver;
    private String url;
    private String usb;

    public ReceiverOperation(Hashtable variables) {
        super(variables);
        this.custom = this.messages.getString("custom");
        this.file = this.messages.getString("file");
        this.serial = this.messages.getString("serial");
        this.tcpip = this.messages.getString("tcpip");
        this.tcpipserver = this.messages.getString("tcpipserver");
        this.ssl = this.messages.getString("ssl");
        this.sslserver = this.messages.getString("sslserver");
        this.url = this.messages.getString("url");
        this.usb = this.messages.getString("usb");
    }

    protected void addConnectionDkml(IXmlElement element, String connection) {
        if (this.custom.equals(connection)) {
            this.handleCustomConnection(element);
        } else if (this.file.equals(connection)) {
            this.handleFileConnection(element);
        } else if (this.serial.equals(connection)) {
            this.handleSerialConnection(element);
        } else if (this.tcpip.equals(connection)) {
            this.handleTcpipConnection(element);
        } else if (this.tcpipserver.equals(connection)) {
            this.handleTcpipServerConnection(element);
        } else if (this.ssl.equals(connection)) {
            this.handleSSLConnection(element);
        } else if (this.sslserver.equals(connection)) {
            this.handleSSLServerConnection(element);
        } else if (this.url.equals(connection)) {
            this.handleUrlConnection(element);
        } else if (this.usb.equals(connection)) {
            this.handleUsbConnection(element);
        }
    }

    protected void addDkmlBody(IXmlElement element, int type) {
        switch (type) {
            case 0: {
                this.addReceiverDkmlBody(element);
                break;
            }
            case 1: {
                this.addReceiverTestDkmlBody(element);
            }
        }
    }

    protected void addReceiverDkmlBody(IXmlElement dkmlElement) {
        String connection;
        IXmlElement element = dkmlElement.addElement("receiver");
        boolean abstractState = this.createCommonTop(element);
        String responseTimeout = (String)this.getVariables().get("response.timeout");
        if (responseTimeout != null && responseTimeout.trim().length() > 0) {
            IXmlElement rt = element.addElement("responsetimeout");
            rt.setData(responseTimeout.trim());
        }
        if ((connection = (String)this.getVariables().get("connection")) != null && connection.trim().length() > 0) {
            this.addConnectionDkml(element, connection);
        }
        if (!abstractState) {
            this.addCommonBundle(element);
        }
    }

    protected void addReceiverTestDkmlBody(IXmlElement dkmlElement) {
        IXmlElement test = dkmlElement.addElement("receivertest");
        String name = this.getName();
        this.addCommonTestTop(test);
        IXmlElement receiver = test.addElement("receiver");
        StringBuffer refBuffer = new StringBuffer(128);
        refBuffer.append(this.getProjectName());
        refBuffer.append("/dk/receiver.xml#");
        refBuffer.append(name);
        receiver.addAttribute("idref", refBuffer.toString());
        if (this.doGenerateTestcase()) {
            test.addElement("testcase");
        }
        this.addCommonBundle(test);
    }

    protected IFile createDkmlFile(int type, IFolder folder, IProgressMonitor monitor) throws CoreException {
        IFile iFile;
        InputStream stream = null;
        try {
            String name = "receiver.xml";
            if (type == 1) {
                name = "receiver_test.xml";
            }
            XmlModel model = new XmlModel(name);
            this.populateTemplateModel(model, type);
            String contents = model.getContents();
            stream = new BufferedInputStream(new ByteArrayInputStream(contents.getBytes()));
            IFile file = folder.getFile(name);
            file.create(stream, true, monitor);
            iFile = file;
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                stream.close();
                stream = null;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stream.close();
            stream = null;
        }
        catch (IOException iOException) {}
        return iFile;
    }

    protected String getName() {
        String name = (String)this.getVariables().get("name");
        name = String.valueOf(name) + "Receiver";
        return name;
    }

    protected String[] getRequiredClasses() {
        return new String[0];
    }

    private void handleCustomConnection(IXmlElement element) {
        String implementation = (String)this.getVariables().get("custom.connection.implementation");
        IXmlElement connectionElement = element.addElement("connection");
        connectionElement.addAttribute("implementation", implementation);
    }

    private void handleFileConnection(IXmlElement element) {
        String ip = (String)this.getVariables().get("connection.inputpath");
        String in = (String)this.getVariables().get("connection.inputname");
        String op = (String)this.getVariables().get("connection.outputpath");
        String on = (String)this.getVariables().get("connection.outputname");
        IXmlElement fileElement = element.addElement("file");
        IXmlElement inputNameElement = fileElement.addElement("inputname");
        inputNameElement.setData(in.trim());
        IXmlElement inputPathElement = fileElement.addElement("inputpath");
        inputPathElement.setData(ip.trim());
        IXmlElement outputNameElement = fileElement.addElement("outputname");
        outputNameElement.setData(on.trim());
        IXmlElement outputPathElement = fileElement.addElement("outputpath");
        outputPathElement.setData(op.trim());
    }

    private void handleSSLConnection(IXmlElement element) {
        String host = (String)this.getVariables().get("connection.host");
        String remotePort = (String)this.getVariables().get("connection.remote.port");
        String localPort = (String)this.getVariables().get("connection.local.port");
        String linger = (String)this.getVariables().get("connection.linger");
        IXmlElement tcpipElement = element.addElement("ssl");
        if (host != null && host.length() > 0) {
            IXmlElement hostElement = tcpipElement.addElement("host");
            hostElement.setData(host.trim());
        }
        if (linger != null && linger.length() > 0) {
            IXmlElement lingerElement = tcpipElement.addElement("linger");
            lingerElement.setData(linger.trim());
        }
        if (localPort != null && localPort.length() > 0) {
            IXmlElement localPortElement = tcpipElement.addElement("localport");
            localPortElement.setData(localPort);
        }
        if (remotePort != null && remotePort.length() > 0) {
            IXmlElement remotePortElement = tcpipElement.addElement("remoteport");
            remotePortElement.setData(remotePort);
        }
    }

    private void handleSSLServerConnection(IXmlElement element) {
        String port = (String)this.getVariables().get("connection.port");
        IXmlElement sslServerElement = element.addElement("sslserver");
        if (port != null && port.length() > 0) {
            IXmlElement portElement = sslServerElement.addElement("port");
            portElement.setData(port);
        }
    }

    private void handleSerialConnection(IXmlElement element) {
        String baudRate = (String)this.getVariables().get("connection.baud.rate");
        String comPort = (String)this.getVariables().get("connection.com.port");
        String dataBits = (String)this.getVariables().get("connection.data.bits");
        String hwFlowControl = (String)this.getVariables().get("connection.hardware.flow.control");
        String parity = (String)this.getVariables().get("connection.parity");
        String readIntervalTimeout = (String)this.getVariables().get("connection.read.interval.timeout");
        String readTotalTimeout = (String)this.getVariables().get("connection.read.total.timeout");
        String swFlowControl = (String)this.getVariables().get("connection.software.flow.control");
        String stopBits = (String)this.getVariables().get("connection.stop.bits");
        String writeTotalTimeout = (String)this.getVariables().get("connection.write.total.timeout");
        IXmlElement serialElement = element.addElement("serial");
        IXmlElement baudRateElement = serialElement.addElement("baudrate");
        baudRateElement.setData(baudRate);
        IXmlElement comPortElement = serialElement.addElement("comport");
        comPortElement.setData(comPort);
        IXmlElement dataBitsElement = serialElement.addElement("databits");
        dataBitsElement.setData(dataBits);
        IXmlElement hwFlowControlElement = serialElement.addElement("hardwareflowcontrol");
        if (hwFlowControl.equals("true")) {
            hwFlowControlElement.setData("1");
        } else {
            hwFlowControlElement.setData("0");
        }
        IXmlElement parityElement = serialElement.addElement("parity");
        parityElement.setData(parity);
        IXmlElement readIntervalTimeoutElement = serialElement.addElement("readintervaltimeout");
        readIntervalTimeoutElement.setData(readIntervalTimeout);
        IXmlElement readTotalTimeoutElement = serialElement.addElement("readtotaltimeout");
        readTotalTimeoutElement.setData(readTotalTimeout);
        IXmlElement swFlowControlElement = serialElement.addElement("softwareflowcontrol");
        if (swFlowControl.equals("true")) {
            swFlowControlElement.setData("1");
        } else {
            swFlowControlElement.setData("0");
        }
        IXmlElement stopBitsElement = serialElement.addElement("stopbits");
        stopBitsElement.setData(stopBits);
        IXmlElement writeTotalTimeoutElement = serialElement.addElement("writetotaltimeout");
        writeTotalTimeoutElement.setData(writeTotalTimeout);
    }

    private void handleTcpipConnection(IXmlElement element) {
        String host = (String)this.getVariables().get("connection.host");
        String remotePort = (String)this.getVariables().get("connection.remote.port");
        String localPort = (String)this.getVariables().get("connection.local.port");
        String linger = (String)this.getVariables().get("connection.linger");
        IXmlElement tcpipElement = element.addElement("tcpip");
        if (host != null && host.length() > 0) {
            IXmlElement hostElement = tcpipElement.addElement("host");
            hostElement.setData(host.trim());
        }
        if (linger != null && linger.length() > 0) {
            IXmlElement lingerElement = tcpipElement.addElement("linger");
            lingerElement.setData(linger.trim());
        }
        if (localPort != null && localPort.length() > 0) {
            IXmlElement localPortElement = tcpipElement.addElement("localport");
            localPortElement.setData(localPort);
        }
        if (remotePort != null && remotePort.length() > 0) {
            IXmlElement remotePortElement = tcpipElement.addElement("remoteport");
            remotePortElement.setData(remotePort);
        }
    }

    private void handleTcpipServerConnection(IXmlElement element) {
        String port = (String)this.getVariables().get("connection.port");
        IXmlElement tcpipServerElement = element.addElement("tcpipserver");
        if (port != null && port.length() > 0) {
            IXmlElement portElement = tcpipServerElement.addElement("port");
            portElement.setData(port);
        }
    }

    private void handleUrlConnection(IXmlElement element) {
        String url = (String)this.getVariables().get("connection.url");
        IXmlElement urlConnectionElement = element.addElement("urlconnection");
        IXmlElement urlElement = urlConnectionElement.addElement("url");
        urlElement.setData(url);
    }

    private void handleUsbConnection(IXmlElement element) {
        String productId = (String)this.getVariables().get("connection.product.id");
        String usage = (String)this.getVariables().get("connection.usage");
        String usagePage = (String)this.getVariables().get("connection.usage.page");
        String vendorId = (String)this.getVariables().get("connection.vendor.id");
        IXmlElement usbElement = element.addElement("usb");
        IXmlElement productIdElement = usbElement.addElement("productid");
        productIdElement.setData(productId);
        IXmlElement usageElement = usbElement.addElement("usage");
        usageElement.setData(usage);
        IXmlElement usagePageElement = usbElement.addElement("usagepage");
        usagePageElement.setData(usagePage);
        IXmlElement vendorIdElement = usbElement.addElement("vendorid");
        vendorIdElement.setData(vendorId);
    }
}

