/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.utility.operation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.soda.devicekit.ui.utility.operation.SourceOperation;

public class FixPackageSource
extends SourceOperation {
    protected static final Properties Table = FixPackageSource.createProperties();
    static /* synthetic */ Class class$0;

    public static Properties createProperties() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.ui.utility.operation.FixPackageSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream fis = clazz.getResourceAsStream("package.properties");
        Properties properties = new Properties();
        try {
            properties.load(fis);
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public void better(StringBuffer buffer, String value) {
        char character;
        boolean upper = false;
        char[] characters = value.toCharArray();
        int i = 0;
        while (i < characters.length) {
            character = characters[i];
            if (Character.isDigit(character)) {
                upper = true;
            }
            ++i;
        }
        i = 0;
        while (i < characters.length) {
            character = characters[i];
            if (i == 0 || upper) {
                buffer.append(Character.toUpperCase(character));
            } else {
                buffer.append(character);
            }
            ++i;
        }
    }

    public void processJavaPackage(IPackageFragment javaPackage, boolean refresh) {
        int cuSize = 0;
        try {
            ICompilationUnit[] compilationUnits = javaPackage.getCompilationUnits();
            cuSize = compilationUnits.length;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        if (cuSize > 0) {
            IContainer pcontainer;
            IResource packageObject;
            String type = "Base";
            String group = "";
            String name = javaPackage.getElementName();
            File path = ResourceUtil.getResource((Object)javaPackage).getRawLocation().makeAbsolute().toFile();
            String fullname = path.toString();
            fullname = String.valueOf(fullname) + "/package.html";
            StringBuffer buffer = new StringBuffer(2048);
            this.addEntity("Name", name);
            this.addEntity("MetaKeywords", name);
            this.template("packages.txt", buffer);
            StringTokenizer stringTokenizer = new StringTokenizer(name, ".");
            while (stringTokenizer.hasMoreTokens()) {
                String token = stringTokenizer.nextToken();
                if (token.equals("connection")) {
                    type = "<b>Connection</b> layer";
                } else if (token.equals("transport")) {
                    type = "<b>Transport</b> layer";
                } else if (token.equals("receiver")) {
                    type = "<b>Receiver Transport</b> layer";
                } else if (token.equals("device") || token.equals("concrete") || token.equals("measurement") || token.equals("command") || token.equals("signal")) {
                    type = "<b>Device</b> layer";
                } else if (token.equals("rfid") || token.equals("epc")) {
                    group = "RFID";
                } else if (token.startsWith("j") || token.equals("most")) {
                    group = "Telematics";
                }
                Object value = Table.get(token);
                if (value == null) {
                    buffer.append(' ');
                    this.better(buffer, token);
                    continue;
                }
                if (value.toString().length() <= 0) continue;
                buffer.append(' ');
                buffer.append(value);
            }
            if (name.endsWith(".service")) {
                buffer.append(" interfaces");
            } else {
                buffer.append(" classes");
            }
            buffer.append('.');
            buffer.append("\r\n");
            buffer.append("This is package is part of the <i>Device Kit</i> ");
            if (group.length() > 0) {
                buffer.append(' ');
                buffer.append(group);
                buffer.append(' ');
            }
            buffer.append(type);
            buffer.append('.');
            buffer.append("\r\n");
            this.template("end.txt", buffer);
            IResource packageResource = javaPackage.getResource();
            IFile packageHtml = null;
            if (packageResource instanceof IContainer && (packageObject = (pcontainer = (IContainer)packageResource).findMember("package.html")) instanceof IFile) {
                packageHtml = (IFile)packageObject;
            }
            if (packageHtml != null) {
                try {
                    packageHtml.setContents((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), true, true, this.getProgressMonitor());
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            } else {
                this.save(fullname, buffer.toString());
            }
        }
        super.processJavaPackage(javaPackage, refresh);
    }
}

