/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.utility.operation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;
import org.eclipse.soda.devicekit.ui.utility.operation.Template;
import org.eclipse.soda.devicekit.util.CoreUtility;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IWorkingSet;

public abstract class SourceOperation
implements IWorkspaceRunnable,
IRunnableWithProgress,
IResourceVisitor {
    private List list = null;
    private IProject project = null;
    private IJavaProject javaProject = null;
    private IPackageFragmentRoot packageFragmentRoot = null;
    private IPackageFragment javaPackage = null;
    private ICompilationUnit compilationUnit = null;
    private IResource resource = null;
    private Properties properties = new Properties();
    private boolean copyright = true;
    private String copyrightStringCode = "";
    private String copyrightStringProperties = "";
    private String copyrightStringXml = "";
    private Hashtable entities = new Hashtable();
    private Hashtable variables = new Hashtable();
    private String vendor = DeviceKitPreferenceInitializer.getPreferenceString((String)"vendor");
    private String version = DeviceKitPreferenceInitializer.getPreferenceString((String)"version");
    private String provider = DeviceKitPreferenceInitializer.getPreferenceString((String)"provider");
    private String packageBase = DeviceKitPreferenceInitializer.getPreferenceString((String)"packagebase");
    private IProgressMonitor progressMonitor = null;

    protected SourceOperation() {
    }

    public static int containsCopyright(String data) {
        int createYear = -1;
        int currentYear = Calendar.getInstance().get(1);
        String oldString = new String(data);
        StringTokenizer tokenizer = new StringTokenizer(oldString, " ,", true);
        String previousToken = "";
        while (tokenizer.hasMoreTokens()) {
            int temp;
            String createYearMaybe;
            String token = tokenizer.nextToken();
            String lcToken = token.toLowerCase();
            if ("copyright".equals(lcToken)) {
                createYear = 0;
            } else if (",".equals(token)) {
                try {
                    createYearMaybe = previousToken;
                    temp = Integer.parseInt(createYearMaybe);
                    if (temp <= currentYear && temp > 1980) {
                        createYear = temp;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if ("All".equals(token) || "IBM".equals(token)) {
                if (createYear < 1980) {
                    try {
                        createYearMaybe = previousToken;
                        temp = Integer.parseInt(createYearMaybe);
                        if (temp <= currentYear && temp > 1980) {
                            createYear = temp;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (("(c)".equals(token) || "Corp.".equals(token)) && createYear < 1980) {
                try {
                    tokenizer.nextToken();
                    token = createYearMaybe = tokenizer.nextToken();
                    temp = Integer.parseInt(createYearMaybe);
                    if (temp <= currentYear && temp > 1980) {
                        createYear = temp;
                    }
                }
                catch (Exception exception) {}
            }
            if (lcToken.endsWith("*/")) break;
            if (" ".equals(token) || ",".equals(token)) continue;
            previousToken = token;
        }
        return createYear;
    }

    public static void outputPropertiesTo(StringBuffer buffer, Hashtable properties) throws Exception {
        Set set = properties.keySet();
        Object[] keys = new String[set.size()];
        keys = set.toArray(keys);
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            Object key = keys[i];
            Object value = properties.get(key);
            CoreUtility.outputPropertiesTo((StringBuffer)buffer, (String)String.valueOf(key), (String)SourceOperation.valueOf(value));
            ++i;
        }
    }

    public static byte[] readData(InputStream fin) throws Exception {
        int size = fin.available();
        byte[] data = new byte[size];
        int index = 0;
        int sizeLeft = size;
        while (sizeLeft != 0) {
            index += fin.read(data, index, sizeLeft);
            sizeLeft = size - index;
        }
        fin.close();
        return data;
    }

    public static String valueOf(Object object) {
        if (object instanceof List) {
            StringBuffer buffer = new StringBuffer(1024);
            List list = (List)object;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                buffer.append(String.valueOf(iterator.next()));
            }
            return buffer.toString();
        }
        return String.valueOf(object);
    }

    public void addEntity(String key, String value) {
        this.getEntities().put(key, value);
    }

    public String format(String oldString) {
        Hashtable table = JavaCore.getOptions();
        table.put("org.eclipse.jdt.core.formatter.lineSplit", "255");
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)table);
        TextEdit textEdit = codeFormatter.format(8, oldString, 0, oldString.length(), 0, null);
        if (textEdit != null) {
            Document doc = new Document(oldString);
            try {
                textEdit.apply((IDocument)doc);
                return doc.get();
            }
            catch (Exception exception) {}
        }
        return oldString;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object value = this.getProperties().get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            try {
                return Boolean.valueOf(value.toString());
            }
            catch (Exception exception) {}
        }
        return defaultValue;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public boolean getCopyright() {
        return this.copyright;
    }

    public String getCopyrightLine() {
        return GeneratorTemplates.getCopyrightLine((Map)this.getTemplateVariables());
    }

    public String getCopyrightString() {
        return GeneratorTemplates.getCopyright((Map)this.getTemplateVariables());
    }

    public String getCopyrightStringCode() throws Exception {
        if (this.copyrightStringCode.length() == 0) {
            this.copyrightStringCode = GeneratorTemplates.getCopyright((Map)this.getTemplateVariables());
        }
        return this.copyrightStringCode;
    }

    public String getCopyrightStringCode(int createYear) throws Exception {
        return GeneratorTemplates.getCopyrightCodeString((Map)this.getTemplateVariables(createYear));
    }

    public String getCopyrightStringProperties() throws Exception {
        if (this.copyrightStringProperties.length() == 0) {
            this.copyrightStringProperties = GeneratorTemplates.getCopyrightPropertyString((Map)this.getTemplateVariables());
        }
        return this.copyrightStringProperties;
    }

    public String getCopyrightStringProperties(int createYear) throws Exception {
        return GeneratorTemplates.getCopyrightPropertyString((Map)this.getTemplateVariables(createYear));
    }

    public String getCopyrightStringXml() throws Exception {
        if (this.copyrightStringXml.length() == 0) {
            this.copyrightStringXml = GeneratorTemplates.getCopyright((Map)this.getTemplateVariables());
        }
        return this.copyrightStringXml;
    }

    public String getCopyrightXmlString(int createYear) throws Exception {
        return GeneratorTemplates.getCopyrightXmlString((Map)this.getTemplateVariables(createYear));
    }

    public Hashtable getEntities() {
        return this.entities;
    }

    public String getEntity(String key) {
        return (String)this.getEntities().get(key);
    }

    public IPackageFragment getJavaPackage() {
        return this.javaPackage;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public List getList() {
        return this.list;
    }

    public String getPackageBase() {
        return this.packageBase;
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.packageFragmentRoot;
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor != null) {
            return this.progressMonitor;
        }
        return new NullProgressMonitor();
    }

    public IProject getProject() {
        return this.project;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProvider() {
        return this.provider;
    }

    public IResource getResource() {
        return this.resource;
    }

    public Map getTemplateVariables() {
        return this.getTemplateVariables(-1);
    }

    public Map getTemplateVariables(int createYear) {
        Map map = GeneratorTemplates.getTemplateVariables((int)createYear);
        map.put("vendor", this.getVendor());
        map.put("vendors", this.getVendor());
        map.put("provider", this.getProvider());
        map.put("version", this.getVersion());
        return map;
    }

    public Hashtable getVariables() {
        return this.variables;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isC() {
        return this.getBoolean("c", true);
    }

    public boolean isH() {
        return this.getBoolean("h", true);
    }

    public boolean isHtml() {
        return this.getBoolean("html", true);
    }

    public boolean isJava() {
        return this.getBoolean("java", true);
    }

    public boolean isMakefiles() {
        return this.getBoolean("makefiles", true);
    }

    public boolean isManifest() {
        return this.getBoolean("mf", true);
    }

    public boolean isPackage() {
        return this.getBoolean("package", true);
    }

    public boolean isProject() {
        return this.getBoolean("project", true);
    }

    public boolean isProperties() {
        return this.getBoolean("properties", true);
    }

    public boolean isTxt() {
        return this.getBoolean("txt", true);
    }

    public boolean isXml() {
        return this.getBoolean("xml", true);
    }

    public void logException(Exception exception) {
        exception.printStackTrace();
    }

    public void processCompilationUnit(ICompilationUnit compilationUnit, boolean refresh) {
    }

    public boolean processContainer(IContainer container, boolean b) {
        boolean ok = true;
        try {
            IResource[] members = container.members();
            int i = 0;
            while (i < members.length) {
                ok = this.processResource(members[i], b);
                if (!ok) {
                    return ok;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return ok;
    }

    public boolean processFile(IFile file, boolean b) {
        return true;
    }

    public void processJavaPackage(IPackageFragment javaPackage, boolean refresh) {
        try {
            IProgressMonitor pm = this.getProgressMonitor();
            ICompilationUnit[] compilationUnits = javaPackage.getCompilationUnits();
            if (compilationUnits.length > 0) {
                int i = 0;
                while (i < compilationUnits.length) {
                    if (pm != null) {
                        pm.subTask(compilationUnits[i].getElementName());
                    }
                    this.processCompilationUnit(compilationUnits[i], false);
                    ++i;
                }
            }
            if (refresh) {
                IJavaProject javaProject = javaPackage.getJavaProject();
                javaProject.getProject().refreshLocal(2, pm);
            }
        }
        catch (Exception exception) {}
    }

    public void processJavaPackageFragmentRoot(IPackageFragmentRoot packageFragmentRoot, boolean refresh) {
        try {
            IJavaElement[] children = packageFragmentRoot.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IPackageFragment) {
                    IPackageFragment javaPackage = (IPackageFragment)children[i];
                    this.processJavaPackage(javaPackage, false);
                }
                ++i;
            }
            if (refresh) {
                packageFragmentRoot.getJavaProject().getProject().refreshLocal(2, this.getProgressMonitor());
            }
        }
        catch (Exception exception) {}
    }

    public void processJavaProject(IJavaProject javaProject, boolean refresh) {
        try {
            IProgressMonitor pm = this.getProgressMonitor();
            IPackageFragment[] packages = javaProject.getPackageFragments();
            int i = 0;
            while (i < packages.length) {
                if (pm != null) {
                    pm.subTask(packages[i].getElementName());
                }
                this.processJavaPackage(packages[i], false);
                ++i;
            }
            this.processProject(javaProject.getProject(), refresh);
        }
        catch (Exception exception) {}
    }

    protected void processList(List list2, boolean b) {
        IProgressMonitor pm = this.getProgressMonitor();
        pm.beginTask("Fix Source", this.list.size());
        int i = 0;
        while (i < this.list.size()) {
            if (pm.isCanceled()) break;
            Object object = this.list.get(i);
            if (object instanceof IWorkingSet) {
                IWorkingSet workingSet = (IWorkingSet)object;
                IAdaptable[] elements = workingSet.getElements();
                int j = 0;
                while (j < elements.length) {
                    if (elements[j] instanceof IProject) {
                        IProject project = (IProject)elements[j];
                        IJavaProject javaProject = JavaCore.create((IProject)project);
                        if (javaProject.exists()) {
                            this.processJavaProject(javaProject, true);
                            pm.subTask(javaProject.getElementName());
                        } else {
                            this.processProject(project, true);
                            pm.subTask(project.getName());
                        }
                    } else if (elements[j] instanceof IJavaProject) {
                        IJavaProject javaProject = (IJavaProject)elements[j];
                        this.processJavaProject(javaProject, true);
                        pm.subTask(javaProject.getElementName());
                    }
                    ++j;
                }
            } else if (object instanceof IJavaProject) {
                IJavaProject javaProject = (IJavaProject)object;
                this.processJavaProject(javaProject, true);
                pm.subTask(javaProject.getElementName());
            } else if (object instanceof IPackageFragment) {
                IPackageFragment javaPackage = (IPackageFragment)object;
                this.processJavaPackage(javaPackage, true);
                pm.subTask(javaPackage.getElementName());
            } else if (object instanceof ICompilationUnit) {
                this.processCompilationUnit((ICompilationUnit)object, true);
            } else if (object instanceof IType) {
                IType type = (IType)object;
                ICompilationUnit compilationUnit = type.getCompilationUnit();
                try {
                    if (compilationUnit.getAllTypes().length == 1) {
                        this.processCompilationUnit(compilationUnit, true);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            } else if (object instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)object;
                this.processJavaPackageFragmentRoot(packageFragmentRoot, true);
                pm.subTask(packageFragmentRoot.getElementName());
            } else if (object instanceof IResource) {
                IResource resource = (IResource)object;
                this.processResource(resource, true);
                pm.subTask(resource.getName());
            } else {
                System.out.println(object.getClass());
            }
            pm.worked(1);
            ++i;
        }
    }

    public void processProject(IProject project, boolean refresh) {
        try {
            IProgressMonitor pm = this.getProgressMonitor();
            project.accept((IResourceVisitor)this);
            if (refresh) {
                project.refreshLocal(2, pm);
            }
        }
        catch (Exception exception) {}
    }

    public boolean processResource(IResource resource, boolean b) {
        boolean ok = true;
        if (resource instanceof IContainer) {
            ok = this.processContainer((IContainer)resource, b);
        } else if (resource instanceof IFile) {
            ok = this.processFile((IFile)resource, b);
        }
        return ok;
    }

    public void processType(IType type, boolean refresh) {
        ICompilationUnit compilationUnit = type.getCompilationUnit();
        try {
            if (compilationUnit.getAllTypes().length == 1) {
                this.processCompilationUnit(compilationUnit, refresh);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public void run(IProgressMonitor monitor) {
        this.setProgressMonitor(monitor);
        if (this.list != null) {
            this.processList(this.list, true);
        }
        if (this.project != null) {
            this.processProject(this.project, true);
        }
        if (this.javaProject != null) {
            this.processJavaProject(this.javaProject, true);
        }
        if (this.packageFragmentRoot != null) {
            this.processJavaPackageFragmentRoot(this.packageFragmentRoot, true);
        }
        if (this.javaPackage != null) {
            this.processJavaPackage(this.javaPackage, true);
        }
        if (this.compilationUnit != null) {
            this.processCompilationUnit(this.compilationUnit, true);
        }
        if (this.resource != null) {
            this.processResource(this.resource, true);
        }
    }

    public void save(String filename, String data) {
        try {
            File file = new File(filename);
            if (file.exists()) {
                try {
                    file.delete();
                    file = new File(filename);
                }
                catch (Exception exception) {}
            }
            FileOutputStream fout = new FileOutputStream(file);
            fout.write(data.getBytes());
            fout.flush();
            fout.close();
        }
        catch (Exception exception) {
            this.logException(exception);
        }
    }

    public void save(IFile file, String data) {
        try {
            if (data.length() > 0) {
                if (file.exists()) {
                    byte[] oldData = SourceOperation.readData(file.getContents());
                    String oldString = new String(oldData);
                    if (data.equals(oldString)) {
                        return;
                    }
                    try {
                        byte[] dataBytes = data.getBytes();
                        ByteArrayInputStream stream = new ByteArrayInputStream(dataBytes);
                        file.setContents((InputStream)stream, true, true, this.getProgressMonitor());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        byte[] dataBytes = data.getBytes();
                        ByteArrayInputStream stream = new ByteArrayInputStream(dataBytes);
                        file.create((InputStream)stream, true, this.getProgressMonitor());
                        ((InputStream)stream).close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logException(exception);
        }
    }

    public void saveAllDirectory(String name, IProject project) {
        try {
            IFolder directory = null;
            StringTokenizer tokenizer = new StringTokenizer(name, "/");
            int count = tokenizer.countTokens();
            if (count > 1) {
                int i = 0;
                while (i < count - 1) {
                    IFolder folder;
                    String token = tokenizer.nextToken();
                    Object object = i == 0 ? project.getFolder(token) : (folder = directory != null ? directory.getFolder(token) : null);
                    if (folder != null && !folder.exists()) {
                        folder.create(true, true, null);
                    }
                    directory = folder;
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setCompilationUnit(ICompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public void setJavaPackage(IPackageFragment javaPackage) {
        this.javaPackage = javaPackage;
    }

    public void setJavaProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
        if (javaProject != null) {
            this.setProject(javaProject.getProject());
        }
    }

    public void setList(List list) {
        this.list = list;
    }

    public void setPackageBase(String packageBase) {
        this.packageBase = packageBase;
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot packageFragmentRoot) {
        this.packageFragmentRoot = packageFragmentRoot;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.progressMonitor = monitor != null ? monitor : new NullProgressMonitor();
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public void setVariables(Hashtable variables) {
        this.variables = variables;
    }

    public void template(String name, StringBuffer buffer) {
        try {
            int data;
            this.addEntity("Vendor", this.getVendor());
            this.addEntity("Version", this.getVersion());
            this.addEntity("Provider", this.getProvider());
            Template template = Template.getCurrent();
            template.setVariables(this.getVariables());
            template.setEntities(this.getEntities());
            InputStream inputStream = template.template(name);
            while ((data = inputStream.read()) != -1) {
                buffer.append((char)data);
            }
        }
        catch (Exception exception) {
            this.logException(exception);
        }
    }

    public boolean visit(IResource resource) throws CoreException {
        this.processResource(resource, true);
        return false;
    }
}

