/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.wizard;

import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.soda.devicekit.generator.GeneratorPlugin;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;
import org.eclipse.soda.devicekit.ui.DeviceKitUiPlugin;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.soda.devicekit.util.DkmlFileFinder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class DeviceKitPage
extends WizardPage
implements Listener {
    private static final String VENDOR = DeviceKitPreferenceInitializer.getPreferenceString((String)"vendor");
    private static final String VERSION = DeviceKitPreferenceInitializer.getPreferenceString((String)"version");
    private static final String PROVIDER = DeviceKitPreferenceInitializer.getPreferenceString((String)"provider");
    public static final TemplateStore templateStore = GeneratorPlugin.getDefault().getTemplateStore();
    public static final String[] COMMON_TEXT_KEYS = new String[]{"name", "packagebase", "provider", "version", "vendor", "vendortwo", "description"};
    public static final int COMPOSITE_COL_NUMBER = 3;
    private boolean canFinish;
    private boolean next;
    private Hashtable widgets;
    private boolean test = false;
    private DkmlFileFinder finder;

    protected DeviceKitPage(String pageName) {
        super(pageName);
        this.widgets = new Hashtable();
    }

    protected DeviceKitPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public boolean canFlipToNextPage() {
        return this.next;
    }

    protected Button createCheckBoxControl(Composite composite, String key) {
        return this.createCheckBoxControl(composite, key, "");
    }

    protected Button createCheckBoxControl(Composite composite, String key, String labelString) {
        String buttonString = this.getString(key);
        if (buttonString.length() > 0) {
            Label label = new Label(composite, 16384);
            if (labelString.length() > 0) {
                label.setText(labelString);
            }
            Button button = new Button(composite, 32);
            button.setText(buttonString);
            GridData data = new GridData(4);
            data.horizontalSpan = 2;
            data.verticalSpan = 1;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = false;
            button.setLayoutData((Object)data);
            String hint = this.getString(String.valueOf(key) + ".hint");
            if (hint != null && hint.length() > 0) {
                button.setToolTipText(hint);
            }
            button.addListener(13, (Listener)this);
            boolean defaultValue = DeviceKitPreferenceInitializer.getPreferenceBoolean((String)key);
            button.setSelection(defaultValue);
            this.putWidget(key, (Widget)button);
            return button;
        }
        return null;
    }

    protected Combo createComboControl(Composite composite, String key, String[] comboItems, IWizardMessages messages) {
        return this.createComboControl(composite, key, comboItems, 2052);
    }

    protected Combo createComboControl(Composite composite, String key, String[] comboItems, int style) {
        Label label = new Label(composite, 16384);
        String labelText = this.getString(key);
        label.setText(labelText);
        String hint = this.getString(String.valueOf(key) + ".hint");
        label.setToolTipText(hint);
        Combo combo = new Combo(composite, style);
        GridData data = new GridData(4);
        data.horizontalSpan = 2;
        data.verticalSpan = 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        combo.setLayoutData((Object)data);
        combo.setToolTipText(hint);
        combo.addListener(24, (Listener)this);
        combo.setItems(comboItems);
        this.putWidget(key, (Widget)combo);
        return combo;
    }

    public void createControl(Composite arg0) {
    }

    protected Text createTextControl(Composite composite, String key) {
        String hint;
        Label label = new Label(composite, 16384);
        label.setText(this.getString(key));
        if ("name".equals(key)) {
            label.setFont(this.getFont());
        }
        if ((hint = this.getString(String.valueOf(key) + ".hint")) != null && hint.length() > 0) {
            label.setToolTipText(hint);
        }
        Text text = new Text(composite, 2052);
        GridData data = new GridData(4);
        data.horizontalSpan = 2;
        data.verticalSpan = 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)data);
        text.setToolTipText(hint);
        text.addListener(24, (Listener)this);
        String defaultValue = DeviceKitPreferenceInitializer.getPreferenceString((String)key);
        if (defaultValue != null) {
            text.setText(defaultValue);
        }
        this.putWidget(key, (Widget)text);
        return text;
    }

    protected boolean doesNextPageExist() {
        return this.getNextPage() != null;
    }

    protected String getDefaultMessage() {
        return "";
    }

    public DkmlFileFinder getFinder() {
        if (this.finder == null) {
            this.finder = new DkmlFileFinder();
        }
        return this.finder;
    }

    protected abstract String getKey();

    public abstract String getString(String var1);

    protected String getTypeName() {
        return this.getString(this.getKey());
    }

    public Hashtable getVariables() {
        Hashtable<String, String> variables = new Hashtable<String, String>();
        Enumeration keys = this.widgets.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Widget element = this.getWidget(key);
            if (element instanceof Text) {
                Text text = (Text)element;
                variables.put(key, text.getText().trim());
                continue;
            }
            if (element instanceof Button) {
                Button button = (Button)element;
                boolean value = button.getSelection();
                variables.put(key, value ? "true" : "false");
                continue;
            }
            if (!(element instanceof Combo)) continue;
            Combo combo = (Combo)element;
            String value = combo.getText();
            variables.put(key, value);
        }
        IWizardPage nextPage = this.getNextPage();
        if (nextPage instanceof DeviceKitPage) {
            DeviceKitPage nextVariablePage = (DeviceKitPage)nextPage;
            variables.putAll(nextVariablePage.getVariables());
        }
        if (variables.get("year") == null) {
            int currentYear = Calendar.getInstance().get(1);
            variables.put("year", String.valueOf(currentYear));
            variables.put("years", String.valueOf(currentYear));
        }
        if (variables.get("years") == null) {
            int currentYear = Calendar.getInstance().get(1);
            variables.put("years", String.valueOf(currentYear));
        }
        if (variables.get("provider") == null) {
            variables.put("provider", PROVIDER);
        }
        if (variables.get("vendor") == null) {
            variables.put("vendor", VENDOR);
            variables.put("vendors", VENDOR);
        } else {
            variables.put("vendors", (String)variables.get("vendor"));
        }
        if (variables.get("version") == null) {
            variables.put("version", VERSION);
        }
        return variables;
    }

    protected Widget getWidget(String key) {
        return (Widget)this.widgets.get(key);
    }

    public void handleEvent(Event e) {
        if (this.getControl() == null) {
            return;
        }
        if (e.type == 24 || e.type == 13) {
            this.updatePageCompletion();
        }
    }

    protected boolean isNumberTextEntry(String textKey, boolean allowEmpty) {
        Text text = (Text)this.getWidget(textKey);
        String value = text.getText();
        if (allowEmpty && value.trim().length() == 0) {
            return true;
        }
        if (!allowEmpty && value.trim().length() == 0) {
            String message = this.getString(String.valueOf(textKey) + ".empty");
            this.update(false, false, null, message);
            return false;
        }
        try {
            new Integer(value);
        }
        catch (NumberFormatException numberFormatException) {
            String errorMessage = this.getString(String.valueOf(textKey) + ".validnumber");
            this.update(false, false, errorMessage, null);
            return false;
        }
        return true;
    }

    public boolean isPageComplete() {
        return this.canFinish;
    }

    public boolean isTest() {
        return this.test;
    }

    protected boolean projectExists(String projectName) {
        IProject project = DeviceKitUiPlugin.getWorkspace().getRoot().getProject(projectName);
        return project != null && project.exists();
    }

    protected void putWidget(String key, Widget widget) {
        this.widgets.put(key, widget);
    }

    public void setFinder(DkmlFileFinder finder) {
        this.finder = finder;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updatePageCompletion();
        }
    }

    public void update(boolean finishEnabled, boolean nextEnabled, String errorMessage, String message) {
        this.canFinish = finishEnabled;
        boolean bl = this.next = nextEnabled && this.doesNextPageExist();
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(this.getDefaultMessage());
        }
        this.setErrorMessage(errorMessage);
        if (((WizardDialog)this.getWizard().getContainer()).getCurrentPage() != null) {
            ((WizardDialog)this.getWizard().getContainer()).updateButtons();
        }
    }

    public void updatePageCompletion() {
        this.setMessage(null);
        boolean complete = this.updatePageErrors();
        this.setPageComplete(complete);
        if (((WizardDialog)this.getWizard().getContainer()).getCurrentPage() != null) {
            ((WizardDialog)this.getWizard().getContainer()).updateButtons();
        }
    }

    protected abstract boolean updatePageErrors();
}

