/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.preference;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.preference.jre.DeviceKitJREConstants;

public class DeviceKitPreferenceInitializer
extends AbstractPreferenceInitializer {
    public static final String VALIDATE_SCHEMA_KEY = "schema";
    public static final String[] DEF_DEV_SUPERS = new String[0];
    public static final String[] DEF_TRAN_SUPERS = new String[0];
    public static final String[] DEF_TRAN_SERVICES = new String[]{"matrix.example.matrix.lcd.transport.service.MatrixLcdTransportService"};
    public static final String[] DEF_TRAN_IMPLS = new String[]{"matrix.example.matrix.lcd.transport.MatrixLcdTransport"};

    public static String[] buildSuperClassList() {
        return DEF_DEV_SUPERS;
    }

    public static String[] buildTransportImplementationList() {
        return DEF_TRAN_IMPLS;
    }

    public static String[] buildTransportServiceList() {
        return DEF_TRAN_SERVICES;
    }

    public static String fixSlashes(String string) {
        return string.replace('\\', '/');
    }

    public static String[] getDefault(String key) {
        IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
        String value = store.getDefaultString(key);
        if (value != null) {
            return DeviceKitPreferenceInitializer.parsePrefArray(value);
        }
        return new String[0];
    }

    public static boolean getDefaultBoolean(String key) {
        IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
        boolean value = store.getDefaultBoolean(key);
        return value;
    }

    public static String[] getDefaultClasspathLocations() {
        String[] variables = JavaCore.getClasspathVariableNames();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < variables.length) {
            String varName = variables[i];
            IPath path = JavaCore.getClasspathVariable((String)varName);
            if (path != null && path.toFile().exists()) {
                File bundleFiles;
                String pathString = path.makeAbsolute().toString();
                list.add(DeviceKitPreferenceInitializer.fixSlashes(pathString));
                File file = new File(pathString);
                if (file.exists() && (bundleFiles = new File(file, "bundlefiles")).exists()) {
                    list.add(DeviceKitPreferenceInitializer.fixSlashes(bundleFiles.getAbsolutePath()));
                }
            }
            ++i;
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static String getDefaultString(String key) {
        IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
        return store.getDefaultString(key);
    }

    public static boolean getPreferenceBoolean(String key) {
        IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
        return store.getBoolean(key);
    }

    public static String getPreferenceString(String key) {
        if (DeviceKitPlugin.getDefault() != null) {
            IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
            return store.getString(key);
        }
        return "";
    }

    public static IPreferenceStore getStore() {
        return DeviceKitPlugin.getDefault().getPreferenceStore();
    }

    public static String makePrefString(String[] entries) {
        StringBuffer buffer = new StringBuffer(entries.length * 30);
        int i = 0;
        while (i < entries.length) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(entries[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String[] parsePrefArray(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        String[] result = new String[tokenizer.countTokens() + 1];
        int count = 1;
        result[0] = "";
        while (tokenizer.hasMoreTokens()) {
            String token;
            result[count] = token = tokenizer.nextToken();
            ++count;
        }
        return result;
    }

    public static void setPreference(String key, String[] values) {
        DeviceKitPreferenceInitializer.setPreference(key, DeviceKitPreferenceInitializer.makePrefString(values));
    }

    public static void setPreference(String key, boolean value) {
        IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
        store.setValue(key, value);
    }

    public static void setPreference(String key, String value) {
        IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
        store.setValue(key, value);
    }

    public static final boolean validateAgainstSchema() {
        return DeviceKitPreferenceInitializer.getPreferenceBoolean(VALIDATE_SCHEMA_KEY);
    }

    public void initializeDefaultPreferences() {
        IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
        store.setDefault("packagebase", "org.eclipse.soda.dk");
        store.setDefault("vendor", "IBM");
        store.setDefault("vendortwo", "");
        store.setDefault("name", "");
        store.setDefault("provider", "Eclipse.org");
        store.setDefault("version", "1.1.0");
        store.setDefault("incubation", false);
        store.setDefault("generateold", false);
        store.setDefault("format", true);
        store.setDefault("organizeImports", true);
        store.setDefault(VALIDATE_SCHEMA_KEY, true);
        store.setDefault("iveattrs", false);
        store.setDefault("iveRes", false);
        store.setDefault("device.superclass", DeviceKitPreferenceInitializer.makePrefString(DeviceKitPreferenceInitializer.buildSuperClassList()));
        store.setDefault("transport.superclass", DeviceKitPreferenceInitializer.makePrefString(DEF_TRAN_SUPERS));
        store.setDefault("transport.service", DeviceKitPreferenceInitializer.makePrefString(DeviceKitPreferenceInitializer.buildTransportServiceList()));
        store.setDefault("transport.implementation", DeviceKitPreferenceInitializer.makePrefString(DeviceKitPreferenceInitializer.buildTransportImplementationList()));
        store.setDefault("create.test", true);
        store.setDefault("create.testcase", true);
        store.setDefault("abstract", false);
        store.setDefault("create.bundle", true);
        store.setDefault("create.managed.bundle", true);
        store.setDefault("create.managed.factory.bundle", true);
        store.setDefault("device.superclass", DeviceKitPreferenceInitializer.makePrefString(DEF_DEV_SUPERS));
        store.setDefault("classpath.locations", DeviceKitPreferenceInitializer.makePrefString(DeviceKitPreferenceInitializer.getDefaultClasspathLocations()));
        store.setDefault("classpath.search.projects", true);
        store.setDefault("usermessagebase", "1000");
        store.setDefault(DeviceKitJREConstants.KEY_CLASSPATH_JRE_DEFAULT, DeviceKitJREConstants.JRE_IN_CLASSPATH_DEFAULT);
        store.setDefault(DeviceKitJREConstants.KEY_EXECUTION_ENVIRONMENTS_DEFAULT, DeviceKitPreferenceInitializer.makePrefString(DeviceKitJREConstants.EXECUTION_ENVIRONMENTS_DEFAULT));
        store.setDefault(DeviceKitJREConstants.KEY_CLASSPATH_JRE_TEST, DeviceKitJREConstants.JRE_IN_CLASSPATH_TEST_DEFAULT);
        store.setDefault(DeviceKitJREConstants.KEY_EXECUTION_ENVIRONMENTS_TEST, DeviceKitPreferenceInitializer.makePrefString(DeviceKitJREConstants.EXECUTION_ENVIRONMENTS_TEST_DEFAULT));
        store.setDefault(DeviceKitJREConstants.KEY_CLASSPATH_JRE_TESTAGENT, DeviceKitJREConstants.JRE_IN_CLASSPATH_TESTAGENT_DEFAULT);
        store.setDefault(DeviceKitJREConstants.KEY_EXECUTION_ENVIRONMENTS_TESTAGENT, DeviceKitPreferenceInitializer.makePrefString(DeviceKitJREConstants.EXECUTION_ENVIRONMENTS_TESTAGENT_DEFAULT));
    }
}

