/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.xmlsource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.soda.devicekit.xmlsource.XmlSourceConstants;

public class XmlSourceLoader
implements XmlSourceConstants {
    public static final String ECLIPSE32JAR = ".jar!";
    protected List entries;
    protected Hashtable xmlFiles = new Hashtable();
    protected Hashtable xmlTypes = new Hashtable();

    public XmlSourceLoader() {
        this.entries = new ArrayList();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getStringFromStream(InputStream stream) throws Exception {
        if (stream == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        byte[] bytes = new byte[1024];
        try {
            int read = stream.read(bytes);
            while (read > 0) {
                byte[] bytes2 = new byte[read];
                System.arraycopy(bytes, 0, bytes2, 0, read);
                String temp = new String(bytes2);
                buffer.append(temp);
                read = stream.read(bytes);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            stream.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        stream.close();
        return buffer.toString();
    }

    public static void main(String[] args) {
        XmlSourceLoader xmlSourceLoader = new XmlSourceLoader();
        File file = new File("xmlsource");
        xmlSourceLoader.loadFiles(file);
        System.out.println(xmlSourceLoader.getXmlFiles());
        try {
            XmlSourceLoader xmlSourceLoaders = new XmlSourceLoader();
            xmlSourceLoaders.loadFiles("org.eclipse.soda.dk.matrix.lcd.plugin_1.0.0.200702200959.jar", "xmlsource");
            System.out.println(xmlSourceLoaders.getXmlFiles());
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public Hashtable getXmlFiles() {
        return this.xmlFiles;
    }

    public Hashtable getXmlTypes() {
        return this.xmlTypes;
    }

    private void loadExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String name = elements[i].getName();
            if ("xmlsource".equals(name)) {
                try {
                    this.loadWizardContent(elements[i]);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public void loadFiles(File file, String baseName) {
        block5: {
            String name;
            block4: {
                String name2;
                if (!file.isDirectory()) break block4;
                File[] files = file.listFiles();
                if (files == null || "CVS".equals(name2 = file.getName())) break block5;
                String newBaseName = baseName.length() == 0 ? name2 : String.valueOf(baseName) + '/' + name2;
                int i = 0;
                while (i < files.length) {
                    this.loadFiles(files[i], newBaseName);
                    ++i;
                }
                break block5;
            }
            if (!file.isFile() || !(name = file.getName()).endsWith(".xml")) break block5;
            String key = String.valueOf(baseName) + '/' + name;
            try {
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                String contents = XmlSourceLoader.getStringFromStream(inputStream);
                this.getXmlFiles().put(key, contents);
                Object object = this.xmlTypes.get(name);
                if (object instanceof String[]) {
                    String[] list = (String[])object;
                    String[] newList = new String[list.length + 1];
                    System.arraycopy(list, 0, newList, 0, list.length);
                    newList[list.length] = contents;
                    this.xmlTypes.put(name, newList);
                }
                this.xmlTypes.put(name, new String[]{contents});
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void loadFiles(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                this.loadFiles(files[i], "");
                ++i;
            }
        }
    }

    public void loadFiles(String pluginjardir, String subdir) throws IOException {
        ZipFile pluginjar = new ZipFile(pluginjardir);
        Enumeration<? extends ZipEntry> zes = pluginjar.entries();
        while (zes.hasMoreElements()) {
            ZipEntry ze = zes.nextElement();
            String entryName = ze.getName();
            if (!entryName.startsWith(subdir) || ze.isDirectory()) continue;
            int beginIndex = subdir.length() + 1;
            String key = entryName.substring(beginIndex);
            InputStream inputStream = pluginjar.getInputStream(ze);
            try {
                String contents = XmlSourceLoader.getStringFromStream(inputStream);
                int index = key.lastIndexOf(47);
                String name = key.substring(index);
                this.getXmlFiles().put(key, contents);
                Object object = this.xmlTypes.get(name);
                if (object instanceof String[]) {
                    String[] list = (String[])object;
                    String[] newList = new String[list.length + 1];
                    System.arraycopy(list, 0, newList, 0, list.length);
                    newList[list.length] = contents;
                    this.xmlTypes.put(name, newList);
                    continue;
                }
                this.xmlTypes.put(name, new String[]{contents});
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void loadWizardContent(IConfigurationElement element) throws IOException, MalformedURLException {
        String path = element.getAttribute("path");
        String name = element.getContributor().getName();
        URL url = FileLocator.resolve((URL)Platform.getBundle((String)name).getEntry("/"));
        int index = url.getPath().indexOf(ECLIPSE32JAR);
        if (index < 0) {
            File file = new File(url.getFile(), path);
            if (file.exists()) {
                this.loadFiles(file);
            }
        } else {
            String pluginjardir = new URL(url.getPath().substring(0, index + 4)).getPath();
            this.loadFiles(pluginjardir, path);
        }
    }

    public void loadXmlFiles() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.soda.devicekit.xmlsource");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                this.loadExtension(extensions[i]);
                ++i;
            }
        }
    }

    public void setXmlFiles(Hashtable table) {
        this.xmlFiles = table;
    }
}

