/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.adapter;

import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.soda.dk.adapter.AdapterResourceBundle;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.Device;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceListener;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.service.TransportService;

public class Adapter
extends Device
implements AdapterService,
CommandListener,
SignalListener,
MeasurementListener,
DeviceListener {
    private static ResourceBundle DefaultResourceBundle;
    private DeviceService device;
    private Map profiles = new Hashtable(13);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.adapter.AdapterResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public Adapter() {
        this.initialize();
    }

    public void addProfile(ProfileService profile) {
        if (profile != null) {
            this.getProfiles().put(profile.getKey(), profile);
        }
    }

    public void commandExecuted(CommandService source, Object timestamp, Object data) {
    }

    public void controlChanged(DeviceService container, Object timestamp, ControlService control, int code) {
    }

    public void deviceChanged(DeviceService source, Object timestamp, int newState, int oldState) {
        int mystate = this.getState();
        if (mystate != newState) {
            if (mystate > 1) {
                if (newState == 5) {
                    this.restart();
                } else if (newState > 1) {
                    super.setState(newState);
                } else {
                    super.setState(2);
                }
            }
            this.deviceChangedCustom(source, timestamp, newState, oldState);
        }
    }

    public void deviceChangedCustom(DeviceService source, Object timestamp, int newState, int oldState) {
    }

    public void exit() {
        this.removeListeners(this.getDevice());
        this.setDevice(null);
        super.exit();
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public DeviceService getDevice() {
        return this.device;
    }

    public Object getLogDetails6() {
        return String.valueOf(this.getDevice());
    }

    public Map getProfiles() {
        return this.profiles;
    }

    public String getResource(int resourceId) {
        try {
            if (resourceId >= 3000 && resourceId < 4000) {
                return DefaultResourceBundle.getString(AdapterResourceBundle.getKey(resourceId + 1000));
            }
            return DefaultResourceBundle.getString(AdapterResourceBundle.getKey(resourceId));
        }
        catch (Exception exception) {
            return super.getResource(resourceId);
        }
    }

    public TransportService getTransport() {
        DeviceService device = this.getDevice();
        if (device != null) {
            return device.getTransport();
        }
        return super.getTransport();
    }

    private void initialize() {
        this.capabilities = new Measurement("Adapter/Capabilities");
        this.status = new Measurement("Adapter/Status");
        this.configuration = new Measurement("Adapter/Configuration");
        this.metrics = new MethodMeasurement("Device/Metrics");
        this.put((ControlService)this.configuration);
        this.put((ControlService)this.status);
        this.put((ControlService)this.capabilities);
        this.put((ControlService)this.metrics);
    }

    public void initializeCommand(CommandService command) {
        if (command != null) {
            command.addCommandListener((CommandListener)this);
        }
    }

    public void initializeMeasurement(MeasurementService measurement) {
        if (measurement != null) {
            measurement.addMeasurementListener((MeasurementListener)this);
            measurement.executeRead();
        }
    }

    public void initializeSignal(SignalService signal) {
        if (signal != null) {
            signal.addSignalListener((SignalListener)this);
        }
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
    }

    public void removeProfile(ProfileService profile) {
        if (profile != null) {
            this.getProfiles().remove(profile.getKey());
        }
    }

    public void setDevice(DeviceService device) {
        if (this.device != null) {
            this.device.removeDeviceListener((DeviceListener)this);
        }
        this.device = device;
        if (this.device != null) {
            this.device.addDeviceListener((DeviceListener)this);
        }
        this.setDeviceCustom(device);
    }

    public void setDeviceCustom(DeviceService device) {
    }

    public void setProfiles(Map profiles) {
        this.profiles = profiles;
    }

    public void setState(int state) {
        int deviceState;
        if (state < 2) {
            super.setState(state);
            return;
        }
        DeviceService device = this.getDevice();
        if (device != null && (deviceState = device.getState()) > 2) {
            super.setState(deviceState);
            return;
        }
        super.setState(2);
    }

    public void setup() {
        super.setup();
        if (this.getDevice() == null) {
            this.setDevice(this.getDefaultDevice());
        }
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
    }
}

