/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.agent.bundle;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.agent.service.AgentService;
import org.eclipse.soda.dk.core.ConfigurableObject;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.service.log.LogService;

public abstract class AgentBundle
extends BaseBundleActivator
implements BundleActivator {
    public static final String[] OPTIONAL_SERVICES = new String[]{"org.eclipse.soda.dk.notification.service.NotificationService"};
    private DeviceService device = null;
    private AgentService agent;

    public void activate() {
        NotificationService notificationService;
        if (this.agent == null) {
            this.setAgent(this.createService());
            if (this.agent != null) {
                Hashtable properties = this.createProperties();
                String[] names = this.getExportedServiceNames();
                this.addExportedServices(names, this.agent, properties);
            }
        }
        if ((notificationService = (NotificationService)this.getOptionalImportedService("org.eclipse.soda.dk.notification.service.NotificationService")) != null) {
            this.agent.setNotificationService(notificationService);
        }
        this.agent.start();
    }

    public Hashtable createProperties() {
        Bundle bundle = this.getBundle();
        Hashtable properties = ConfigurableObject.createPropertiesFromHeaders((Dictionary)bundle.getHeaders());
        properties.put("id", "#");
        return properties;
    }

    public abstract AgentService createService();

    protected void deactivate() {
        AgentService agent = this.getAgent();
        if (agent != null) {
            agent.exit();
            this.setAgent(null);
        }
    }

    public AgentService getAgent() {
        return this.agent;
    }

    public DeviceService getDevice() {
        if (this.device == null) {
            return (DeviceService)this.getImportedService(this.getInterestServiceName());
        }
        return this.device;
    }

    public abstract String[] getExportedServiceNames();

    public String getInterestServiceName() {
        return "";
    }

    protected String[] getOptionalImportedServiceNames() {
        return OPTIONAL_SERVICES;
    }

    protected void handleAcquiredOptionalImportedService(String serviceName, Object service) {
        if (this.agent != null && service instanceof NotificationService) {
            this.agent.setNotificationService((NotificationService)service);
        }
    }

    protected void handleReleasedOptionalImportedService(String serviceName, Object service) {
        if (this.agent != null && service instanceof NotificationService) {
            this.agent.setNotificationService(null);
        }
    }

    public void log(int severity, String message) {
        this.log(severity, message, null);
    }

    public void log(int severity, String message, Throwable exception) {
        LogService logService = EscObject.getDefaultLogService();
        logService.log(severity, message, exception);
    }

    public void setAgent(AgentService agent) {
        this.agent = agent;
    }

    public void setDevice(DeviceService device) {
        this.device = device;
    }
}

