/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.agent.managed;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.agent.service.AgentService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.managed.CoreManaged;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceAdvisor;
import org.osgi.service.cm.ManagedService;

public abstract class AgentManaged
extends CoreManaged
implements ManagedService,
IManagedServiceAdvisor {
    public static final String[] OPTIONAL_SERVICES = new String[]{"org.eclipse.soda.dk.notification.service.NotificationService"};
    public static final String[] OPTIONAL_SERVICE = new String[]{METATYPE_SERVICE};

    public synchronized Object create(String pid, Dictionary properties, IBundleActivationManager manager) {
        AgentService agent = this.createService(manager);
        if (agent != null) {
            agent.setConfigurationInformation(properties);
            try {
                agent.start();
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            Hashtable serviceProperties = this.createProperties();
            this.updateProperties(serviceProperties, properties);
            manager.addExportedServices(this.getServiceNames(), (Object)agent, (Dictionary)serviceProperties);
        }
        return agent;
    }

    public AgentService createService(IBundleActivationManager manager) {
        String interestServiceName = this.getInterestServiceName();
        if (interestServiceName != null && interestServiceName.length() > 0) {
            DeviceService device = (DeviceService)manager.getImportedService(interestServiceName);
            AgentService agent = this.createService(device);
            return agent;
        }
        AgentService agent = this.createService((DeviceService)null);
        return agent;
    }

    public AgentService createService(DeviceService device) {
        return null;
    }

    public synchronized void destroy(String pid, Object object, Dictionary properties, IBundleActivationManager manager) {
        try {
            AgentService agent = (AgentService)object;
            agent.exit();
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
    }

    public String getDeviceServiceName() {
        return "";
    }

    public String getInterestServiceName() {
        return this.getDeviceServiceName();
    }

    public String[] getOptionalImportedServiceNames(String pid, Dictionary arg1, Dictionary arg2, IBundleActivationManager arg3) {
        return OPTIONAL_SERVICES;
    }

    protected String[] getOptionalImportedServiceNames() {
        return OPTIONAL_SERVICE;
    }

    public String getServiceName() {
        return DeviceService.SERVICE_NAME;
    }

    public String[] getServiceNames() {
        return new String[]{this.getServiceName()};
    }

    public void handleAcquiredOptionalImportedService(String pid, Object object, String importedServiceName, Object importedService, IBundleActivationManager manager) {
        if (object instanceof AgentService) {
            AgentService agent = (AgentService)object;
            if (importedService instanceof NotificationService) {
                agent.setNotificationService((NotificationService)importedService);
            }
        }
    }

    public void handleReleasedOptionalImportedService(String pid, Object object, String importedServiceName, Object importedService, IBundleActivationManager manager) {
        if (object instanceof AgentService) {
            AgentService device = (AgentService)object;
            if (importedService instanceof NotificationService) {
                device.setNotificationService(null);
            }
        }
    }

    public Object update(String pid, Object object, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        AgentService agent = (AgentService)object;
        try {
            agent.stop();
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
        agent.setConfigurationInformation(properties);
        try {
            agent.start();
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
        Hashtable serviceProperties = this.createProperties();
        this.updateProperties(serviceProperties, properties);
        manager.setExportedServiceProperties(AgentService.SERVICE_NAME, (Dictionary)serviceProperties);
        return agent;
    }
}

