/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.arcom.io.device;

import org.eclipse.soda.dk.arcom.io.device.messages.ArcomIoDeviceMessages;
import org.eclipse.soda.dk.arcom.io.device.service.ArcomIoDeviceService;
import org.eclipse.soda.dk.arcom.io.transport.service.ArcomIoTransportService;
import org.eclipse.soda.dk.command.SimpleDataCommand;
import org.eclipse.soda.dk.command.SimpleMessageCommand;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.TransportDevice;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.measurement.CommandMeasurement;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.signal.DataSignal;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.service.TransportService;

public class ArcomIoDevice
extends TransportDevice
implements DeviceService,
ArcomIoDeviceService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.arcom.io.device.ArcomIoDevice";
    private final InterestService interest = new InterestMask(new byte[]{1}, new byte[]{15});
    private final SimpleDataCommand setAllOutputs = new SimpleDataCommand("SetAllOutputs", ArcomIoDeviceMessages.getSetAllOutputsMessage());
    private final SimpleDataCommand setPin0 = new SimpleDataCommand("SetPin0", ArcomIoDeviceMessages.getSetPin0Message());
    private final SimpleDataCommand setPin1 = new SimpleDataCommand("SetPin1", ArcomIoDeviceMessages.getSetPin1Message());
    private final SimpleDataCommand setPin2 = new SimpleDataCommand("SetPin2", ArcomIoDeviceMessages.getSetPin2Message());
    private final SimpleDataCommand setPin3 = new SimpleDataCommand("SetPin3", ArcomIoDeviceMessages.getSetPin3Message());
    private final SimpleDataCommand setPin4 = new SimpleDataCommand("SetPin4", ArcomIoDeviceMessages.getSetPin4Message());
    private final SimpleDataCommand setPin5 = new SimpleDataCommand("SetPin5", ArcomIoDeviceMessages.getSetPin5Message());
    private final SimpleDataCommand setPin6 = new SimpleDataCommand("SetPin6", ArcomIoDeviceMessages.getSetPin6Message());
    private final SimpleDataCommand setPin7 = new SimpleDataCommand("SetPin7", ArcomIoDeviceMessages.getSetPin7Message());
    private final SimpleMessageCommand getOutputRequest = new SimpleMessageCommand("GetOutputRequest", ArcomIoDeviceMessages.getGetOutputRequestMessage());
    private final DataSignal outputReport = new DataSignal("OutputReport", ArcomIoDeviceMessages.getOutputReportMessage());
    private final CommandMeasurement output = new CommandMeasurement("Output", null, null, null, (SignalService)this.outputReport, (CommandService)this.getOutputRequest, (CommandService)this.setAllOutputs);
    private final SimpleMessageCommand getInputRequest = new SimpleMessageCommand("GetInputRequest", ArcomIoDeviceMessages.getGetInputRequestMessage());
    private final DataSignal inputReport = new DataSignal("InputReport", ArcomIoDeviceMessages.getInputReportMessage());
    private final CommandMeasurement input = new CommandMeasurement("Input", null, null, null, (SignalService)this.inputReport, (CommandService)this.getInputRequest, null);

    public ArcomIoDevice() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public InterestService getInterest() {
        return this.interest;
    }

    public String getDefaultKey() {
        return "ArcomIoDevice";
    }

    public TransportService getDefaultTransport() {
        return (ArcomIoTransportService)ArcomIoDevice.loadService((String)TransportService.SERVICE_NAME, (String)"org.eclipse.soda.dk.arcom.io.transport.ArcomIoTransport");
    }

    public int getControlCapacity() {
        return 23;
    }

    public int getMessageCapacity() {
        return 5;
    }

    public Object getMessageKey(MessageService message) {
        byte[] bytes = message.getBytes();
        if (bytes.length >= 1 && (bytes[0] == 113 || bytes[0] == -127)) {
            return new Integer((bytes[0] & 0xF0) >> 4);
        }
        return null;
    }

    private void initialize() {
        SimpleDataCommand setAllOutputs = this.setAllOutputs;
        this.put((ControlService)setAllOutputs);
        SimpleDataCommand setPin0 = this.setPin0;
        this.put((ControlService)setPin0);
        SimpleDataCommand setPin1 = this.setPin1;
        this.put((ControlService)setPin1);
        SimpleDataCommand setPin2 = this.setPin2;
        this.put((ControlService)setPin2);
        SimpleDataCommand setPin3 = this.setPin3;
        this.put((ControlService)setPin3);
        SimpleDataCommand setPin4 = this.setPin4;
        this.put((ControlService)setPin4);
        SimpleDataCommand setPin5 = this.setPin5;
        this.put((ControlService)setPin5);
        SimpleDataCommand setPin6 = this.setPin6;
        this.put((ControlService)setPin6);
        SimpleDataCommand setPin7 = this.setPin7;
        this.put((ControlService)setPin7);
        SimpleMessageCommand getOutputRequest = this.getOutputRequest;
        this.put((ControlService)getOutputRequest);
        DataSignal outputReport = this.outputReport;
        this.put((ControlService)outputReport);
        CommandMeasurement output = this.output;
        this.put((ControlService)output);
        SimpleMessageCommand getInputRequest = this.getInputRequest;
        this.put((ControlService)getInputRequest);
        DataSignal inputReport = this.inputReport;
        this.put((ControlService)inputReport);
        CommandMeasurement input = this.input;
        this.put((ControlService)input);
    }
}

