/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.arcom.io.transport;

import org.eclipse.soda.dk.arcom.io.transport.service.ArcomIoTransportService;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.digital.io.transport.service.DigitalIoTransportService;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.random.access.file.connection.RandomAccessFileConnection;
import org.eclipse.soda.dk.random.access.file.connection.service.RandomAccessFileConnectionService;
import org.eclipse.soda.dk.transport.ConnectionTransport;
import org.eclipse.soda.dk.transport.service.TransportService;

public class ArcomIoTransport
extends ConnectionTransport
implements TransportService,
DigitalIoTransportService,
ArcomIoTransportService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.arcom.io.transport.ArcomIoTransport";
    private static byte[] AND_MASKS = new byte[]{-2, -3, -5, -9, -17, -33, -65, 127};
    public static final int BUFFER_SIZE = 1;
    private byte[] currentOutput = new byte[]{-1};
    private int lastInputState = 0;
    private static byte[] OR_MASKS = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    private int pollingRate = 250;

    public int getBufferSize() {
        return 1;
    }

    protected int processInput(byte[] bytes, int length) throws Exception {
        int input = bytes[0];
        if (input != this.lastInputState) {
            this.fireMessageReceived(ArcomIoTransport.getCurrentTimestamp(), (MessageService)new Message(new byte[]{-127, bytes[0]}));
        }
        this.lastInputState = input;
        this.sleep(this.getPollingRate());
        return length;
    }

    public int startup(boolean output) throws Exception {
        int startupReturnValue = super.startup(output);
        try {
            byte[] byArray = new byte[2];
            byArray[0] = 1;
            this.write(byArray);
        }
        catch (Exception exception) {}
        this.lastInputState = 0;
        return startupReturnValue;
    }

    public void write(byte[] sendBytes) throws Exception {
        if (sendBytes[0] == 24) {
            this.fireMessageReceived(ArcomIoTransport.getCurrentTimestamp(), (MessageService)new Message(new byte[]{-127, (byte)this.lastInputState}));
            return;
        }
        if (sendBytes[0] == 23) {
            this.fireMessageReceived(ArcomIoTransport.getCurrentTimestamp(), (MessageService)new Message(new byte[]{113, this.currentOutput[0]}));
            return;
        }
        byte desiredOutput = 0;
        if (sendBytes[0] == 1) {
            desiredOutput = sendBytes[1];
        } else if (sendBytes[0] == 33) {
            desiredOutput = (byte)(this.currentOutput[0] & AND_MASKS[sendBytes[1]]);
        } else if (sendBytes[0] == 49) {
            desiredOutput = (byte)(this.currentOutput[0] | OR_MASKS[sendBytes[1]]);
        } else {
            this.handleError(null, 2006, new Message(sendBytes));
            return;
        }
        boolean changed = desiredOutput != this.currentOutput[0];
        this.currentOutput[0] = desiredOutput;
        super.write(this.currentOutput);
        if (changed) {
            this.fireMessageReceived(ArcomIoTransport.getCurrentTimestamp(), (MessageService)new Message(new byte[]{113, this.currentOutput[0]}));
        }
    }

    public ConnectionService getDefaultConnection() {
        return this.getDefaultRandomAccessFileConnection();
    }

    public RandomAccessFileConnectionService getDefaultRandomAccessFileConnection() {
        return new RandomAccessFileConnection(this.getString("arcomiotransport.path", "/dev/arcom/aim104/relay8"), this.getString("arcomiotransport.name", "0"), this.getString("arcomiotransport.mode", "rw"));
    }

    public int getPollingRate() {
        return this.pollingRate;
    }

    public void setPollingRate(int pollingRate) {
        this.pollingRate = pollingRate;
    }

    public void setup() {
        super.setup();
        this.setPollingRate(this.getInt("arcomiotransport.pollingRate", this.getPollingRate()));
        this.setRetryTime(this.getLong("arcomiotransport.retrytime", this.getRetryTime()));
        this.setNoActivityTimeout(this.getLong("arcomiotransport.noactivitytimeout", this.getNoActivityTimeout()));
    }
}

