/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.comm.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class Library {
    public static final String HTTP = "http";
    public static final String FILE = "file";
    private static String pathtype = "";
    private static String bundlepath = "";

    public static void load_dkcomm() {
        if (!Library.load_from_java_lib_path()) {
            Library.load_from_bundle();
        }
    }

    private static void load_from_bundle() {
        String file_separator = System.getProperty("file.separator");
        String javalibpath = System.getProperty("java.library.path");
        String path_seperator = System.getProperty("path.separator");
        int i = javalibpath.indexOf(path_seperator);
        javalibpath = String.valueOf(javalibpath.substring(0, i)) + file_separator;
        String os = System.getProperty("osgi.ws");
        String processor = System.getProperty("org.osgi.framework.processor");
        String libname = "";
        if (os.equalsIgnoreCase("win32")) {
            libname = "dkcomm.dll";
        } else if (os.equalsIgnoreCase("linux")) {
            libname = "dkcomm.so";
        }
        String libpath = "lib/" + os + '/' + processor + '/';
        try {
            if (pathtype.equals(FILE)) {
                Library.unzipLib_local(javalibpath, libpath, libname, bundlepath);
            } else if (pathtype.equals(HTTP)) {
                Library.unzipLib_http(javalibpath, libpath, libname, bundlepath);
            }
        }
        catch (IOException iOException) {
            System.out.println("Fail to create " + libname + ", please place it to java library path.");
        }
        System.out.println("Load library: " + javalibpath + libname);
        try {
            System.load(String.valueOf(javalibpath) + libname);
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("Fail to load the library: " + e);
        }
    }

    private static boolean load_from_java_lib_path() {
        try {
            System.loadLibrary("dkcomm");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
        return true;
    }

    private static void performUnzip(BufferedInputStream input, BufferedOutputStream output) throws IOException {
        int block_size = 4000;
        byte[] block = new byte[block_size];
        int len = input.read(block, 0, block_size);
        while (len != -1) {
            output.write(block, 0, len);
            len = input.read(block, 0, block_size);
        }
        output.flush();
        input.close();
        output.close();
    }

    public static void setBundlepath(String type, String path) {
        pathtype = type;
        bundlepath = path;
    }

    private static void unzipLib_http(String javalibpath, String libpath, String libname, String url) throws IOException {
        ZipInputStream zipInput = new ZipInputStream(new URL(url).openStream());
        while (zipInput.available() != 0) {
            try {
                if (!zipInput.getNextEntry().getName().equals(String.valueOf(libpath) + libname)) continue;
                BufferedInputStream input = new BufferedInputStream(zipInput);
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(String.valueOf(javalibpath) + libname));
                Library.performUnzip(input, output);
            }
            catch (Exception exception) {}
            break;
        }
    }

    private static void unzipLib_local(String javalibpath, String libpath, String libname, String jarname) throws IOException {
        ZipFile bundleJar = new ZipFile(jarname);
        BufferedInputStream input = new BufferedInputStream(bundleJar.getInputStream(bundleJar.getEntry(String.valueOf(libpath) + libname)));
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(String.valueOf(javalibpath) + libname));
        Library.performUnzip(input, output);
    }
}

