/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.control.profile.test.agent;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.control.profile.ControlProfile;
import org.eclipse.soda.dk.control.profile.test.agent.ControlProfileAbstractTestCase;
import org.eclipse.soda.dk.testagent.TestAgent;

public class ControlProfileLongsTestCase
extends ControlProfileAbstractTestCase {
    static /* synthetic */ Class class$0;

    public ControlProfileLongsTestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.control.profile.test.agent.ControlProfileLongsTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        TestAgent.main((String[])stringArray);
    }

    public void test000_ControlLongsCount() throws InterruptedException {
        long expectedValue = Long.parseLong(this.getString("expected.bits.count.value", "0"));
        long realValue = Long.parseLong(this.getMeasurement(this.controlProfileServiceLongsCountExternalKey).toString());
        ControlProfileLongsTestCase.assertEquals((long)expectedValue, (long)realValue);
    }

    public void test010_ControlLongsDefaultValues() throws InterruptedException {
        Map controlLongs = this.GetLongs();
        String[] longNames = ControlProfile.LONG_NAMES;
        int i = 1;
        while (i < longNames.length) {
            Long longValue = (Long)controlLongs.get(longNames[i]);
            ControlProfileLongsTestCase.assertEquals((Object)longValue, (Object)new Long(0L));
            ++i;
        }
    }

    public void test020_ControlLongsSetAll() throws InterruptedException {
        String longsToSet = this.getString("longlist", "");
        String[] inputLongs = ControlProfileLongsTestCase.parseDelimitedByToken((String)longsToSet, (String)",");
        long numLongs = Long.parseLong(this.getString("expected.longs.count.value", "0"));
        ControlProfileLongsTestCase.assertEquals((long)inputLongs.length, (long)numLongs);
        Hashtable<String, Long> longs = new Hashtable<String, Long>();
        String[] longNames = ControlProfile.LONG_NAMES;
        int i = 1;
        while (i < longNames.length) {
            longs.put(longNames[i], new Long(Long.parseLong(inputLongs[i - 1], 16)));
            ++i;
        }
        this.WriteLongs(longs);
        Map controlLongs = this.GetLongs();
        int i2 = 1;
        while (i2 < longNames.length) {
            Long longValue = (Long)controlLongs.get(longNames[i2]);
            ControlProfileLongsTestCase.assertEquals((Object)longValue, (Object)new Long(Long.parseLong(inputLongs[i2 - 1], 16)));
            ++i2;
        }
    }

    public void test030_ControlLongsSetSome() throws InterruptedException {
        Hashtable<String, Long> longs = new Hashtable<String, Long>();
        String[] longNames = ControlProfile.LONG_NAMES;
        int i = 1;
        while (i < longNames.length) {
            longs.put(longNames[i], new Long(0L));
            ++i;
        }
        this.WriteLongs(longs);
        Hashtable<String, Long> newLongs = new Hashtable<String, Long>();
        newLongs.put("l3", new Long(5L));
        newLongs.put("l4", new Long(5L));
        this.WriteLongs(newLongs);
        Map controlLongs = this.GetLongs();
        int i2 = 1;
        while (i2 < longNames.length) {
            Long longValue = (Long)controlLongs.get(longNames[i2]);
            if (i2 == 3 || i2 == 4) {
                ControlProfileLongsTestCase.assertEquals((Object)longValue, (Object)new Long(5L));
            } else {
                ControlProfileLongsTestCase.assertEquals((Object)longValue, (Object)new Long(0L));
            }
            ++i2;
        }
    }
}

