/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.block.testcase;

import java.util.Hashtable;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.block.BytesBlock;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.ParameterMessage;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.MapParameter;
import org.eclipse.soda.dk.parameter.SimpleIntegerParameter;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class BlockTestcase
extends TestCase {
    public BlockTestcase() {
    }

    public BlockTestcase(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(BlockTestcase.class);
    }

    public void testEncode() {
        byte[] bytes = new byte[2];
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        byte[] bytesExpected = byArray;
        BytesBlock block0 = new BytesBlock(8);
        BytesBlock block1 = new BytesBlock(new byte[]{1});
        MapParameter mapParameter = new MapParameter("map", new ParameterService[]{block0, block1});
        Hashtable map = new Hashtable();
        ParameterMessage message = new ParameterMessage(bytes, (ParameterService)mapParameter);
        MessageService resultMessage = message.encodeMessage((MessageService)new Message(bytes), map);
        byte[] result = resultMessage.getBytes();
        int i = 0;
        while (i < bytesExpected.length) {
            BlockTestcase.assertEquals((byte)bytesExpected[i], (byte)result[i]);
            ++i;
        }
    }

    public void testEncodeInteger() {
        byte[] bytes = new byte[6];
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[5] = 2;
        byte[] bytesExpected = byArray;
        BytesBlock block0 = new BytesBlock(8);
        BytesBlock block1 = new BytesBlock(new byte[]{1});
        SimpleIntegerParameter si = new SimpleIntegerParameter("i0");
        MapParameter mapParameter = new MapParameter("map", new ParameterService[]{block0, block1, si});
        Hashtable<String, Integer> map = new Hashtable<String, Integer>();
        map.put("i0", new Integer(2));
        ParameterMessage message = new ParameterMessage(bytes, (ParameterService)mapParameter);
        MessageService resultMessage = message.encodeMessage((MessageService)new Message(bytes), map);
        byte[] result = resultMessage.getBytes();
        int i = 0;
        while (i < bytesExpected.length) {
            BlockTestcase.assertEquals((byte)bytesExpected[i], (byte)result[i]);
            ++i;
        }
    }
}

