/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.interest.testcase;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;

public class InterestTestcase
extends TestCase {
    public static final String EMPTY_STRING = new String();

    public InterestTestcase(String p1) {
        super(p1);
    }

    public static void main(String[] args) {
        TestRunner.run(InterestTestcase.class);
    }

    public void Test0Bytes() {
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 2;
        byte[] bytes = byArray;
        InterestMask interestMask = new InterestMask();
        boolean result = interestMask.isInterested(bytes);
        InterestTestcase.assertEquals((boolean)true, (boolean)result);
    }

    public void test0() {
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 2;
        byte[] bytes = byArray;
        Message message = new Message(bytes);
        InterestMask interestMask = new InterestMask();
        boolean result = interestMask.isInterested((MessageService)message);
        InterestTestcase.assertEquals((boolean)true, (boolean)result);
    }

    public void test1() {
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 2;
        byte[] bytes = byArray;
        Message message = new Message(bytes);
        byte[] patternMask = new byte[1];
        byte[] careMask = new byte[]{-1};
        InterestMask interestMask = new InterestMask(patternMask, careMask);
        boolean result = interestMask.isInterested((MessageService)message);
        InterestTestcase.assertEquals((boolean)true, (boolean)result);
    }

    public void test10() {
        byte[] patternMask = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        InterestMask interestMask = new InterestMask(0, patternMask.length * 8, patternMask);
        byte[] careMask = interestMask.getCareMask();
        int i = 0;
        while (i < careMask.length) {
            InterestTestcase.assertTrue((String)String.valueOf(i), (careMask[i] == -1 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void test11() {
        byte[] patternMask = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, 1, 35, 69, 103, -119, -85, -51, -17};
        InterestMask interestMask = new InterestMask(0, patternMask.length * 8, patternMask);
        byte[] careMask = interestMask.getCareMask();
        int i = 0;
        while (i < careMask.length) {
            InterestTestcase.assertTrue((String)String.valueOf(i), (careMask[i] == -1 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void test12() {
        byte[] patternMask = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        InterestMask interestMask = new InterestMask(0, patternMask.length * 8 - 1, patternMask);
        byte[] careMask = interestMask.getCareMask();
        int i = 0;
        while (i < careMask.length) {
            if (i == 7) {
                InterestTestcase.assertTrue((String)String.valueOf(i), (careMask[i] == -2 ? 1 : 0) != 0);
            } else {
                InterestTestcase.assertTrue((String)String.valueOf(i), (careMask[i] == -1 ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void test13() {
        byte[] patternMask = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        InterestMask interestMask = new InterestMask(8, patternMask.length * 8 - 1, patternMask);
        byte[] careMask = interestMask.getCareMask();
        int i = 0;
        while (i < careMask.length) {
            switch (i) {
                case 0: {
                    InterestTestcase.assertTrue((String)String.valueOf(i), (careMask[i] == 0 ? 1 : 0) != 0);
                    break;
                }
                case 8: {
                    InterestTestcase.assertTrue((String)String.valueOf(i), (careMask[i] == -2 ? 1 : 0) != 0);
                    break;
                }
                default: {
                    InterestTestcase.assertTrue((String)String.valueOf(i), (careMask[i] == -1 ? 1 : 0) != 0);
                }
            }
            ++i;
        }
    }

    public void test15() {
        byte[] patternMask = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, 1, 35, 69, 103, -119, -85, -51, -17};
        InterestMask interestMask = new InterestMask(1, patternMask.length * 8, patternMask);
        byte[] careMask = interestMask.getCareMask();
        int i = 0;
        while (i < careMask.length) {
            switch (i) {
                case 0: {
                    InterestTestcase.assertTrue((String)(String.valueOf(String.valueOf(i)) + ' ' + careMask[i]), (careMask[i] == 127 ? 1 : 0) != 0);
                    break;
                }
                case 16: {
                    InterestTestcase.assertTrue((String)String.valueOf(i), ((careMask[i] & 0xFF) == 128 ? 1 : 0) != 0);
                    break;
                }
                default: {
                    InterestTestcase.assertTrue((String)String.valueOf(i), (careMask[i] == -1 ? 1 : 0) != 0);
                }
            }
            ++i;
        }
        byte[] pattern = interestMask.getPatternMask();
        int i2 = 0;
        while (i2 < pattern.length) {
            switch (i2) {
                case 0: {
                    InterestTestcase.assertTrue((String)(String.valueOf(String.valueOf(i2)) + ' ' + pattern[i2]), (pattern[i2] == patternMask[i2] >>> 1 ? 1 : 0) != 0);
                    break;
                }
                case 16: {
                    InterestTestcase.assertTrue((String)String.valueOf(i2), ((pattern[i2] & 0xFF) == 128 ? 1 : 0) != 0);
                    break;
                }
                default: {
                    byte newValue = (byte)(((patternMask[i2] & 0xFF) >> 1) + ((patternMask[i2 - 1] & 1) << 7));
                    InterestTestcase.assertTrue((String)(String.valueOf(String.valueOf(i2)) + ' ' + Integer.toHexString(pattern[i2] & 0xFF) + ' ' + Integer.toHexString(newValue & 0xFF)), (pattern[i2] == newValue ? 1 : 0) != 0);
                }
            }
            ++i2;
        }
    }

    public void test1Bytes() {
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 2;
        byte[] bytes = byArray;
        byte[] patternMask = new byte[1];
        byte[] careMask = new byte[]{-1};
        InterestMask interestMask = new InterestMask(patternMask, careMask);
        boolean result = interestMask.isInterested(bytes);
        InterestTestcase.assertEquals((boolean)true, (boolean)result);
    }

    public void test2() {
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 2;
        byte[] bytes = byArray;
        Message message = new Message(bytes);
        byte[] patternMask = new byte[]{1};
        byte[] careMask = new byte[]{-1};
        InterestMask interestMask = new InterestMask(patternMask, careMask);
        boolean result = interestMask.isInterested((MessageService)message);
        InterestTestcase.assertEquals((boolean)false, (boolean)result);
    }

    public void test2Bytes() {
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 2;
        byte[] bytes = byArray;
        byte[] patternMask = new byte[]{1};
        byte[] careMask = new byte[]{-1};
        InterestMask interestMask = new InterestMask(patternMask, careMask);
        boolean result = interestMask.isInterested(bytes);
        InterestTestcase.assertEquals((boolean)false, (boolean)result);
    }

    public void test3() {
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 2;
        byte[] bytes = byArray;
        Message message = new Message(bytes);
        byte[] byArray2 = new byte[2];
        byArray2[1] = 1;
        byte[] patternMask = byArray2;
        byte[] careMask = new byte[]{-1, -1};
        InterestMask interestMask = new InterestMask(patternMask, careMask);
        boolean result = interestMask.isInterested((MessageService)message);
        InterestTestcase.assertEquals((boolean)true, (boolean)result);
    }

    public void test3Bytes() {
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 2;
        byte[] bytes = byArray;
        byte[] byArray2 = new byte[2];
        byArray2[1] = 1;
        byte[] patternMask = byArray2;
        byte[] careMask = new byte[]{-1, -1};
        InterestMask interestMask = new InterestMask(patternMask, careMask);
        boolean result = interestMask.isInterested(bytes);
        InterestTestcase.assertEquals((boolean)true, (boolean)result);
    }

    public void test4() {
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 2;
        byte[] bytes = byArray;
        Message message = new Message(bytes);
        byte[] patternMask = new byte[2];
        byte[] careMask = new byte[]{-1, -1};
        InterestMask interestMask = new InterestMask(patternMask, careMask);
        boolean result = interestMask.isInterested((MessageService)message);
        InterestTestcase.assertEquals((boolean)false, (boolean)result);
    }

    public void test4Bytes() {
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 2;
        byte[] bytes = byArray;
        byte[] patternMask = new byte[2];
        byte[] careMask = new byte[]{-1, -1};
        InterestMask interestMask = new InterestMask(patternMask, careMask);
        boolean result = interestMask.isInterested(bytes);
        InterestTestcase.assertEquals((boolean)false, (boolean)result);
    }
}

