/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter.testcase;

import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.BitsParameter;

public class BitsParameterTestcase
extends TestCase {
    public static final String EMPTY_STRING = new String();

    public BitsParameterTestcase(String p1) {
        super(p1);
    }

    public static void main(String[] args) {
        TestRunner.run(BitsParameterTestcase.class);
    }

    public void testDecode01() throws UnsupportedEncodingException {
        BitsParameter parameter = new BitsParameter("", 0, 16);
        Message message = new Message(new byte[]{18, 52});
        byte[] result = (byte[])parameter.decodeValue((MessageService)message);
        byte[] bytesExpected = new byte[]{18, 52};
        int i = 0;
        while (i < bytesExpected.length) {
            BitsParameterTestcase.assertEquals((byte)bytesExpected[i], (byte)result[i]);
            ++i;
        }
    }

    public void testDecode02() throws UnsupportedEncodingException {
        BitsParameter parameter = new BitsParameter("", 0, 8);
        Message message = new Message(new byte[]{18, 52});
        byte[] result = (byte[])parameter.decodeValue((MessageService)message);
        byte[] bytesExpected = new byte[]{18};
        int i = 0;
        while (i < bytesExpected.length) {
            BitsParameterTestcase.assertEquals((byte)bytesExpected[i], (byte)result[i]);
            ++i;
        }
    }

    public void testDecode03() throws UnsupportedEncodingException {
        BitsParameter parameter = new BitsParameter("", 0, 7);
        Message message = new Message(new byte[]{18, 52});
        boolean[] result = (boolean[])parameter.decodeValue((MessageService)message);
        boolean[] blArray = new boolean[7];
        blArray[3] = true;
        blArray[6] = true;
        boolean[] bytesExpected = blArray;
        int i = 0;
        while (i < bytesExpected.length) {
            BitsParameterTestcase.assertEquals((boolean)bytesExpected[i], (boolean)result[i]);
            ++i;
        }
    }

    public void testDecode04() throws UnsupportedEncodingException {
        BitsParameter parameter = new BitsParameter("", 0, 9);
        Message message = new Message(new byte[]{18, 52});
        boolean[] result = (boolean[])parameter.decodeValue((MessageService)message);
        boolean[] blArray = new boolean[9];
        blArray[3] = true;
        blArray[6] = true;
        boolean[] bytesExpected = blArray;
        int i = 0;
        while (i < bytesExpected.length) {
            BitsParameterTestcase.assertEquals((boolean)bytesExpected[i], (boolean)result[i]);
            ++i;
        }
    }
}

