/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter.testcase;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.block.IdentifierBlock;
import org.eclipse.soda.dk.block.MessageSizeBlock;
import org.eclipse.soda.dk.block.ReserveBlock;
import org.eclipse.soda.dk.block.SegmentSizeBlock;
import org.eclipse.soda.dk.block.TypeBlock;
import org.eclipse.soda.dk.block.VersionBlock;
import org.eclipse.soda.dk.filter.SimpleFilter;
import org.eclipse.soda.dk.filter.service.FilterService;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.ParameterMessage;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.parameter.BytesParameter;
import org.eclipse.soda.dk.parameter.MapParameter;
import org.eclipse.soda.dk.parameter.SimpleByteParameter;
import org.eclipse.soda.dk.parameter.SimpleIntegerParameter;
import org.eclipse.soda.dk.parameter.service.BlockService;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.parameter.service.SegmentService;
import org.eclipse.soda.dk.segment.MultiSegment;
import org.eclipse.soda.dk.segment.SimpleSegment;

public class CustomParameterTestcase
extends TestCase {
    public static final String EMPTY_STRING = new String();
    private static final FilterService TwoBytesFilter = new SimpleFilter(0, 2);
    private static final ParameterService MessageSubtype = new SimpleByteParameter("MessageSubtype");
    private static final ParameterService CustomData = new BytesParameter("CustomData", Integer.MIN_VALUE, Integer.MIN_VALUE);
    private static final ParameterService VendorIdentifier = new SimpleIntegerParameter("VendorIdentifier");
    private static final BlockService MessageReserveBlock = new ReserveBlock("MessageReserveBlock", new byte[1], 3);
    private static final BlockService MessageVersionBlock = new VersionBlock("MessageVersionBlock", new byte[]{32}, 3);
    private static final BlockService MessageIdBlock = new IdentifierBlock("MessageIdBlock", 32);
    private static final BlockService MessageLengthBlock = new MessageSizeBlock("MessageLengthBlock", 32);
    private static final ParameterService CustomParameterValue = new BytesParameter("CustomParameterValue", Integer.MIN_VALUE, Integer.MIN_VALUE);
    private static final BlockService SegmentLengthBlock = new SegmentSizeBlock("SegmentLengthBlock", 16);
    private static final ParameterService ParameterSubtype = new SimpleIntegerParameter("ParameterSubtype");
    private static final BlockService TLVParameterReserveBlock = new ReserveBlock("TLVParameterReserveBlock", new byte[1], 6);
    private static final SegmentService CustomParameter = new SimpleSegment("CustomParameter", new byte[]{3, -1}, CustomParameterTestcase.getTwoBytesFilter(), (ParameterService)new MapParameter("CustomParameter", new ParameterService[]{CustomParameterTestcase.getTLVParameterReserveBlock(), new TypeBlock(new byte[]{-1, -64}, 10), CustomParameterTestcase.getSegmentLengthBlock(), CustomParameterTestcase.getVendorIdentifier(), CustomParameterTestcase.getParameterSubtype(), CustomParameterTestcase.getCustomParameterValue()}));
    private static final SegmentService CustomParameter_0_N = new MultiSegment("CustomParameter", new byte[]{3, -1}, CustomParameterTestcase.getTwoBytesFilter(), (ParameterService)new MapParameter("CustomParameter", new ParameterService[]{CustomParameterTestcase.getTLVParameterReserveBlock(), new TypeBlock(new byte[]{-1, -64}, 10), CustomParameterTestcase.getSegmentLengthBlock(), CustomParameterTestcase.getVendorIdentifier(), CustomParameterTestcase.getParameterSubtype(), CustomParameterTestcase.getCustomParameterValue()}), 0, Integer.MAX_VALUE);
    private static final MessageService GetReaderCapabilitiesResponseMessage;
    private static final MessageService CustomMessageMessage;

    static {
        byte[] byArray = new byte[10];
        byArray[0] = 4;
        byArray[1] = 11;
        GetReaderCapabilitiesResponseMessage = new ParameterMessage(byArray, CustomParameterTestcase.getTwoBytesFilter(), (ParameterService)new MapParameter("GetReaderCapabilitiesResponseMessage", new ParameterService[]{CustomParameterTestcase.getMessageReserveBlock(), CustomParameterTestcase.getMessageVersionBlock(), new TypeBlock(new byte[]{2, -64}, 10), CustomParameterTestcase.getMessageLengthBlock(), CustomParameterTestcase.getMessageIdBlock(), CustomParameterTestcase.getCustomParameter_0_N()}));
        byte[] byArray2 = new byte[15];
        byArray2[0] = 7;
        byArray2[1] = -1;
        byArray2[9] = 1;
        CustomMessageMessage = new ParameterMessage(byArray2, CustomParameterTestcase.getTwoBytesFilter(), (ParameterService)new MapParameter("CustomMessageMessage", new ParameterService[]{CustomParameterTestcase.getMessageReserveBlock(), CustomParameterTestcase.getMessageVersionBlock(), new TypeBlock(new byte[]{-1, -64}, 10), CustomParameterTestcase.getMessageLengthBlock(), CustomParameterTestcase.getMessageIdBlock(), CustomParameterTestcase.getVendorIdentifier(), CustomParameterTestcase.getMessageSubtype(), CustomParameterTestcase.getCustomData()}));
    }

    public CustomParameterTestcase(String p1) {
        super(p1);
    }

    public static ParameterService getCustomData() {
        return CustomData;
    }

    public static SegmentService getCustomParameter() {
        return CustomParameter;
    }

    public static ParameterService getCustomParameterValue() {
        return CustomParameterValue;
    }

    public static SegmentService getCustomParameter_0_N() {
        return CustomParameter_0_N;
    }

    public static MessageService getGetReaderCapabilitiesResponseMessage() {
        return GetReaderCapabilitiesResponseMessage;
    }

    public static BlockService getMessageIdBlock() {
        return MessageIdBlock;
    }

    public static BlockService getMessageLengthBlock() {
        return MessageLengthBlock;
    }

    public static BlockService getMessageReserveBlock() {
        return MessageReserveBlock;
    }

    public static ParameterService getMessageSubtype() {
        return MessageSubtype;
    }

    public static BlockService getMessageVersionBlock() {
        return MessageVersionBlock;
    }

    public static ParameterService getParameterSubtype() {
        return ParameterSubtype;
    }

    public static BlockService getSegmentLengthBlock() {
        return SegmentLengthBlock;
    }

    public static BlockService getTLVParameterReserveBlock() {
        return TLVParameterReserveBlock;
    }

    public static FilterService getTwoBytesFilter() {
        return TwoBytesFilter;
    }

    public static ParameterService getVendorIdentifier() {
        return VendorIdentifier;
    }

    public static void main(String[] args) {
        TestRunner.run(CustomParameterTestcase.class);
    }

    public MessageService getCustomMessageMessage() {
        return CustomMessageMessage;
    }

    public void testDecodeCustomMessage() {
        byte[] byArray = new byte[17];
        byArray[0] = 7;
        byArray[1] = -1;
        byArray[5] = 17;
        byArray[9] = 1;
        byArray[13] = 4;
        byArray[14] = 5;
        byArray[15] = 1;
        byArray[16] = 2;
        byte[] bytes = byArray;
        Message message = new Message(bytes);
        Object value = CustomMessageMessage.decodeMessage((MessageService)message);
        System.out.println("CustomMessageMessage value " + Nls.formatData((Object)value));
    }

    public void testDecodeCustomParameter() {
        byte[] byArray = new byte[36];
        byArray[0] = 4;
        byArray[1] = 11;
        byArray[5] = 36;
        byArray[10] = 3;
        byArray[11] = -1;
        byArray[13] = 13;
        byArray[17] = 4;
        byArray[21] = 6;
        byArray[22] = 8;
        byArray[23] = 3;
        byArray[24] = -1;
        byArray[26] = 13;
        byArray[30] = 4;
        byArray[34] = 7;
        byArray[35] = 9;
        byte[] bytes = byArray;
        Message message = new Message(bytes);
        Object value = GetReaderCapabilitiesResponseMessage.decodeMessage((MessageService)message);
        System.out.println("GetReaderCapabilitiesResponseMessage value " + Nls.formatData((Object)value));
    }

    public void testEncodeCustomMessage() {
        byte[] byArray = new byte[17];
        byArray[0] = 7;
        byArray[1] = -1;
        byArray[5] = 17;
        byArray[9] = 1;
        byArray[13] = 4;
        byArray[14] = 5;
        byArray[15] = 1;
        byArray[16] = 2;
        byte[] bytes = byArray;
        Message message = new Message(bytes);
        Object value = CustomMessageMessage.decodeMessage((MessageService)message);
        byte[] mbytes = CustomMessageMessage.getBytes();
        Message smessage = new Message(mbytes);
        MessageService resultMessage = CustomMessageMessage.encodeMessage((MessageService)smessage, value);
        System.out.println("CustomMessageMessage result " + resultMessage);
    }
}

