/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter.testcase;

import java.util.List;
import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.block.CountBlock;
import org.eclipse.soda.dk.message.AsciiMessage;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.ParameterMessage;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.ListParameter;
import org.eclipse.soda.dk.parameter.SimpleByteParameter;
import org.eclipse.soda.dk.parameter.SimpleParameter;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.parameter.testcase.Messages;

public class ListParameterTestcase
extends TestCase {
    public static final String EMPTY_STRING = new String();

    public ListParameterTestcase(String p1) {
        super(p1);
    }

    public static void main(String[] args) {
        TestRunner.run(ListParameterTestcase.class);
    }

    public void testDecodeCountByte() {
        CountBlock parameter = new CountBlock(8);
        SimpleByteParameter parameterTwo = new SimpleByteParameter();
        ListParameter parameters = new ListParameter(Messages.getString("ListParameterTestcase.0"), new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{2, 10, 1});
        Object result = parameters.decodeValue((MessageService)message);
        ListParameterTestcase.assertEquals((boolean)true, (boolean)(result instanceof List));
        Object value = ((List)result).get(0);
        ListParameterTestcase.assertEquals(value, (Object)new Integer(10));
        Object valueTwo = ((List)result).get(1);
        ListParameterTestcase.assertEquals(valueTwo, (Object)new Integer(1));
    }

    public void testDecodeInteger() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 2, 1, 1);
        ListParameter parameters = new ListParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, 10, 1});
        Object result = parameters.decodeValue((MessageService)message);
        ListParameterTestcase.assertEquals((boolean)true, (boolean)(result instanceof List));
        Object value = ((List)result).get(0);
        ListParameterTestcase.assertEquals(value, (Object)new Integer(10));
        Object valueTwo = ((List)result).get(1);
        ListParameterTestcase.assertEquals(valueTwo, (Object)new Integer(1));
    }

    public void testDecodeIntegerCursor() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, -1, 1, 1);
        SimpleParameter parameterThree = new SimpleParameter(EMPTY_STRING, null, -1, 2, 1);
        ListParameter parameters = new ListParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo, parameterThree});
        Message message = new Message(new byte[]{90, 10, 1, 1, 2});
        Object result = parameters.decodeValue((MessageService)message);
        ListParameterTestcase.assertEquals((boolean)true, (boolean)(result instanceof List));
        Object value = ((List)result).get(0);
        ListParameterTestcase.assertEquals(value, (Object)new Integer(10));
        Object valueTwo = ((List)result).get(1);
        ListParameterTestcase.assertEquals(valueTwo, (Object)new Integer(1));
        Object valueThree = ((List)result).get(2);
        ListParameterTestcase.assertEquals((Object)new Integer(258), valueThree);
    }

    public void testEncodeCountByte() {
        CountBlock parameter = new CountBlock(8);
        SimpleByteParameter parameterTwo = new SimpleByteParameter();
        ListParameter parameters = new ListParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        ParameterMessage message = new ParameterMessage(new byte[1], (ParameterService)parameters);
        Vector<Integer> list = new Vector<Integer>();
        list.add(new Integer(3));
        list.add(new Integer(4));
        MessageService resultMessage = message.encodeMessage((MessageService)message, list);
        byte[] result = resultMessage.getBytes();
        byte[] expected = new byte[]{2, 3, 4};
        int i = 0;
        while (i < expected.length) {
            ListParameterTestcase.assertEquals((byte)expected[i], (byte)result[i]);
            ++i;
        }
    }

    public void testEncodeInteger() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 2, 1, 1);
        ListParameter parameters = new ListParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, -1, -1});
        Vector<Integer> values = new Vector<Integer>();
        values.add(new Integer(1));
        values.add(new Integer(5));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        ListParameterTestcase.assertEquals((byte)result.getBytes()[1], (byte)1);
        ListParameterTestcase.assertEquals((byte)result.getBytes()[2], (byte)5);
    }

    public void testEncodeInteger8() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        ListParameter parameters = new ListParameter(EMPTY_STRING, new ParameterService[]{parameter});
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        Message message = new Message(byArray);
        Vector<Integer> values = new Vector<Integer>();
        values.add(new Integer(2));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        ListParameterTestcase.assertEquals((byte)result.getBytes()[1], (byte)2);
    }

    public void testEncodeIntegerCursor() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 2, 1, 1);
        ListParameter parameters = new ListParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, -1, -1});
        Vector<Integer> values = new Vector<Integer>();
        values.add(new Integer(1));
        values.add(new Integer(5));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        ListParameterTestcase.assertEquals((byte)90, (byte)result.getBytes()[0]);
        ListParameterTestcase.assertEquals((byte)1, (byte)result.getBytes()[1]);
        ListParameterTestcase.assertEquals((byte)5, (byte)result.getBytes()[2]);
    }

    public void testEncodeLong() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 8, 225);
        ListParameter parameters = new ListParameter(EMPTY_STRING, new ParameterService[]{parameter});
        byte[] byArray = new byte[9];
        byArray[0] = 90;
        Message message = new Message(byArray);
        Vector<Long> values = new Vector<Long>();
        values.add(new Long(Long.MAX_VALUE));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        ListParameterTestcase.assertEquals((byte)result.getBytes()[1], (byte)127);
    }

    public void testEncodeString() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 0, 68);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 1, 0, 68);
        SimpleParameter parameterThree = new SimpleParameter(EMPTY_STRING, null, 1, 0, 68);
        ListParameter parameters = new ListParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo, parameterThree});
        AsciiMessage message = new AsciiMessage("09");
        Vector<String> values = new Vector<String>();
        values.add("abc");
        values.add(null);
        values.add("def");
        MessageService result = parameters.encodeValue((MessageService)message, values);
        ListParameterTestcase.assertEquals((int)result.getBytes()[1], (int)97);
        ListParameterTestcase.assertEquals((int)result.getBytes()[2], (int)98);
        ListParameterTestcase.assertEquals((String)new String(result.getBytes()), (String)"0abcdef9");
    }

    public void testEncodeVariable() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 2, 0, 84);
        ListParameter parameters = new ListParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, -1, -1});
        Vector<Object> values = new Vector<Object>();
        values.add(new Integer(1));
        values.add(new byte[]{5, 6});
        MessageService result = parameters.encodeValue((MessageService)message, values);
        ListParameterTestcase.assertEquals((byte)90, (byte)result.getBytes()[0]);
        ListParameterTestcase.assertEquals((byte)1, (byte)result.getBytes()[1]);
        ListParameterTestcase.assertEquals((byte)5, (byte)result.getBytes()[2]);
        ListParameterTestcase.assertEquals((byte)6, (byte)result.getBytes()[3]);
        ListParameterTestcase.assertEquals((byte)-1, (byte)result.getBytes()[4]);
    }

    public void testEncodeVariable2() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 0, 84);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 2, 0, 84);
        ListParameter parameters = new ListParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, -1, -1});
        Message expected = new Message(new byte[]{90, 1, 2, -1, 5, 6, -1});
        Vector<byte[]> values = new Vector<byte[]>();
        values.add(new byte[]{1, 2});
        values.add(new byte[]{5, 6});
        MessageService result = parameters.encodeValue((MessageService)message, values);
        byte[] expectedBytes = expected.getBytes();
        int i = 0;
        while (i < expectedBytes.length) {
            ListParameterTestcase.assertEquals((byte)expectedBytes[i], (byte)result.getBytes()[i]);
            ++i;
        }
    }

    public void testTrue() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 48);
        ListParameter parameters = new ListParameter(EMPTY_STRING, new ParameterService[]{parameter});
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        byArray[1] = 8;
        Message message = new Message(byArray);
        Object result = parameters.decodeValue((MessageService)message);
        ListParameterTestcase.assertEquals((boolean)true, (boolean)(result instanceof List));
        Object value = ((List)result).get(0);
        ListParameterTestcase.assertEquals(value, (Object)Boolean.TRUE);
    }
}

