/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter.testcase;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.block.ByteLengthBlock;
import org.eclipse.soda.dk.block.LengthBlock;
import org.eclipse.soda.dk.block.SizeBlock;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.MapParameters;
import org.eclipse.soda.dk.parameter.ParameterCursor;
import org.eclipse.soda.dk.parameter.StringParameter;
import org.eclipse.soda.dk.parameter.Utf8StringParameter;
import org.eclipse.soda.dk.parameter.VariableLengthParameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.segment.SimpleSegment;

public class StringParameterTestcase
extends TestCase {
    public static final String EMPTY_STRING = new String();

    public StringParameterTestcase(String p1) {
        super(p1);
    }

    public static void main(String[] args) {
        TestRunner.run(StringParameterTestcase.class);
    }

    public void testDecode01() throws UnsupportedEncodingException {
        StringParameter parameter = new StringParameter("", 0, 16, "UTF-8");
        Message message = new Message(new String("abc").getBytes("UTF-8"));
        Object result = parameter.decodeValue((MessageService)message);
        StringParameterTestcase.assertEquals((Object)"ab", (Object)result);
    }

    public void testDecode02() throws UnsupportedEncodingException {
        StringParameter parameter = new StringParameter("", 0, Integer.MAX_VALUE, "UTF-8");
        Message message = new Message(new String("abc").getBytes("UTF-8"));
        ParameterCursor cursor = new ParameterCursor();
        cursor.setLength(16);
        Object result = parameter.decodeValue((MessageService)message, (ParameterCursorService)cursor);
        StringParameterTestcase.assertEquals((Object)"ab", (Object)result);
    }

    public void testDecode03() throws UnsupportedEncodingException {
        ByteLengthBlock lengthBlock = new ByteLengthBlock("", 0, 16);
        StringParameter parameter = new StringParameter("", Integer.MAX_VALUE, Integer.MAX_VALUE, "UTF-8");
        byte[] byArray = new byte[5];
        byArray[1] = 2;
        byArray[2] = 97;
        byArray[3] = 98;
        byArray[4] = 99;
        Message message = new Message(byArray);
        ParameterCursor cursor = new ParameterCursor();
        Object resultLength = lengthBlock.decodeValue((MessageService)message, (ParameterCursorService)cursor);
        StringParameterTestcase.assertEquals((Object)new Integer(16), (Object)resultLength);
        Object result = parameter.decodeValue((MessageService)message, (ParameterCursorService)cursor);
        StringParameterTestcase.assertEquals((Object)"ab", (Object)result);
    }

    public void testDecode03b() throws UnsupportedEncodingException {
        ByteLengthBlock lengthBlock = new ByteLengthBlock("", 0, 16);
        StringParameter parameter = new StringParameter("", Integer.MAX_VALUE, Integer.MAX_VALUE, "UTF-8");
        byte[] byArray = new byte[5];
        byArray[2] = 97;
        byArray[3] = 98;
        byArray[4] = 99;
        Message message = new Message(byArray);
        ParameterCursor cursor = new ParameterCursor();
        Object resultLength = lengthBlock.decodeValue((MessageService)message, (ParameterCursorService)cursor);
        StringParameterTestcase.assertEquals((Object)new Integer(0), (Object)resultLength);
        Object result = parameter.decodeValue((MessageService)message, (ParameterCursorService)cursor);
        StringParameterTestcase.assertEquals((Object)"", (Object)result);
    }

    public void testDecode04() throws UnsupportedEncodingException {
        ByteLengthBlock lengthBlock = new ByteLengthBlock("", 0, 16);
        StringParameter parameter = new StringParameter("string", Integer.MAX_VALUE, Integer.MAX_VALUE, "UTF-8");
        MapParameters mapParameters = new MapParameters("", new ParameterService[]{lengthBlock, parameter});
        byte[] byArray = new byte[5];
        byArray[1] = 2;
        byArray[2] = 97;
        byArray[3] = 98;
        byArray[4] = 99;
        Message message = new Message(byArray);
        Map result = (Map)mapParameters.decodeValue((MessageService)message);
        StringParameterTestcase.assertEquals((Object)"ab", result.get("string"));
    }

    public void testDecode05() throws UnsupportedEncodingException {
        ByteLengthBlock lengthBlock = new ByteLengthBlock("", 8, 16);
        StringParameter parameter = new StringParameter("string", Integer.MAX_VALUE, Integer.MAX_VALUE, "UTF-8");
        MapParameters mapParameters = new MapParameters("", new ParameterService[]{lengthBlock, parameter});
        SimpleSegment segment = new SimpleSegment(new byte[]{1}, null, (ParameterService)mapParameters);
        byte[] byArray = new byte[6];
        byArray[0] = 1;
        byArray[2] = 2;
        byArray[3] = 97;
        byArray[4] = 98;
        byArray[5] = 99;
        Message message = new Message(byArray);
        Map result = (Map)segment.decodeValue((MessageService)message);
        StringParameterTestcase.assertEquals((Object)"ab", result.get("string"));
    }

    public void testEncode01() throws UnsupportedEncodingException {
        StringParameter parameter = new StringParameter("", 0, 8, "UTF-8");
        Message message = new Message(new String("abc").getBytes("UTF-8"));
        MessageService result = parameter.encodeValue((MessageService)message, (Object)"x");
        StringParameterTestcase.assertEquals((byte)120, (byte)result.getBytes()[0]);
    }

    public void testEncode02() throws UnsupportedEncodingException {
        StringParameter parameter = new StringParameter("", -8, 8, "UTF-8");
        Message message = new Message(new String("abc").getBytes("UTF-8"));
        MessageService result = parameter.encodeValue((MessageService)message, (Object)"x");
        StringParameterTestcase.assertEquals((byte)120, (byte)result.getBytes()[1]);
    }

    public void testEncode03() throws UnsupportedEncodingException {
        try {
            StringParameter parameter = new StringParameter("", -8, 8, "bad");
            StringParameterTestcase.fail((String)String.valueOf(parameter));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void testEncode04() throws UnsupportedEncodingException {
        LengthBlock sizeBlock = new LengthBlock("", 8);
        Utf8StringParameter parameter = new Utf8StringParameter("");
        VariableLengthParameter variableLengthParameter = new VariableLengthParameter("v", new ParameterService[]{sizeBlock, parameter});
        Message message = new Message(new byte[4]);
        MessageService result = variableLengthParameter.encodeValue((MessageService)message, (Object)"xyz");
        StringParameterTestcase.assertEquals((int)24, (int)result.getBytes()[0]);
    }

    public void testEncode05() throws UnsupportedEncodingException {
        SizeBlock sizeBlock = new SizeBlock("", 8);
        Utf8StringParameter parameter = new Utf8StringParameter("");
        VariableLengthParameter variableLengthParameter = new VariableLengthParameter("v", new ParameterService[]{sizeBlock, parameter});
        Message message = new Message(new byte[4]);
        MessageService result = variableLengthParameter.encodeValue((MessageService)message, (Object)"xyz");
        StringParameterTestcase.assertEquals((byte)3, (byte)result.getBytes()[0]);
    }
}

