/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.segment.testcase;

import java.io.Serializable;
import java.util.Hashtable;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.block.SegmentLengthBlock;
import org.eclipse.soda.dk.block.SegmentSizeBlock;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.IntegerParameter;
import org.eclipse.soda.dk.parameter.MapParameter;
import org.eclipse.soda.dk.parameter.SimpleIntegerParameter;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.segment.OptionalSegment;
import org.eclipse.soda.dk.segment.SimpleSegment;

public class SegmentTestcase
extends TestCase {
    public static final String EMPTY_STRING = new String();

    public SegmentTestcase(String p1) {
        super(p1);
    }

    public static void main(String[] args) {
        TestRunner.run(SegmentTestcase.class);
    }

    public void testEncodeOptionalSegmentInteger() {
        SimpleIntegerParameter parameter = new SimpleIntegerParameter("i0");
        SimpleIntegerParameter parameterTwo = new SimpleIntegerParameter("i1");
        MapParameter map = new MapParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        OptionalSegment segment = new OptionalSegment("Segment", new byte[1], null, (ParameterService)map);
        Message message = new Message(new byte[]{3});
        byte[] byArray = new byte[9];
        byArray[3] = 1;
        byArray[7] = 2;
        byArray[8] = 3;
        Message expected = new Message(byArray);
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        values.put("i0", new Integer(1));
        values.put("i1", new Integer(2));
        MessageService result = segment.encodeValue((MessageService)message, values);
        byte[] expectedBytes = expected.getBytes();
        int i = 0;
        while (i < expectedBytes.length) {
            SegmentTestcase.assertEquals((byte)expectedBytes[i], (byte)result.getBytes()[i]);
            ++i;
        }
    }

    public void testEncodeSegmentInteger() {
        SimpleIntegerParameter parameter = new SimpleIntegerParameter("i0");
        SimpleIntegerParameter parameterTwo = new SimpleIntegerParameter("i1");
        MapParameter map = new MapParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        SimpleSegment segment = new SimpleSegment("Segment", new byte[1], null, (ParameterService)map);
        Message message = new Message(new byte[9]);
        byte[] byArray = new byte[8];
        byArray[3] = 1;
        byArray[7] = 2;
        Message expected = new Message(byArray);
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        values.put("i0", new Integer(1));
        values.put("i1", new Integer(2));
        MessageService result = segment.encodeValue((MessageService)message, values);
        byte[] expectedBytes = expected.getBytes();
        int i = 0;
        while (i < expectedBytes.length) {
            SegmentTestcase.assertEquals((byte)expectedBytes[i], (byte)result.getBytes()[i]);
            ++i;
        }
    }

    public void testEncodeSegmentIntegerOffset() {
        SimpleIntegerParameter parameter = new SimpleIntegerParameter("i0");
        IntegerParameter parameterTwo = new IntegerParameter("i1", 40, 32);
        MapParameter map = new MapParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        SimpleSegment segment = new SimpleSegment("Segment", new byte[1], null, (ParameterService)map);
        Message message = new Message(new byte[9]);
        byte[] byArray = new byte[9];
        byArray[3] = 1;
        byArray[8] = 2;
        Message expected = new Message(byArray);
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        values.put("i0", new Integer(1));
        values.put("i1", new Integer(2));
        MessageService result = segment.encodeValue((MessageService)message, values);
        byte[] expectedBytes = expected.getBytes();
        int i = 0;
        while (i < expectedBytes.length) {
            SegmentTestcase.assertEquals((byte)expectedBytes[i], (byte)result.getBytes()[i]);
            ++i;
        }
    }

    public void testEncodeSegmentLength() {
        SegmentLengthBlock parameter = new SegmentLengthBlock(8);
        SimpleIntegerParameter parameterTwo = new SimpleIntegerParameter("i0");
        MapParameter map = new MapParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        SimpleSegment segment = new SimpleSegment("Segment", new byte[1], null, (ParameterService)map);
        Message message = new Message(new byte[5]);
        byte[] byArray = new byte[5];
        byArray[0] = 40;
        byArray[4] = 1;
        Message expected = new Message(byArray);
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        values.put("i0", new Integer(1));
        MessageService result = segment.encodeValue((MessageService)message, values);
        byte[] expectedBytes = expected.getBytes();
        int i = 0;
        while (i < expectedBytes.length) {
            SegmentTestcase.assertEquals((byte)expectedBytes[i], (byte)result.getBytes()[i]);
            ++i;
        }
    }

    public void testEncodeSegmentSegment() {
        SimpleIntegerParameter parameter = new SimpleIntegerParameter("i0");
        IntegerParameter parameterTwo = new IntegerParameter("i1", 40, 32);
        MapParameter map = new MapParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        SimpleSegment segment = new SimpleSegment("Segment", new byte[1], null, (ParameterService)map);
        SimpleIntegerParameter parameter3 = new SimpleIntegerParameter("i2");
        MapParameter mapTop = new MapParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo, segment, parameter3});
        SimpleSegment segmentTop = new SimpleSegment("Segment", new byte[1], null, (ParameterService)mapTop);
        Message message = new Message(new byte[22]);
        byte[] byArray = new byte[22];
        byArray[3] = 1;
        byArray[8] = 2;
        byArray[12] = 1;
        byArray[17] = 2;
        byArray[21] = 3;
        Message expected = new Message(byArray);
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        values.put("i0", new Integer(1));
        values.put("i1", new Integer(2));
        Hashtable<String, Serializable> valuesTop = new Hashtable<String, Serializable>();
        valuesTop.put("i0", new Integer(1));
        valuesTop.put("i1", new Integer(2));
        valuesTop.put("Segment", values);
        valuesTop.put("i2", new Integer(3));
        MessageService result = segmentTop.encodeValue((MessageService)message, valuesTop);
        byte[] expectedBytes = expected.getBytes();
        int i = 0;
        while (i < expectedBytes.length) {
            SegmentTestcase.assertEquals((byte)expectedBytes[i], (byte)result.getBytes()[i]);
            ++i;
        }
    }

    public void testEncodeSegmentSize() {
        SegmentSizeBlock parameter = new SegmentSizeBlock(8);
        SimpleIntegerParameter parameterTwo = new SimpleIntegerParameter("i0");
        MapParameter map = new MapParameter(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        SimpleSegment segment = new SimpleSegment("Segment", new byte[1], null, (ParameterService)map);
        Message message = new Message(new byte[5]);
        byte[] byArray = new byte[5];
        byArray[0] = 5;
        byArray[4] = 1;
        Message expected = new Message(byArray);
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        values.put("i0", new Integer(1));
        MessageService result = segment.encodeValue((MessageService)message, values);
        byte[] expectedBytes = expected.getBytes();
        int i = 0;
        while (i < expectedBytes.length) {
            SegmentTestcase.assertEquals((byte)expectedBytes[i], (byte)result.getBytes()[i]);
            ++i;
        }
    }
}

