/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transform.testcase;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.transform.MaximumTransform;

public class MaximumTransformTestcase
extends TestCase {
    private MaximumTransform transform;
    private Object obj;

    public MaximumTransformTestcase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(MaximumTransformTestcase.class);
    }

    public void testDecodeForException() {
        this.transform = new MaximumTransform(0);
        this.obj = new Object();
        Exception ee = null;
        try {
            this.transform.decode(this.obj);
        }
        catch (Exception e) {
            ee = e;
        }
        MaximumTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        MaximumTransformTestcase.assertTrue((String)("Unknown Exception Thrown " + ee), (boolean)(ee instanceof ClassCastException));
    }

    public void testDecodeForGreaterInitialValue() {
        this.transform = new MaximumTransform(10);
        this.obj = this.transform.decode((Object)new Integer(5));
        MaximumTransformTestcase.assertTrue((String)"MaximumTransform 10 > 5", (10 == (Integer)this.obj ? 1 : 0) != 0);
    }

    public void testDecodeForLesserInitialValue() {
        this.transform = new MaximumTransform(5);
        this.obj = this.transform.decode((Object)new Integer(10));
        MaximumTransformTestcase.assertTrue((String)"MaximumTransform 10 > 5", (10 == (Integer)this.obj ? 1 : 0) != 0);
    }

    public void testDecodeForTrickyGreaterInitialValue1() {
        this.transform = new MaximumTransform(10);
        this.obj = this.transform.decode((Object)new Double(10.11111111));
        MaximumTransformTestcase.assertTrue((String)"MaximumTransform 10.11111111 > 10", (10.11111111 == (Double)this.obj ? 1 : 0) != 0);
    }

    public void testDecodeForTrickyGreaterInitialValue2() {
        this.transform = new MaximumTransform(9);
        this.obj = this.transform.decode((Object)new Double(8.9999999));
        MaximumTransformTestcase.assertTrue((String)"MaximumTransform 9 > 8.999999999", (9 == (Integer)this.obj ? 1 : 0) != 0);
    }

    public void testEncodeForException() {
        this.transform = new MaximumTransform(0);
        this.obj = new Object();
        Exception ee = null;
        try {
            this.transform.encode(this.obj);
        }
        catch (Exception e) {
            ee = e;
        }
        MaximumTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        MaximumTransformTestcase.assertTrue((String)("Unknown Exception Thrown " + ee), (boolean)(ee instanceof ClassCastException));
    }

    public void testEncodeForGreaterInitialValue() {
        this.transform = new MaximumTransform(10);
        this.obj = this.transform.encode((Object)new Integer(5));
        MaximumTransformTestcase.assertTrue((String)"MaximumTransform 10 > 5", (10 == (Integer)this.obj ? 1 : 0) != 0);
    }

    public void testEncodeForLesserInitialValue() {
        this.transform = new MaximumTransform(5);
        this.obj = this.transform.encode((Object)new Integer(10));
        MaximumTransformTestcase.assertTrue((String)"MaximumTransform 10 > 5", (10 == (Integer)this.obj ? 1 : 0) != 0);
    }

    public void testEncodeForTrickyGreaterInitialValue1() {
        this.transform = new MaximumTransform(10);
        this.obj = this.transform.encode((Object)new Double(10.11111111));
        MaximumTransformTestcase.assertTrue((String)"MaximumTransform 10.11111111 > 10 ", (10.11111111 == (Double)this.obj ? 1 : 0) != 0);
    }

    public void testEncodeForTrickyGreaterInitialValue2() {
        this.transform = new MaximumTransform(9);
        this.obj = this.transform.encode((Object)new Double(8.99999999));
        MaximumTransformTestcase.assertTrue((String)"MaximumTransform 9 > 8.999999999", (9 == (Integer)this.obj ? 1 : 0) != 0);
    }

    public void testTransformIntConstructor() {
        this.transform = new MaximumTransform(0);
        MaximumTransformTestcase.assertTrue((String)"MaximumTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
    }
}

