/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.block;

import org.eclipse.soda.dk.parameter.Block;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;

public class BytesBlock
extends Block {
    private byte[] bytes;
    private int length;

    public BytesBlock(String key) {
        super(key);
    }

    public BytesBlock() {
    }

    public BytesBlock(byte[] bytes) {
        this(bytes, bytes.length << 3);
    }

    public BytesBlock(byte[] bytes, int length) {
        this.setBytes(bytes);
        this.setLength(length);
    }

    public BytesBlock(String key, byte[] bytes, int length) {
        super(key);
        this.setBytes(bytes);
        this.setLength(length);
    }

    public BytesBlock(int length) {
        this(new byte[(length + 7) / 8], length);
    }

    public BytesBlock(String key, int length) {
        this(new byte[(length + 7) / 8], length);
    }

    public Object decodeBytes(byte[] container, ParameterCursorService cursor) {
        return null;
    }

    public byte[] encodeBytes(byte[] container, Object data, ParameterCursorService cursor) {
        int bytesLength = cursor != null ? cursor.getMessageLength() : container.length << 3;
        return BytesBlock.setBytes(container, bytesLength, this.getOffsetAbsolute(cursor), this.getLength(cursor), this.getBytes(), this.isInsert(cursor));
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.length;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

