/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.message;

import org.eclipse.soda.dk.filter.service.FilterService;
import org.eclipse.soda.dk.message.ParameterMessage;
import org.eclipse.soda.dk.message.TokenReceivedMessage;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.Parameters;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class TokenMessage
extends ParameterMessage {
    private int fieldCount;
    private int[] fieldInfo;
    private byte[] tokens;

    public TokenMessage(byte[] data, ParameterService parameter, String tokens) {
        this(null, null, parameter, tokens);
    }

    public TokenMessage(byte[] data, FilterService filter, ParameterService parameter, String tokens) {
        super(null, filter, parameter);
        this.tokens = tokens.getBytes();
        this.setBytes(data);
    }

    public boolean append(int data, int offset) {
        int tdata = data & 0xFF;
        this.getBytes()[offset] = (byte)tdata;
        int i = 0;
        while (i < this.tokens.length) {
            if (tdata == this.tokens[i]) {
                ++this.fieldCount;
                this.getFieldInfo()[this.fieldCount] = offset + 1;
                break;
            }
            ++i;
        }
        return data == 10;
    }

    public boolean append(byte[] bytes) {
        if (bytes != null) {
            return this.append(bytes, 0, bytes.length);
        }
        return false;
    }

    public boolean append(byte[] bytes, int offset, int len) {
        int i = 0;
        while (i < len) {
            this.append(bytes[offset + i], i);
            ++i;
        }
        ++this.fieldCount;
        this.getFieldInfo()[this.fieldCount] = len + 1;
        return false;
    }

    public Object decodeMessage(MessageService message) {
        TokenReceivedMessage me = new TokenReceivedMessage(message, this.getFilter(), this.getParameter(), new String(this.tokens));
        ParameterService myParameter = super.getParameter();
        if (myParameter != null) {
            return myParameter.decodeValue((MessageService)me);
        }
        return super.decodeMessage(me);
    }

    public Object decodeMessage(MessageService message, ParameterService parameter) {
        TokenReceivedMessage me = new TokenReceivedMessage(message, this.getFilter(), this.getParameter(), new String(this.tokens));
        if (parameter != null) {
            return parameter.decodeValue((MessageService)me);
        }
        return super.decodeMessage(me, parameter);
    }

    public Object get(Object fieldName) {
        return this.getComplexKey(fieldName);
    }

    public Object getComplexKey(Object fieldName) {
        String key = String.valueOf(fieldName);
        int index = key.indexOf(44);
        if (index >= 0) {
            Object[] objects = new Object[]{this.getComplexKey(key.substring(0, index)), this.getComplexKey(key.substring(index + 1))};
            return objects;
        }
        index = key.indexOf(43);
        if (index >= 0) {
            StringBuffer buffer = new StringBuffer(1024);
            Object object1 = this.getComplexKey(key.substring(0, index));
            Object object2 = this.getComplexKey(key.substring(index + 1));
            buffer.append(object1);
            buffer.append(object2);
            return buffer.toString();
        }
        return this.getSimple(fieldName);
    }

    public Object getData(int index) {
        if (index >= 0 && index < this.fieldCount) {
            return new String(this.getBytes(), this.fieldInfo[index], this.fieldInfo[index + 1] - this.fieldInfo[index] - 1);
        }
        return null;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public int[] getFieldInfo() {
        if (this.fieldInfo == null) {
            this.fieldInfo = new int[80];
        }
        return this.fieldInfo;
    }

    /*
     * Unable to fully structure code
     */
    public Object getSimple(Object fieldName) {
        block4: {
            try {
                return this.getData(Integer.parseInt((String)fieldName, 10));
            }
            catch (Exception v0) {
                if (!(this.getParameter() instanceof Parameters)) break block4;
                myParameter = (Parameters)this.getParameter();
                parameters = myParameter.getParameters();
                i = 0;
                ** while (i < parameters.length)
            }
lbl-1000:
            // 1 sources

            {
                parameterService = parameters[i];
                key = parameterService.getKey();
                if (key.equals(fieldName)) {
                    return parameterService.decodeValue((MessageService)this);
                }
                ++i;
                continue;
            }
        }
        return "";
    }

    public void put(Object key, Object value) {
        int index = Integer.parseInt((String)key, 10);
        byte[] ivalue = value instanceof String ? ((String)value).getBytes() : (value instanceof byte[] ? (byte[])value : value.toString().getBytes());
        byte[] mbytes = this.getBytes();
        if (index >= 0 && index < this.fieldCount) {
            int size = this.fieldInfo[index + 1] - this.fieldInfo[index] - 1;
            int toffset = this.fieldInfo[index];
            byte[] bytes = new byte[ivalue.length + mbytes.length - size];
            System.arraycopy(mbytes, 0, bytes, 0, toffset);
            System.arraycopy(ivalue, 0, bytes, toffset, ivalue.length);
            System.arraycopy(mbytes, toffset + size, bytes, toffset + ivalue.length, mbytes.length - (toffset + size));
            this.setBytes(bytes);
        } else {
            int tsize = index - this.fieldCount + 1;
            int toffset = mbytes.length;
            byte[] bytes = new byte[ivalue.length + mbytes.length + tsize];
            System.arraycopy(mbytes, 0, bytes, 0, toffset);
            int i = 0;
            while (i < tsize) {
                bytes[toffset + i] = this.tokens[0];
                ++i;
            }
            System.arraycopy(ivalue, 0, bytes, toffset + tsize, ivalue.length);
            this.setBytes(bytes);
        }
    }

    public void reset() {
        this.fieldCount = 0;
    }

    public void setBytes(byte[] bytes) {
        super.setBytes(bytes);
        this.reset();
        this.append(bytes);
    }

    public String toString() {
        byte[] bytes = this.getBytes();
        return new String(bytes);
    }
}

