/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.util.List;
import java.util.Vector;
import org.eclipse.soda.dk.block.CountBlock;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.MultiParameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class ListParameter
extends MultiParameter {
    public ListParameter(String key, ParameterService[] parameters) {
        super(key, parameters);
    }

    public ListParameter(ParameterService[] parameters) {
        super("", parameters);
    }

    public ListParameter() {
    }

    public ListParameter(String key) {
        super(key);
    }

    public ListParameter(String key, ParameterService[] parameters, ParameterService countBlock) {
        super(key, parameters, countBlock);
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor, int start, int count) {
        ParameterService[] parameters = this.getParameters();
        int length = parameters.length;
        Vector<Object> result = new Vector<Object>((length << 1) + 1);
        int index = 0;
        int j = 0;
        while (j < count) {
            int i = start;
            while (i < length) {
                ParameterService parameter = parameters[i];
                Object value = parameter.decodeValue(message, cursor);
                if (!parameter.isConstantParameter() && value != null) {
                    result.add(value);
                    ++index;
                }
                ++i;
            }
            ++j;
        }
        return result;
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor, int start, int count) {
        MessageService result = message;
        if (value instanceof List) {
            List list = (List)value;
            ParameterService[] parameters = this.getParameters();
            int i = 0;
            while (i < count) {
                ParameterService parameter = parameters[start];
                Object parameterValue = list.get(i);
                result = parameter.encodeValue(result, parameterValue, cursor);
                ++i;
            }
        }
        return result;
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        List list = EscConfiguration.listObject(value);
        if (list != null) {
            MessageService result = message;
            ParameterService[] parameters = this.getParameters();
            int length = parameters.length;
            int start = 0;
            int count = 0;
            switch (length) {
                case 0: {
                    break;
                }
                default: {
                    ParameterService first = parameters[0];
                    ParameterCursorService tcursor = cursor;
                    if (first instanceof CountBlock) {
                        tcursor = this.createCursorChild(cursor);
                        result = first.encodeValue(result, value, tcursor);
                        count = tcursor.getCount();
                        tcursor.setInsert(true);
                        start = 1;
                    }
                    if (start > 0) {
                        result = this.encodeValue(result, value, tcursor, start, count);
                        result = first.encodeValue(result, value, tcursor);
                    } else {
                        count = list.size();
                        if (count == length) {
                            return this.encodeValueList(result, list, tcursor);
                        }
                    }
                    cursor.setOffsetAbsolute(this.getOffsetAbsolute(tcursor));
                }
            }
            return result;
        }
        throw new IllegalArgumentException("key=" + this.getKey() + ",value not a list " + value);
    }

    public MessageService encodeValueList(MessageService message, List list, ParameterCursorService cursor) {
        MessageService result = message;
        ParameterService[] parameters = this.getParameters();
        int length = parameters.length;
        int i = 0;
        while (i < length) {
            ParameterService parameter = parameters[i];
            Object value = list.get(i);
            result = parameter.encodeValue(result, value, cursor);
            ++i;
        }
        return result;
    }
}

