/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.util.Hashtable;
import java.util.List;
import org.eclipse.soda.dk.block.CountBlock;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.parameter.BaseKeyParameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class MultiParameter
extends BaseKeyParameter {
    private ParameterService countBlock;
    private ParameterService[] parameters;

    public MultiParameter() {
    }

    public MultiParameter(String key) {
        super(key);
    }

    public MultiParameter(String key, ParameterService[] parameters) {
        super(key);
        this.setParameters(parameters);
    }

    public MultiParameter(String key, ParameterService[] parameters, ParameterService countBlock) {
        super(key);
        this.setParameters(parameters);
        this.setCountBlock(countBlock);
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor) {
        ParameterService[] parameters = this.getParameters();
        int length = parameters.length;
        int count = 1;
        int start = 0;
        Object result = null;
        switch (length) {
            case 0: {
                break;
            }
            default: {
                ParameterService first = parameters[0];
                if (first instanceof CountBlock) {
                    first.decodeValue(message, cursor);
                    count = cursor.getCount();
                    start = 1;
                }
                result = this.decodeValue(message, cursor, start, count);
            }
        }
        return result;
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor, int start, int count) {
        ParameterService[] parameters = this.getParameters();
        int length = parameters.length;
        Hashtable<Object, Object> result = new Hashtable<Object, Object>((length << 1) + 1);
        int index = 0;
        int j = 0;
        while (j < count) {
            int i = start;
            while (i < length) {
                ParameterService parameter = parameters[i];
                Object value = parameter.decodeValue(message, cursor);
                if (!parameter.isConstantParameter() && value != null) {
                    String key = parameter.getKey();
                    if (key != null) {
                        result.put(key, value);
                    }
                    result.put(EscObject.createInteger(index), value);
                    ++index;
                }
                ++i;
            }
            ++j;
        }
        return result;
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        ParameterService[] parameters = this.getParameters();
        int length = parameters.length;
        int start = 0;
        MessageService result = message;
        int count = 0;
        switch (length) {
            case 0: {
                break;
            }
            default: {
                ParameterService first = parameters[0];
                ParameterCursorService tcursor = cursor;
                if (first instanceof CountBlock) {
                    tcursor = this.createCursorChild(cursor);
                    result = first.encodeValue(result, value, tcursor);
                    count = tcursor.getCount();
                    tcursor.setInsert(true);
                    start = 1;
                }
                if (start > 0) {
                    result = this.encodeValue(result, value, tcursor, start, count);
                    result = first.encodeValue(result, value, tcursor);
                } else {
                    List list;
                    List list2 = list = value instanceof List ? (List)value : null;
                    if (list != null && (count = list.size()) == length) {
                        return this.encodeValueList(result, list, tcursor);
                    }
                }
                cursor.setOffsetAbsolute(this.getOffsetAbsolute(tcursor));
            }
        }
        return result;
    }

    public MessageService encodeValue(MessageService result, Object value, ParameterCursorService cursor, int start, int count) {
        return result;
    }

    public MessageService encodeValueList(MessageService result, List value, ParameterCursorService cursor) {
        return result;
    }

    public ParameterService getCountBlock() {
        return this.countBlock;
    }

    public ParameterService[] getParameters() {
        return this.parameters;
    }

    public boolean needsCursor() {
        return true;
    }

    public void setCountBlock(ParameterService countBlock) {
        this.countBlock = countBlock;
    }

    public void setParameters(ParameterService[] parameters) {
        this.parameters = parameters;
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                if (parameters[i] == null) {
                    throw new IllegalArgumentException(String.valueOf(Nls.formatData(this.getKey())) + ',' + Nls.formatData(parameters));
                }
                ++i;
            }
        }
    }
}

