/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.util.List;
import java.util.Vector;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.MapParameters;
import org.eclipse.soda.dk.parameter.ParameterCursor;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class VariableListParameters
extends MapParameters
implements ParameterService {
    public VariableListParameters(String key, ParameterService[] parameters, int offset) {
        super(key, parameters, offset);
    }

    public VariableListParameters(String key, ParameterService[] parameters) {
        super(key, parameters);
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor) {
        ParameterCursorService tcursor = cursor != null ? cursor : new ParameterCursor(message.getBytes().length << 3);
        int offset = this.getOffset();
        if (offset >= 0) {
            tcursor.setOffset(offset);
        }
        int length = this.parameters.length;
        Vector<Object> result = new Vector<Object>(length);
        while (this.more(message, cursor)) {
            int index = 0;
            while (index < length) {
                if (this.more(message, cursor)) {
                    ParameterService parameter = this.parameters[index];
                    Object parameterResult = parameter.decodeValue(message, tcursor);
                    if (!parameter.isConstantParameter()) {
                        result.add(parameterResult);
                    }
                }
                ++index;
            }
        }
        return result;
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        ParameterCursorService tcursor = cursor != null ? cursor : new ParameterCursor(message.getBytes().length << 3);
        int offset = this.getOffset();
        if (offset >= 0) {
            tcursor.setOffset(offset);
        }
        MessageService resultMessage = message;
        if (value instanceof List) {
            List values = (List)value;
            int listLength = values.size();
            int length = this.parameters.length;
            int count = Math.max(listLength, length);
            int paramterCount = 0;
            int index = 0;
            while (index < length) {
                if (!this.parameters[index % length].isConstantParameter()) {
                    ++paramterCount;
                }
                ++index;
            }
            int pindex = 0;
            int index2 = 0;
            while (count > 0) {
                ParameterService parameter = this.parameters[index2 % length];
                if (parameter.isConstantParameter()) {
                    resultMessage = parameter.encodeValue(resultMessage, null, tcursor);
                } else {
                    resultMessage = parameter.encodeValue(resultMessage, values.get(pindex), tcursor);
                    ++pindex;
                    --count;
                }
                ++index2;
            }
        }
        return resultMessage;
    }

    public boolean more(MessageService message, ParameterCursorService cursor) {
        int end;
        int offset = cursor.getOffset();
        return offset < (end = message.getDataOffset() + message.getDataLength());
    }
}

