/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.segment;

import java.util.List;
import java.util.Vector;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.filter.service.FilterService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.service.LengthBlockService;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.segment.OptionalSegment;

public class MultiSegment
extends OptionalSegment {
    private int occursMinimum = 0;
    private int occursMaximum = Integer.MAX_VALUE;

    public MultiSegment() {
    }

    public MultiSegment(String key) {
        super(key);
    }

    public MultiSegment(byte[] bytes, FilterService filter, ParameterService parameter) {
        super(bytes, filter, parameter);
    }

    public MultiSegment(byte[] bytes, FilterService filter, ParameterService parameter, int occursMinimum, int occursMaximum) {
        super(bytes, filter, parameter);
        this.setOccursMinimum(occursMinimum);
        this.setOccursMaximum(occursMaximum);
    }

    public MultiSegment(String key, byte[] bytes, FilterService filter, ParameterService parameter, int occursMinimum, int occursMaximum) {
        super(key, bytes, filter, parameter);
        this.setOccursMinimum(occursMinimum);
        this.setOccursMaximum(occursMaximum);
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor) {
        Vector<Object> list = new Vector<Object>();
        ParameterService parameter = this.getParameter();
        int count = 0;
        while (this.checkMatches(message, cursor)) {
            ParameterCursorService tcursor = this.createCursorChild(cursor);
            Object result = parameter.decodeValue(message, tcursor);
            if (result != null) {
                list.add(result);
                ++count;
            }
            int newOffset = this.getOffsetAbsolute(tcursor);
            cursor.setOffsetAbsolute(newOffset);
        }
        if (count < this.getOccursMinimum()) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(this.getKey())) + ',' + String.valueOf(message));
        }
        if (count > this.getOccursMaximum()) {
            throw new IllegalArgumentException(String.valueOf(message));
        }
        return list;
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        ParameterService parameter = this.getParameter();
        MessageService results = message;
        if (value == null) {
            if (this.getOccursMinimum() > 0) {
                throw new IllegalArgumentException("key=" + this.getKey() + ",value not a list " + value);
            }
            return message;
        }
        List list = EscConfiguration.listObject(value);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                ParameterCursorService tcursor = this.createCursorChild(cursor);
                Object element = list.get(i);
                results = parameter.encodeValue(results, element, tcursor);
                LengthBlockService lengthService = tcursor.getLengthBlock();
                if (lengthService != null) {
                    int end = tcursor.getOffsetAbsolute();
                    int start = cursor.getOffsetAbsolute();
                    tcursor.setLength(end - start);
                    results = lengthService.encodeValue(results, value, tcursor);
                }
                cursor.setOffsetAbsolute(this.getOffsetAbsolute(tcursor));
                ++i;
            }
        } else if (this.getOccursMinimum() > 0) {
            throw new IllegalArgumentException("key=" + this.getKey() + ",value not a list " + value);
        }
        return results;
    }

    public int getOccursMaximum() {
        return this.occursMaximum;
    }

    public int getOccursMinimum() {
        return this.occursMinimum;
    }

    public void setOccursMaximum(int occursMaximum) {
        this.occursMaximum = occursMaximum;
    }

    public void setOccursMinimum(int occursMinimum) {
        this.occursMinimum = occursMinimum;
    }
}

