/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.device.servlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.device.servlet.DeviceDeviceServletContext;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.device.servlet.DeviceServlet;
import org.eclipse.soda.dk.device.servlet.DeviceServletContext;
import org.eclipse.soda.dk.device.servlet.service.DeviceServletService;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.signal.service.SignalService;

public class DeviceDeviceServlet
extends DeviceServlet
implements DeviceServletService,
Servlet {
    private static final long serialVersionUID = 3261854308887373271L;
    private DeviceService device;

    public static String formatData(Object data, boolean form) {
        StringBuffer buffer = new StringBuffer(1024);
        DeviceDeviceServlet.formatData(buffer, data, form);
        return buffer.toString();
    }

    public static void formatData(StringBuffer buffer, Object data, boolean form) {
        if (data instanceof Object[]) {
            buffer.append("[]{");
            int i = 0;
            while (i < ((Object[])data).length) {
                if (i != 0) {
                    buffer.append(' ');
                }
                DeviceDeviceServlet.formatData(buffer, ((Object[])data)[i], form);
                ++i;
            }
            buffer.append('}');
        } else if (data instanceof byte[]) {
            buffer.append('[');
            int i = 0;
            while (i < ((byte[])data).length) {
                int dataByte;
                int upperByte;
                if (i != 0) {
                    buffer.append(' ');
                }
                if ((upperByte = (dataByte = ((byte[])data)[i] & 0xFF) >> 4) > 0) {
                    buffer.append(Nls.HEX_CHAR_LOWER_TABLE[upperByte]);
                }
                buffer.append(Nls.HEX_CHAR_LOWER_TABLE[dataByte & 0xF]);
                ++i;
            }
            buffer.append(']');
        } else if (data instanceof Map) {
            buffer.append("<dl compact=\"compact\">");
            Map map = (Map)data;
            int size = map.size();
            if (size > 0) {
                Set set = map.keySet();
                Object[] keys = new Object[size];
                keys = set.toArray(keys);
                Arrays.sort(keys, new Comparator(){

                    public int compare(Object var0, Object var1) {
                        return String.valueOf(var0).compareTo(String.valueOf(var1));
                    }
                });
                int i = 0;
                while (i < size) {
                    buffer.append("<dt>");
                    buffer.append(keys[i]);
                    buffer.append("</dt>");
                    buffer.append("<dd><b>");
                    DeviceDeviceServlet.formatData(buffer, map.get(keys[i]), form);
                    buffer.append("</b></dd>");
                    ++i;
                }
            }
            buffer.append("</dl>");
        } else if (data instanceof Dictionary) {
            buffer.append('{');
            boolean first = true;
            Dictionary map = (Dictionary)data;
            int size = map.size();
            if (size > 0) {
                Enumeration enumeration = map.keys();
                while (enumeration.hasMoreElements()) {
                    String key = String.valueOf(enumeration.nextElement());
                    if (!first) {
                        buffer.append(',');
                    } else {
                        first = false;
                    }
                    DeviceDeviceServlet.formatData(buffer, key, form);
                    buffer.append('=');
                    DeviceDeviceServlet.formatData(buffer, map.get(key), form);
                }
            }
            buffer.append('}');
        } else if (data == null) {
            buffer.append("<i>null</i>");
        } else {
            buffer.append("<b>");
            buffer.append(data);
            buffer.append("</b>");
        }
    }

    public DeviceServletContext createContext(HttpServletRequest request, HttpServletResponse response) {
        DeviceDeviceServletContext context = new DeviceDeviceServletContext(request, response, this.getServletAlias());
        return context;
    }

    public DeviceService getDevice() {
        return this.device;
    }

    public void processCommand(DeviceServletContext context, CommandService command, boolean edit) {
        context.addEntity("Name", (Object)command.getKey());
        if (edit) {
            context.template("commandedit");
        } else {
            context.template("commandentry");
        }
    }

    public void processCommandPage(DeviceServletContext context, CommandService command, String operation) {
        context.template("commandbegin");
        this.processCommand(context, command, true);
        context.template("commandend");
    }

    public void processDevice(DeviceDeviceServletContext context, DeviceService device) {
        int signalsSize;
        int measurementsSize;
        ArrayList measurementList = new ArrayList(101);
        ArrayList commandList = new ArrayList(101);
        ArrayList signalList = new ArrayList(101);
        context.addEntity("Name", device.getKey());
        context.addEntity("DeviceName", device.getKey());
        context.template("devicebegin");
        context.println("<table>");
        context.println("<tr>");
        Enumeration enumeration = device.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof MeasurementService) {
                measurementList.add(object);
            }
            if (object instanceof CommandService) {
                commandList.add(object);
            }
            if (!(object instanceof SignalService)) continue;
            signalList.add(object);
        }
        int commandsSize = commandList.size();
        if (commandsSize > 0) {
            context.println("<td valign=\"top\" align=\"left\">");
            CommandService[] commands = new CommandService[commandsSize];
            commands = commandList.toArray(commands);
            context.sort((ControlService[])commands);
            context.template("commandbegin");
            int i = 0;
            while (i < commandsSize) {
                CommandService command = commands[i];
                this.processCommand(context, command, false);
                ++i;
            }
            context.template("commandend");
            context.println("</td>");
        }
        if ((measurementsSize = measurementList.size()) > 0) {
            context.println("<td valign=\"top\" align=\"left\">");
            MeasurementService[] measurements = new MeasurementService[measurementsSize];
            measurements = measurementList.toArray(measurements);
            context.sort((ControlService[])measurements);
            context.template("measurementbegin");
            int i = 0;
            while (i < measurementsSize) {
                MeasurementService measurement = measurements[i];
                this.processMeasurement(context, measurement, false);
                ++i;
            }
            context.template("measurementend");
            context.println("</td>");
        }
        if ((signalsSize = signalList.size()) > 0) {
            context.println("<td valign=\"top\" align=\"left\">");
            SignalService[] signals = new SignalService[signalsSize];
            signals = signalList.toArray(signals);
            context.sort((ControlService[])signals);
            context.template("signalbegin");
            int i = 0;
            while (i < signalsSize) {
                SignalService signal = signals[i];
                this.processSignal(context, signal, false);
                ++i;
            }
            context.template("signalend");
            context.println("</td>");
        }
        context.println("</tr>");
        context.println("</table>");
        context.template("deviceend");
    }

    public void processDeviceRegistry(DeviceDeviceServletContext context) {
        try {
            DeviceService device = this.getDevice();
            if (device != null) {
                ArrayList<Object> deviceList = new ArrayList<Object>(101);
                Enumeration enumeration = device.elements();
                deviceList.add(device);
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement();
                    if (!(object instanceof DeviceService)) continue;
                    deviceList.add(object);
                }
                int devicesSize = deviceList.size();
                if (devicesSize > 0) {
                    DeviceService[] devices = new DeviceService[devicesSize];
                    devices = deviceList.toArray(devices);
                    context.sort((ControlService[])devices);
                    int i = 0;
                    while (i < devicesSize) {
                        DeviceService childDevice = devices[i];
                        if (context.filter(childDevice.getKey())) {
                            this.processDevice(context, childDevice);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processFileRequest(DeviceServletContext context) {
        String filePath = context.getFilePath();
        if (filePath.length() > 0 && filePath.endsWith(".gif")) {
            super.processFileRequest(context);
        } else {
            context.begin();
            this.processRequest(context);
            context.end();
        }
    }

    public void processMeasurement(DeviceServletContext context, MeasurementService measurement, boolean edit) {
        context.addEntity("Name", (Object)measurement.getKey());
        Object value = measurement.getValue();
        if (value instanceof String) {
            context.addEntity("AlignValue", (Object)"center");
        } else if (value instanceof Number) {
            context.addEntity("AlignValue", (Object)"right");
        } else {
            context.addEntity("AlignValue", (Object)"left");
        }
        context.addEntity("HelpValue", (Object)Nls.formatData((Object)value));
        context.addEntity("Value", (Object)DeviceDeviceServlet.formatData(value, false));
        String timestamp = Nls.formatTimestamp((Object)measurement.getTimestamp());
        context.addEntity("Timestamp", (Object)timestamp);
        context.addEntity("HelpTimestamp", (Object)timestamp);
        if (edit) {
            context.template("measurementedit");
        } else {
            context.template("measuremententry");
        }
    }

    public void processMeasurementPage(DeviceServletContext context, MeasurementService measurement, String operation) {
        context.template("measurementbegin");
        this.processMeasurement(context, measurement, true);
        context.template("measurementend");
    }

    public void processRequest(DeviceServletContext context) {
        String queryString = context.getRequest().getQueryString();
        String simpleFilePath = context.getSimpleFilePath();
        context.addEntity("DeviceName", (Object)this.getDevice().getKey());
        if (simpleFilePath.length() > 0) {
            ControlService value = this.getDevice().get(simpleFilePath);
            if (value instanceof MeasurementService) {
                this.processMeasurementPage(context, (MeasurementService)value, queryString);
                return;
            }
            if (value instanceof CommandService) {
                this.processCommandPage(context, (CommandService)value, queryString);
                return;
            }
            if (value instanceof SignalService) {
                this.processSignalPage(context, (SignalService)value, queryString);
                return;
            }
        }
        this.processDeviceRegistry((DeviceDeviceServletContext)context);
    }

    public void processSignal(DeviceServletContext context, SignalService signal, boolean edit) {
        context.addEntity("Name", (Object)signal.getKey());
        if (edit) {
            context.template("signaledit");
        } else {
            context.template("signalentry");
        }
    }

    public void processSignalPage(DeviceServletContext context, SignalService signal, String operation) {
        context.template("signalbegin");
        this.processSignal(context, signal, true);
        context.template("signalend");
    }

    public void setDevice(DeviceService device) {
        this.device = device;
    }
}

