/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.nslog.servlet;

public class NSBuffer {
    protected Object[][] elements;
    private int head = 0;
    int length;
    private int size = 0;
    private int tail = 0;

    public NSBuffer() {
        this(10);
    }

    public NSBuffer(int size) {
        this.elements = new Object[size][2];
        this.length = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] dequeue() {
        NSBuffer nSBuffer = this;
        synchronized (nSBuffer) {
            if (this.size > 0) {
                Object[] info = new Object[]{this.elements[this.head][0], this.elements[this.head][1]};
                this.elements[this.head][0] = null;
                this.elements[this.head][1] = null;
                this.head = (this.head + 1) % this.length;
                --this.size;
                return info;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object topic, Object data) {
        try {
            NSBuffer nSBuffer = this;
            synchronized (nSBuffer) {
                if (this.size == 0) {
                    this.head = 0;
                    this.tail = 1 % this.length;
                    this.elements[this.head][0] = topic;
                    this.elements[this.head][1] = data;
                } else {
                    this.elements[this.tail][0] = topic;
                    this.elements[this.tail][1] = data;
                    this.tail = (this.tail + 1) % this.length;
                }
                if (this.size == this.elements.length) {
                    this.head = (this.head + 1) % this.length;
                } else {
                    ++this.size;
                }
                this.notify();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(this.toString());
        }
    }

    public int getMaxSize() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] getOrderedBuffer() {
        NSBuffer nSBuffer = this;
        synchronized (nSBuffer) {
            if (this.size > 0) {
                Object[][] info = new Object[this.size][2];
                int size = this.size;
                int pos = this.head;
                int i = 0;
                while (i < size) {
                    info[i][0] = this.elements[pos][0];
                    info[i][1] = this.elements[pos][1];
                    pos = (pos + 1) % this.length;
                    ++i;
                }
                return info;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int newsize) {
        NSBuffer nSBuffer = this;
        synchronized (nSBuffer) {
            Object[][] temp = new Object[newsize][2];
            if (newsize > this.size) {
                int pos = this.head;
                int i = 0;
                while (i < this.size) {
                    temp[i][0] = this.elements[pos][0];
                    temp[i][1] = this.elements[pos][1];
                    pos = (pos + 1) % this.length;
                    ++i;
                }
                this.elements = temp;
                this.head = 0;
                this.tail = this.size;
                this.length = newsize;
            } else if (newsize < this.size) {
                int pos = this.tail;
                int i = newsize - 1;
                while (i > -1) {
                    if (--pos < 0) {
                        pos = this.size - 1;
                    }
                    temp[i][0] = this.elements[pos][0];
                    temp[i][1] = this.elements[pos][1];
                    --i;
                }
                this.elements = temp;
                this.head = 0;
                this.tail = 0;
                this.length = newsize;
                this.size = newsize;
            } else if (newsize != this.length) {
                int pos = this.head;
                int i = 0;
                while (i < this.size) {
                    temp[i][0] = this.elements[pos][0];
                    temp[i][1] = this.elements[pos][1];
                    pos = (pos + 1) % this.length;
                    ++i;
                }
                this.elements = temp;
                this.head = 0;
                this.tail = 0;
                this.length = newsize;
            }
        }
    }

    public int size() {
        return this.size;
    }
}

