/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.dk.device.servlet.DeviceServletContext;
import org.eclipse.soda.dk.device.servlet.service.DeviceServletService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.service.metatype.AttributeDefinition;

public class DeviceServlet
extends HttpServlet
implements DeviceServletService {
    private static final long serialVersionUID = -6542228019143217803L;
    private String servletAlias = null;
    private String resourceAlias = null;
    private String resourcePath = null;
    private HttpService server = null;
    private BundleContext bundleContext = null;

    public static String escape(String str) {
        int count = str.length();
        int offset = 0;
        StringBuffer s = new StringBuffer(count * 2);
        while (offset < count) {
            DeviceServlet.escape(s, str.charAt(offset++));
        }
        return s.toString();
    }

    public static void escape(StringBuffer s, char c) {
        switch (c) {
            case '<': {
                s.append("&lt;");
                break;
            }
            case '>': {
                s.append("&gt;");
                break;
            }
            case '&': {
                s.append("&amp;");
                break;
            }
            case '\'': {
                s.append("&apos;");
                break;
            }
            case '\"': {
                s.append("&quot;");
                break;
            }
            default: {
                s.append(c);
            }
        }
    }

    public void buildMenu(DeviceServletContext context) {
        ServiceReference[] serviceReferences = this.getServiceReferences();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < serviceReferences.length) {
            ServiceReference serviceReference = serviceReferences[i];
            Object servletalias = serviceReference.getProperty("servletalias");
            if (servletalias != null) {
                String alias = String.valueOf(servletalias);
                list.add(alias);
            }
            ++i;
        }
        int length = list.size();
        String[] names = new String[length];
        names = list.toArray(names);
        context.sort(names);
        StringBuffer buffer = new StringBuffer(length * 32);
        int i2 = 0;
        while (i2 < length) {
            if (i2 > 0) {
                buffer.append("&nbsp;");
            }
            String name = names[i2];
            buffer.append("<a href=\"");
            buffer.append(name);
            buffer.append("\" target=\"_top\">");
            int index = name.indexOf(47, 1);
            String nicename = name.replace('/', ' ');
            nicename = index > 0 ? nicename.substring(index).trim() : "home";
            buffer.append(nicename);
            buffer.append("</a>");
            ++i2;
        }
        context.addEntity("Menu", buffer.toString());
    }

    public DeviceServletContext createContext(HttpServletRequest request, HttpServletResponse response) {
        DeviceServletContext context = new DeviceServletContext(request, response, this.getServletAlias());
        return context;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            DeviceServletContext context = this.createContext(request, response);
            this.setup(context);
            String filePath = context.getFilePath();
            if (filePath.length() > 0) {
                this.processFileRequest(context);
            } else {
                context.begin();
                this.processRequest(context);
                context.end();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DeviceServletContext context = this.createContext(request, response);
        this.setup(context);
        context.begin();
        this.processRequest(context);
        context.end();
    }

    public AttributeDefinition findAttribute(Object key, AttributeDefinition[] attributeDefinitions) {
        int i = 0;
        while (i < attributeDefinitions.length) {
            if (key.equals(attributeDefinitions[i].getID())) {
                return attributeDefinitions[i];
            }
            ++i;
        }
        return null;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Bundle[] getBundles() {
        return this.getBundleContext().getBundles();
    }

    public String getResouceAliasDefault() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(this.getServletAlias());
        buffer.append("/resource");
        return buffer.toString();
    }

    public String getResoucePathDefault() {
        String name = this.getClass().getName();
        int index = name.lastIndexOf(46);
        String packageName = name.substring(0, index);
        StringBuffer buffer = new StringBuffer(128);
        buffer.append('/');
        buffer.append(packageName.replace('.', '/'));
        buffer.append("/resource");
        return buffer.toString();
    }

    public String getResourceAlias() {
        if (this.resourceAlias == null) {
            this.resourceAlias = this.getResouceAliasDefault();
        }
        return this.resourceAlias;
    }

    public String getResourcePath() {
        if (this.resourcePath == null) {
            this.resourcePath = this.getResoucePathDefault();
        }
        return this.resourcePath;
    }

    public HttpService getServer() {
        return this.server;
    }

    public ServiceReference[] getServiceReferences() {
        ArrayList<ServiceReference> list = new ArrayList<ServiceReference>(128);
        Bundle[] bundles = this.getBundles();
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            ServiceReference[] bserviceReferences = bundle.getRegisteredServices();
            if (bserviceReferences != null) {
                int j = 0;
                while (j < bserviceReferences.length) {
                    list.add(bserviceReferences[j]);
                    ++j;
                }
            }
            ++i;
        }
        ServiceReference[] serviceReferences = new ServiceReference[list.size()];
        serviceReferences = list.toArray(serviceReferences);
        return serviceReferences;
    }

    public String getServletAlias() {
        if (this.servletAlias == null) {
            this.servletAlias = this.getServletAliasDefault();
        }
        return this.servletAlias;
    }

    public String getServletAliasDefault() {
        int index;
        StringBuffer buffer = new StringBuffer(128);
        String name = this.getClass().getName();
        String simpleName = name.substring((index = name.lastIndexOf(46)) + 1);
        if (simpleName.endsWith("Servlet")) {
            simpleName = simpleName.substring(0, simpleName.length() - 7);
        }
        char[] characters = simpleName.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            if (Character.isUpperCase(character)) {
                buffer.append('/');
                buffer.append(Character.toLowerCase(character));
            } else {
                buffer.append(character);
            }
            ++i;
        }
        return buffer.toString();
    }

    public void processFileRequest(DeviceServletContext context) {
        this.processRequest(context);
    }

    public void processOverview(DeviceServletContext context) {
        ServiceReference[] serviceReferences = this.getServiceReferences();
        context.sort(serviceReferences);
        context.template("overviewbegin");
        int i = 0;
        while (i < serviceReferences.length) {
            ServiceReference serviceReference = serviceReferences[i];
            Object servletalias = serviceReference.getProperty("servletalias");
            if (servletalias != null) {
                String alias = String.valueOf(servletalias);
                context.addEntity("Alias", alias);
                context.addEntity("Key", alias);
                context.template("overviewentry");
            }
            ++i;
        }
        context.template("overviewend");
    }

    public void processRequest(DeviceServletContext context) {
        this.processOverview(context);
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setResourceAlias(String resourceAlias) {
        this.resourceAlias = resourceAlias;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setServer(HttpService server) {
        if (this.server != null) {
            try {
                this.server.unregister(this.getServletAlias());
                this.server.unregister(this.getResourceAlias());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (server != null) {
            try {
                server.registerServlet(this.getServletAlias(), (Servlet)this, null, null);
                server.registerResources(this.getResourceAlias(), this.getResourcePath(), null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.server = server;
    }

    public void setServletAlias(String servletAlias) {
        this.servletAlias = servletAlias;
    }

    public void setup(DeviceServletContext context) {
        context.setBundleContext(this.getBundleContext());
        this.buildMenu(context);
    }
}

