/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;

public class TemplateInputStream
extends InputStream {
    private ArrayList stack;
    private ByteArrayOutputStream buffer;
    private Hashtable variables = new Hashtable();
    private Hashtable entities = new Hashtable();
    int depth = 0;
    boolean commentLine = false;
    boolean entityRef = false;
    private int logic = 0;

    public TemplateInputStream() {
        this.stack = new ArrayList();
        this.buffer = new ByteArrayOutputStream();
        this.initializeVariables();
    }

    public TemplateInputStream(InputStream inputStream) {
        this.stack = new ArrayList();
        this.buffer = new ByteArrayOutputStream();
        this.push(inputStream);
        this.initializeVariables();
    }

    public void addEntity(String key, String value) {
        this.getEntities().put(key, value);
    }

    public void addVariable(String key, String value) {
        this.getVariables().put(key, value);
    }

    public boolean expr(String variableName) {
        if ("true".equals(variableName) || "1".equals(variableName)) {
            return true;
        }
        if ("false".equals(variableName) || "0".equals(variableName)) {
            return false;
        }
        String value = this.getVariable(variableName);
        return "true".equals(value) || "1".equals(value);
    }

    public InputStream getBlankStream() {
        return new ByteArrayInputStream("".getBytes());
    }

    public InputStream getEchoVar(String variableName) {
        String value = this.getVariable(variableName);
        if (value != null) {
            return new ByteArrayInputStream(value.getBytes());
        }
        return null;
    }

    public Hashtable getEntities() {
        return this.entities;
    }

    public String getEntity(String key) {
        Object value = this.getEntities().get(key);
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    public InputStream getIncludeFile(String value) {
        return null;
    }

    public InputStream getIncludeVirtual(String value) {
        return null;
    }

    public InputStream getInputStream() {
        return (InputStream)this.getStack().get(this.getStack().size() - 1);
    }

    public ArrayList getStack() {
        return this.stack;
    }

    public InputStream getStream(String commentLine) {
        int equalIndex;
        int index;
        if (commentLine.startsWith("<--#") & commentLine.endsWith("-->") && (index = commentLine.indexOf(32)) != -1 && (equalIndex = commentLine.indexOf(61, index)) != -1) {
            int n = commentLine.indexOf(34, equalIndex + 1);
        }
        return null;
    }

    public String getVariable(String key) {
        return (String)this.getVariables().get(key);
    }

    public Hashtable getVariables() {
        return this.variables;
    }

    public void initializeVariables() {
        Date date = new Date();
        this.addVariable("DATE_LOCAL", date.toString());
        String year = Integer.toString(Calendar.getInstance().get(1));
        this.addEntity("Year", year);
    }

    public InputStream pop() {
        this.getStack().remove(this.getStack().size() - 1);
        return this.getInputStream();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream processComment(String comment) {
        String key;
        int index;
        if (comment.startsWith("<!--#") & comment.endsWith("-->")) {
            int endTagIndex;
            int index2 = comment.indexOf(32);
            if (index2 == -1) {
                index2 = comment.indexOf(45, 4);
            }
            if (index2 == -1) return null;
            String command = comment.substring(5, index2);
            int equalIndex = comment.indexOf(61, index2);
            if (equalIndex == -1) return this.processSsiCommand(command, "", "");
            String tag = comment.substring(index2, equalIndex).trim();
            int startTagIndex = comment.indexOf(34, equalIndex + 1);
            if (startTagIndex == -1 || (endTagIndex = comment.lastIndexOf(34)) == -1) return null;
            String value = comment.substring(startTagIndex + 1, endTagIndex);
            return this.processSsiCommand(command, tag, value);
        }
        if (!(comment.startsWith("<!ENTITY % ") & comment.endsWith(">")) || (index = (key = comment.substring("<!ENTITY % ".length(), comment.length() - 1).trim()).indexOf(32)) <= 0) return null;
        String value = key.substring(index).trim();
        key = key.substring(0, index).trim();
        if (value.startsWith("'")) {
            int lastq = value.lastIndexOf(39);
            value = value.substring(1, lastq);
        } else {
            if (!value.startsWith("\"")) return null;
            int lastq = value.lastIndexOf(34);
            value = value.substring(1, lastq);
        }
        this.addEntity(key, value);
        return this.getBlankStream();
    }

    public InputStream processElse(String variableName) {
        this.buffer.reset();
        if (this.logic == 2) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            while (this.logic == 2) {
                try {
                    int data = this.read();
                    if (data == -1) break;
                    output.write(data);
                }
                catch (Exception exception) {
                    break;
                }
            }
            return new ByteArrayInputStream(output.toByteArray());
        }
        this.logic = 2;
        while (this.logic == 2) {
            try {
                int data = this.read();
                if (data != -1) continue;
            }
            catch (Exception exception) {}
            break;
        }
        return this.getBlankStream();
    }

    public InputStream processEndif(String variableName) {
        if (this.logic > 0) {
            this.logic = 0;
        }
        return this.getBlankStream();
    }

    public InputStream processEntityReference(String comment) {
        String key = comment.substring(1, comment.length() - 1);
        String value = this.getEntity(key);
        if (value != null) {
            return new ByteArrayInputStream(value.getBytes());
        }
        return null;
    }

    public InputStream processIf(String variableName) {
        boolean expr = this.expr(variableName);
        this.buffer.reset();
        if (expr) {
            this.logic = 1;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            while (this.logic == 1) {
                try {
                    int data = this.read();
                    if (data == -1) break;
                    output.write(data);
                }
                catch (Exception exception) {
                    break;
                }
            }
            return new ByteArrayInputStream(output.toByteArray());
        }
        this.logic = 2;
        while (this.logic == 2) {
            try {
                int data = this.read();
                if (data != -1) continue;
            }
            catch (Exception exception) {}
            break;
        }
        return this.getBlankStream();
    }

    public InputStream processSsiCommand(String command, String tag, String value) {
        if ("include".equals(command)) {
            if ("virtual".equals(tag)) {
                return this.getIncludeVirtual(value);
            }
            if ("file".equals(tag)) {
                return this.getIncludeFile(value);
            }
        } else if ("echo".equals(command)) {
            if ("var".equals(tag)) {
                return this.getEchoVar(value);
            }
        } else if ("set".equals(command)) {
            if ("var".equals(tag)) {
                return this.setEchoVar(value);
            }
        } else {
            return this.processSsiLogicCommand(command, tag, value);
        }
        return null;
    }

    public InputStream processSsiLogicCommand(String command, String tag, String value) {
        if ("if".equals(command)) {
            if ("expr".equals(tag)) {
                return this.processIf(value);
            }
        } else {
            if ("else".equals(command)) {
                return this.processElse(value);
            }
            if ("endif".equals(command)) {
                return this.processEndif(value);
            }
        }
        return null;
    }

    public void push(InputStream inputStream) {
        this.getStack().add(inputStream);
    }

    public int read() throws IOException {
        int data = this.getInputStream().read();
        if (data == -1) {
            if (this.getStack().size() == 1) {
                return data;
            }
            this.pop();
            return this.read();
        }
        if (this.buffer.size() == 0) {
            if (data == 60) {
                this.commentLine = true;
                this.entityRef = false;
                this.buffer.write(data);
                return this.read();
            }
            if (this.getStack().size() <= 2 && (data == 37 || data == 38)) {
                this.commentLine = false;
                this.entityRef = true;
                this.buffer.write(data);
                return this.read();
            }
        } else {
            this.buffer.write(data);
            if (data == 62 && this.commentLine) {
                String comment = this.buffer.toString();
                InputStream newInputStream = this.processComment(comment);
                if (newInputStream != null) {
                    this.push(newInputStream);
                    this.buffer.reset();
                    return this.read();
                }
                this.push(new ByteArrayInputStream(this.buffer.toByteArray()));
                this.buffer.reset();
                return this.getInputStream().read();
            }
            if (this.entityRef) {
                if (data == 59) {
                    this.entityRef = false;
                    String comment = this.buffer.toString();
                    InputStream newInputStream = this.processEntityReference(comment);
                    if (newInputStream != null) {
                        this.push(newInputStream);
                        this.buffer.reset();
                        return this.read();
                    }
                    this.push(new ByteArrayInputStream(this.buffer.toByteArray()));
                    this.buffer.reset();
                    return this.getInputStream().read();
                }
                if (data == 45 || Character.isLetter((char)data) || Character.isDigit((char)data)) {
                    return this.read();
                }
                this.entityRef = false;
                this.push(new ByteArrayInputStream(this.buffer.toByteArray()));
                this.buffer.reset();
                return this.getInputStream().read();
            }
            return this.read();
        }
        return data;
    }

    public InputStream setEchoVar(String variableName) {
        int index = variableName.indexOf(34, 1);
        if (index > -1) {
            String value = "";
            String key = variableName.substring(0, index);
            int eqi = variableName.indexOf(61);
            if (eqi > -1) {
                value = variableName.substring(eqi + 2);
                this.addVariable(key, value);
                return this.getBlankStream();
            }
        }
        return null;
    }

    public void setEntities(Hashtable entities) {
        this.entities = entities;
    }

    public void setVariables(Hashtable variables) {
        this.variables = variables;
    }
}

