/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.soda.dk.command.Command;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.Control;
import org.eclipse.soda.dk.device.Device;
import org.eclipse.soda.dk.device.DeviceRegistry;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceListener;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.device.swt.Bridge;
import org.eclipse.soda.dk.device.swt.CommandBridge;
import org.eclipse.soda.dk.device.swt.MeasurementBridge;
import org.eclipse.soda.dk.device.swt.SignalBridge;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.notification.Notification;
import org.eclipse.soda.dk.notification.client.NotificationClient;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.signal.Signal;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DeviceSwt
extends NotificationClient
implements Runnable,
SelectionListener,
MenuListener,
DeviceListener {
    public static final String ID_VALUE = "T1";
    public static final String PREFIX_VALUE = "T1";
    public static final int COMMAND_TYPE = 0;
    public static final int MEASUREMENT_TYPE = 1;
    public static final int SIGNAL_TYPE = 2;
    protected Bridge[] bridges;
    protected long timestamp = System.currentTimeMillis();
    protected int keyIndex = 0;
    protected int timestampIndex = -1;
    protected int timeIndex = -1;
    protected int countIndex = 1;
    protected int dataIndex = 2;
    protected DeviceService device;
    protected TransportService transport;
    protected Table tableSignal;
    protected Table tableCommand;
    protected Table tableMeasurement;
    protected Display display;
    protected Shell shell;
    protected Thread thread;
    protected Menu signalPopupMenu;
    protected Menu commandPopupMenu;
    protected Menu measurementPopupMenu;
    private boolean active = false;
    protected Color activeColor;
    protected Color littleActiveColor;
    protected Color inactiveColor;
    protected Font normalFont;
    protected Font boldFont;
    protected Font italicFont;
    protected String fontName = null;
    protected int fontHeight = 0;
    protected Image commandImage;
    protected Image measurementImage;
    protected Image signalImage;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        DeviceSwt swt = new DeviceSwt();
        swt.run(args);
    }

    public void controlChanged(DeviceService device, Object timestamp, ControlService control, int code) {
    }

    public void createShell() {
        final Display display = new Display();
        this.setDisplay(display);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.device.swt.DeviceSwt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Image commandImage = new Image((org.eclipse.swt.graphics.Device)display, clazz.getResourceAsStream("command.gif"));
        this.setCommandImage(commandImage);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.soda.dk.device.swt.DeviceSwt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Image measurementImage = new Image((org.eclipse.swt.graphics.Device)display, clazz2.getResourceAsStream("measurement.gif"));
        this.setMeasurementImage(measurementImage);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.soda.dk.device.swt.DeviceSwt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Image signalImage = new Image((org.eclipse.swt.graphics.Device)display, clazz3.getResourceAsStream("signal.gif"));
        this.setSignalImage(signalImage);
        this.setActiveColor(display.getSystemColor(13));
        this.setInactiveColor(display.getSystemColor(15));
        this.setLittleActiveColor(display.getSystemColor(1));
        Shell shell = new Shell(display);
        this.setShell(shell);
        String title = this.getTitle();
        shell.setText(title);
        Menu menubar = new Menu((Decorations)shell, 2);
        shell.setMenuBar(menubar);
        MenuItem cascade = new MenuItem(menubar, 64);
        cascade.setText("sub");
        Menu subMenu = new Menu(cascade);
        MenuItem select = new MenuItem(subMenu, 8);
        select.setText("select");
        new MenuItem(subMenu, 2);
        cascade.setMenu(subMenu);
        menubar.addMenuListener((MenuListener)this);
        Shell composite = shell;
        GridLayout layout = new GridLayout(6, false);
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        GridData data = new GridData();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        this.setupCommand((Composite)composite);
        this.setupMeasurement((Composite)composite);
        this.setupSignal((Composite)composite);
        Text text = new Text((Composite)composite, 2816);
        GridData dataText = new GridData(4, 4, true, false, 6, 1);
        dataText.minimumHeight = 200;
        dataText.minimumWidth = 100;
        dataText.grabExcessVerticalSpace = true;
        text.setLayoutData((Object)dataText);
        composite.layout(true);
        shell.layout(true);
        shell.open();
        display.timerExec(1000, new Runnable(){

            public void run() {
                DeviceSwt.this.refresh();
                display.timerExec(1000, (Runnable)this);
            }
        });
    }

    public Table createTable(Composite parent, int type) {
        Table table = new Table(parent, 2818);
        this.setupFonts(table);
        GridData data = new GridData(4, 4, true, true, 2, 1);
        data.minimumHeight = 100;
        data.minimumWidth = 100;
        table.setLayoutData((Object)data);
        table.addSelectionListener((SelectionListener)this);
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setResizable(true);
        nameColumn.setWidth(200);
        switch (type) {
            case 0: {
                nameColumn.setText("Command key");
                nameColumn.setToolTipText("Command key column");
                nameColumn.setImage(this.getCommandImage());
                nameColumn.pack();
                break;
            }
            case 1: {
                nameColumn.setText("Measurement key");
                nameColumn.setToolTipText("Measurement key column");
                nameColumn.setImage(this.getMeasurementImage());
                nameColumn.pack();
                break;
            }
            case 2: {
                nameColumn.setText("Signal key");
                nameColumn.setToolTipText("Signal key column");
                nameColumn.setImage(this.getSignalImage());
                nameColumn.pack();
            }
        }
        if (this.getTimestampIndex() >= 0) {
            TableColumn timestampColumn = new TableColumn(table, 0);
            timestampColumn.setText("Timestamp");
            timestampColumn.setToolTipText("timestamp column");
            timestampColumn.setWidth(100);
            timestampColumn.setAlignment(131072);
            timestampColumn.setResizable(true);
            timestampColumn.setMoveable(true);
        }
        if (this.getCountIndex() >= 0) {
            TableColumn countColumn = new TableColumn(table, 0);
            countColumn.setText("Count");
            countColumn.setToolTipText("Count column");
            countColumn.setAlignment(131072);
            countColumn.setResizable(true);
            countColumn.setMoveable(true);
            countColumn.pack();
        }
        if (this.getDataIndex() >= 0) {
            TableColumn dataColumn = new TableColumn(table, 0);
            dataColumn.setText("Data");
            dataColumn.setToolTipText("Data column");
            dataColumn.setWidth(200);
            dataColumn.setResizable(true);
            dataColumn.setMoveable(true);
        }
        table.setVisible(true);
        table.setHeaderVisible(true);
        return table;
    }

    public void deviceChanged(DeviceService source, Object timestamp, int newState, int oldState) {
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
    }

    public Color getActiveColor() {
        return this.activeColor;
    }

    public Font getBoldFont() {
        return this.boldFont;
    }

    public Bridge[] getBridges() {
        return this.bridges;
    }

    public Image getCommandImage() {
        return this.commandImage;
    }

    public Menu getCommandPopupMenu() {
        return this.commandPopupMenu;
    }

    public int getCountIndex() {
        return this.countIndex;
    }

    public int getDataIndex() {
        return this.dataIndex;
    }

    public DeviceService getDefaultDevice() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        DeviceRegistry device = new DeviceRegistry();
        Command command = new Command("command");
        device.put("command", (ControlService)command);
        Signal signal = new Signal("signal");
        device.put("signal", (ControlService)signal);
        Signal signal2 = new Signal("signal2");
        device.put("signal2", (ControlService)signal2);
        return device;
    }

    public NotificationService getDefaultNotificationService() {
        return Notification.getBroker();
    }

    public DeviceService getDevice() {
        return this.device;
    }

    public Display getDisplay() {
        return this.display;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public String getFontName() {
        return this.fontName;
    }

    public Color getInactiveColor() {
        return this.inactiveColor;
    }

    public Font getItalicFont() {
        return this.italicFont;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public Color getLittleActiveColor() {
        return this.littleActiveColor;
    }

    public Image getMeasurementImage() {
        return this.measurementImage;
    }

    public Menu getMeasurementPopupMenu() {
        return this.measurementPopupMenu;
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public Shell getShell() {
        return this.shell;
    }

    public Image getSignalImage() {
        return this.signalImage;
    }

    public Menu getSignalPopupMenu() {
        return this.signalPopupMenu;
    }

    public Table getTableCommand() {
        return this.tableCommand;
    }

    public Table getTableMeasurement() {
        return this.tableMeasurement;
    }

    public Table getTableSignal() {
        return this.tableSignal;
    }

    public Thread getThread() {
        return this.thread;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getTimestampIndex() {
        return this.timestampIndex;
    }

    public String getTitle() {
        if (this.device != null) {
            if (this.device instanceof Control) {
                String title = ((Control)this.device).getQualifiedKey();
                return title;
            }
            String title = this.device.getKey();
            return title;
        }
        return "Device SWT";
    }

    public TransportService getTransport() {
        return this.transport;
    }

    public boolean isActive() {
        return this.active;
    }

    public void menuHidden(MenuEvent e) {
    }

    public void menuShown(MenuEvent e) {
    }

    protected void openControlWindow(Bridge bridge) {
        bridge.openWindow();
    }

    public void populateTables() {
        int count;
        Enumeration enumeration = this.device.elements();
        ArrayList<String> list = new ArrayList<String>();
        int signalCount = 0;
        int measurementCount = 0;
        int commandCount = 0;
        while (enumeration.hasMoreElements()) {
            Object item = enumeration.nextElement();
            if (!(item instanceof ControlService)) continue;
            ControlService control = (ControlService)item;
            String key = control.getKey();
            if (item instanceof CommandService) {
                list.add(key);
                ++commandCount;
                continue;
            }
            if (item instanceof MeasurementService) {
                list.add(key);
                ++measurementCount;
                continue;
            }
            if (!(item instanceof SignalService)) continue;
            list.add(key);
            ++signalCount;
        }
        Object[] keys = new String[list.size()];
        keys = list.toArray(keys);
        Arrays.sort(keys);
        ArrayList<Bridge> bridgeList = new ArrayList<Bridge>();
        int i = 0;
        while (i < keys.length) {
            TableItem tableItem;
            Object key = keys[i];
            ControlService item = this.device.get((String)key);
            if (item instanceof CommandService) {
                CommandService command = (CommandService)item;
                tableItem = new TableItem(this.getTableCommand(), 16384);
                CommandBridge commandBridge = new CommandBridge(this, tableItem, command);
                commandBridge.updateTable();
                bridgeList.add(commandBridge);
                tableItem.setData((Object)commandBridge);
            } else if (item instanceof MeasurementService) {
                MeasurementService measurement = (MeasurementService)item;
                tableItem = new TableItem(this.getTableMeasurement(), 16384);
                MeasurementBridge measurementBridge = new MeasurementBridge(this, tableItem, measurement);
                measurementBridge.updateTable();
                bridgeList.add(measurementBridge);
                tableItem.setData((Object)measurementBridge);
            } else if (item instanceof SignalService) {
                SignalService signal = (SignalService)item;
                tableItem = new TableItem(this.getTableSignal(), 16384);
                SignalBridge signalBridge = new SignalBridge(this, tableItem, signal);
                signalBridge.updateTable();
                bridgeList.add(signalBridge);
                tableItem.setData((Object)signalBridge);
            }
            ++i;
        }
        if (commandCount < 1) {
            this.tableCommand.dispose();
        } else {
            count = this.tableCommand.getColumnCount();
            int i2 = 0;
            while (i2 < count - 1) {
                this.tableCommand.getColumn(i2).pack();
                ++i2;
            }
        }
        if (measurementCount < 1) {
            this.tableMeasurement.dispose();
        } else {
            this.tableMeasurement.getColumn(0).pack();
            count = this.tableMeasurement.getColumnCount();
            int i3 = 0;
            while (i3 < count - 1) {
                this.tableMeasurement.getColumn(i3).pack();
                ++i3;
            }
        }
        if (signalCount < 1) {
            this.tableSignal.dispose();
        } else {
            this.tableSignal.getColumn(0).pack();
            count = this.tableSignal.getColumnCount();
            int i4 = 0;
            while (i4 < count - 1) {
                this.tableSignal.getColumn(i4).pack();
                ++i4;
            }
        }
        Bridge[] bridges = new Bridge[bridgeList.size()];
        bridges = bridgeList.toArray(bridges);
        this.setBridges(bridges);
        this.getShell().pack();
    }

    public void refresh() {
        if (this.bridges != null) {
            int i = 0;
            while (i < this.bridges.length) {
                this.bridges[i].refresh();
                ++i;
            }
        }
    }

    public void run() {
        while (!this.shell.isDisposed() && this.isActive()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.shell.dispose();
    }

    public void run(String[] args) {
        try {
            System.gc();
            System.gc();
            NotificationService notificationService = this.getDefaultNotificationService();
            this.setNotificationService(notificationService);
            this.register("*");
            DeviceService deviceService = this.getDefaultDevice();
            if (deviceService != null) {
                Hashtable<String, String> configurationInformation = new Hashtable<String, String>();
                deviceService.setNotificationService(notificationService);
                configurationInformation.put("id", "T1");
                configurationInformation.put("prefix", "T1");
                deviceService.setConfigurationInformation(configurationInformation);
                this.setDevice(deviceService);
                this.start();
                if (deviceService instanceof Device) {
                    Device device = (Device)deviceService;
                    device.setup();
                    TransportService transportService = deviceService.getTransport();
                    if (transportService != null) {
                        transportService.setConfigurationInformation(configurationInformation);
                        transportService.setNotificationService(notificationService);
                    }
                    deviceService.start();
                } else {
                    deviceService.start();
                    TransportService transportService = deviceService.getTransport();
                    if (transportService != null) {
                        transportService.setConfigurationInformation(configurationInformation);
                        transportService.setNotificationService(notificationService);
                    }
                }
            }
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
        this.setActive(true);
        this.run();
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setActiveColor(Color activeColor) {
        this.activeColor = activeColor;
    }

    public void setBoldFont(Font boldFont) {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        this.boldFont = boldFont;
    }

    public void setBridges(Bridge[] bridges) {
        this.bridges = bridges;
    }

    public void setCommandImage(Image commandImage) {
        this.commandImage = commandImage;
    }

    public void setCommandPopupMenu(Menu commandPopupMenu) {
        this.commandPopupMenu = commandPopupMenu;
    }

    public void setCountIndex(int countIndex) {
        this.countIndex = countIndex;
    }

    public void setDataIndex(int dataIndex) {
        this.dataIndex = dataIndex;
    }

    public void setDevice(DeviceService device) {
        if (this.device != null) {
            this.device.removeDeviceListener((DeviceListener)this);
        }
        this.device = device;
        if (this.device != null) {
            if (this.getShell() != null) {
                String title = this.getTitle();
                this.getShell().setText(title);
            }
            this.device.addDeviceListener((DeviceListener)this);
        }
        if (this.getShell() != null) {
            this.populateTables();
        }
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public void setFontHeight(int fontHeight) {
        this.fontHeight = fontHeight;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setInactiveColor(Color inactiveColor) {
        this.inactiveColor = inactiveColor;
    }

    public void setItalicFont(Font italicFont) {
        this.italicFont = italicFont;
    }

    public void setKeyIndex(int keyIndex) {
        this.keyIndex = keyIndex;
    }

    public void setLittleActiveColor(Color littleActiveColor) {
        this.littleActiveColor = littleActiveColor;
    }

    public void setMeasurementImage(Image measurementImage) {
        this.measurementImage = measurementImage;
    }

    public void setMeasurementPopupMenu(Menu measurementPopupMenu) {
        this.measurementPopupMenu = measurementPopupMenu;
    }

    public void setNormalFont(Font normalFont) {
        if (this.normalFont != null) {
            this.normalFont.dispose();
        }
        this.normalFont = normalFont;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public void setSignalImage(Image signalImage) {
        this.signalImage = signalImage;
    }

    public void setSignalPopupMenu(Menu signalPopupMenu) {
        this.signalPopupMenu = signalPopupMenu;
    }

    public void setTableCommand(Table tableCommand) {
        this.tableCommand = tableCommand;
    }

    public void setTableMeasurement(Table tableMeasurement) {
        this.tableMeasurement = tableMeasurement;
    }

    public void setTableSignal(Table tableSignal) {
        this.tableSignal = tableSignal;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setTimestampIndex(int timestampIndex) {
        this.timestampIndex = timestampIndex;
    }

    public void setTransport(TransportService transport) {
        this.transport = transport;
    }

    public void setupCommand(Composite composite) {
        Table table = this.createTable(composite, 0);
        this.commandPopupMenu = new Menu((org.eclipse.swt.widgets.Control)table);
        MenuItem trigger = new MenuItem(this.commandPopupMenu, 8);
        trigger.setText("Execute");
        trigger.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = DeviceSwt.this.tableCommand.getSelection();
                int i = 0;
                while (i < items.length) {
                    Object data = items[i].getData();
                    if (data instanceof CommandBridge) {
                        CommandBridge commandBridge = (CommandBridge)data;
                        commandBridge.getCommand().execute();
                    }
                    ++i;
                }
            }
        });
        this.commandPopupMenu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                int selectionCount = DeviceSwt.this.getTableCommand().getSelectionCount();
                MenuItem[] items = DeviceSwt.this.getCommandPopupMenu().getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].setEnabled(selectionCount > 0);
                    ++i;
                }
            }
        });
        table.setMenu(this.commandPopupMenu);
        table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem[] items = DeviceSwt.this.tableCommand.getSelection();
                int i = 0;
                while (i < items.length) {
                    Object itemData = items[i].getData();
                    if (itemData instanceof Bridge) {
                        Bridge bridge = (Bridge)itemData;
                        DeviceSwt.this.openControlWindow(bridge);
                    }
                    ++i;
                }
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.setTableCommand(table);
    }

    public void setupFonts(Table table) {
        if (this.getFontHeight() <= 0) {
            FontData[] fontData;
            Font baselineFont = table.getFont();
            if (baselineFont == null) {
                baselineFont = this.getShell().getFont();
            }
            if (baselineFont == null) {
                baselineFont = this.getDisplay().getSystemFont();
            }
            if (baselineFont != null && (fontData = baselineFont.getFontData()) != null && fontData.length > 0) {
                String fontName = fontData[0].getName();
                this.setFontName(fontName);
                int fontHeight = fontData[0].getHeight();
                this.setFontHeight(fontHeight);
                System.out.println("font name " + fontName);
                Font normalFont = new Font((org.eclipse.swt.graphics.Device)this.getDisplay(), fontName, fontHeight, 0);
                this.setNormalFont(normalFont);
                Font boldFont = new Font((org.eclipse.swt.graphics.Device)this.getDisplay(), fontName, fontHeight, 1);
                this.setBoldFont(boldFont);
                Font italicFont = new Font((org.eclipse.swt.graphics.Device)this.getDisplay(), fontName, fontHeight, 2);
                this.setItalicFont(italicFont);
            }
        }
    }

    public void setupMeasurement(Composite composite) {
        Table table = this.createTable(composite, 1);
        this.measurementPopupMenu = new Menu((org.eclipse.swt.widgets.Control)table);
        MenuItem trigger = new MenuItem(this.measurementPopupMenu, 8);
        trigger.setText("Execute read");
        trigger.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = DeviceSwt.this.tableMeasurement.getSelection();
                int i = 0;
                while (i < items.length) {
                    Object data = items[i].getData();
                    if (data instanceof MeasurementBridge) {
                        MeasurementBridge measurementBridge = (MeasurementBridge)data;
                        measurementBridge.getMeasurement().executeRead();
                    }
                    ++i;
                }
            }
        });
        this.measurementPopupMenu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                int selectionCount = DeviceSwt.this.getTableMeasurement().getSelectionCount();
                MenuItem[] items = DeviceSwt.this.getMeasurementPopupMenu().getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].setEnabled(selectionCount > 0);
                    ++i;
                }
            }
        });
        table.setMenu(this.measurementPopupMenu);
        table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem[] items = DeviceSwt.this.tableMeasurement.getSelection();
                int i = 0;
                while (i < items.length) {
                    Object itemData = items[i].getData();
                    if (itemData instanceof Bridge) {
                        Bridge bridge = (Bridge)itemData;
                        DeviceSwt.this.openControlWindow(bridge);
                    }
                    ++i;
                }
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.setTableMeasurement(table);
    }

    public void setupSignal(Composite composite) {
        Table table = this.createTable(composite, 2);
        this.signalPopupMenu = new Menu((org.eclipse.swt.widgets.Control)table);
        MenuItem trigger = new MenuItem(this.signalPopupMenu, 8);
        trigger.setText("Trigger");
        trigger.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = DeviceSwt.this.tableSignal.getSelection();
                int i = 0;
                while (i < items.length) {
                    Object data = items[i].getData();
                    if (data instanceof SignalBridge) {
                        SignalBridge signalBridge = (SignalBridge)data;
                        signalBridge.getSignal().trigger();
                    }
                    ++i;
                }
            }
        });
        MenuItem triggerData = new MenuItem(this.signalPopupMenu, 8);
        triggerData.setText("Trigger data");
        triggerData.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = DeviceSwt.this.tableSignal.getSelection();
                int i = 0;
                while (i < items.length) {
                    Object itemData = items[i].getData();
                    if (itemData instanceof SignalBridge) {
                        SignalBridge signalBridge = (SignalBridge)itemData;
                        DeviceSwt.this.openControlWindow(signalBridge);
                    }
                    ++i;
                }
            }
        });
        this.signalPopupMenu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                int selectionCount = DeviceSwt.this.getTableSignal().getSelectionCount();
                MenuItem[] items = DeviceSwt.this.getSignalPopupMenu().getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].setEnabled(selectionCount > 0);
                    ++i;
                }
            }
        });
        table.setMenu(this.signalPopupMenu);
        table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem[] items = DeviceSwt.this.tableSignal.getSelection();
                int i = 0;
                while (i < items.length) {
                    Object itemData = items[i].getData();
                    if (itemData instanceof SignalBridge) {
                        SignalBridge signalBridge = (SignalBridge)itemData;
                        DeviceSwt.this.openControlWindow(signalBridge);
                    }
                    ++i;
                }
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.setTableSignal(table);
    }

    public void start() {
        this.createShell();
        if (this.getDevice() != null) {
            this.populateTables();
        }
    }

    public void startThread() {
        this.setActive(true);
        Thread thread = new Thread(this);
        this.setThread(thread);
        thread.start();
    }

    public void stop() {
        this.setActive(false);
        Thread thread = this.getThread();
        if (thread != null) {
            try {
                thread.interrupt();
                thread.join(2000L);
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            this.setThread(null);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }
}

