/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.testcase;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.MessageHandler;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceListener;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.device.testcase.DeviceTestcaseResourceBundle;
import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.local.transport.LocalTransport;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.message.Messages;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.service.TransportService;

public abstract class DeviceTestcase
extends TestCase
implements DeviceListener,
CommandListener,
MeasurementListener,
SignalListener {
    public static final String CLASS_NAME;
    protected static final int MESSAGE_KEY_NOT_NUMBER_RESOURCE = 3900;
    private static ResourceBundle DefaultResourceBundle;
    protected DeviceService device;
    protected TransportService transport;
    protected MessageService messageReceived;
    protected MessageService responseMessage = null;
    protected SignalService signalReceived = null;
    protected Object signalReceivedData = null;
    protected CommandService commandReceived = null;
    protected Object commandReceivedData = null;
    protected final Object commandWait = new Object();
    protected MeasurementService measurementReceived = null;
    protected Object measurementReceivedData = null;
    protected final Object measurementWait = new Object();
    protected final Object stateWait = new Object();
    protected final Object messageReceivedWait = new Object();
    protected final Object signalWait = new Object();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.device.testcase.DeviceTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.soda.dk.device.testcase.DeviceTestcaseResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz2);
    }

    protected DeviceTestcase() {
    }

    protected DeviceTestcase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandExecuted(CommandService source, Object timestamp, Object data) {
        this.commandReceived = source;
        this.commandReceivedData = data;
        Object object = this.commandWait;
        synchronized (object) {
            this.commandWait.notifyAll();
        }
    }

    public void controlChanged(DeviceService device, Object timestamp, ControlService control, int code) {
    }

    public abstract DeviceService createDevice();

    public TransportService createTransport() {
        return new LocalTransport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceChanged(DeviceService source, Object timestamp, int newState, int oldState) {
        Object object = this.stateWait;
        synchronized (object) {
            this.stateWait.notifyAll();
        }
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
    }

    public CommandService getCommandReceived() {
        return this.commandReceived;
    }

    public Object getCommandReceivedData() {
        return this.commandReceivedData;
    }

    public Object getCommandWait() {
        return this.commandWait;
    }

    public DeviceService getDevice() {
        return this.device;
    }

    public MeasurementService getMeasurementReceived() {
        return this.measurementReceived;
    }

    public Object getMeasurementReceivedData() {
        return this.measurementReceivedData;
    }

    public Object getMeasurementWait() {
        return this.measurementWait;
    }

    public Object getMessageKey(MessageService message) {
        DeviceService deviceService = this.getDevice();
        try {
            Class<?> clazz = deviceService.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.soda.dk.message.service.MessageService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method messageKeyMethod = clazz.getMethod("getMessageKey", classArray);
            Object key = messageKeyMethod.invoke((Object)deviceService, message);
            return key;
        }
        catch (Exception e) {
            DeviceTestcase.fail((String)String.valueOf(e));
            return null;
        }
    }

    public MessageService getMessageReceived() {
        return this.messageReceived;
    }

    public Object getMessageReceivedWait() {
        return this.messageReceivedWait;
    }

    public String getResource(int resourceId) {
        try {
            return DefaultResourceBundle.getString(DeviceTestcaseResourceBundle.getKey(resourceId));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public MessageService getResponseMessage() {
        return this.responseMessage;
    }

    public SignalService getSignalReceived() {
        return this.signalReceived;
    }

    public Object getSignalReceivedData() {
        return this.signalReceivedData;
    }

    public Object getSignalWait() {
        return this.signalWait;
    }

    public Object getStateWait() {
        return this.stateWait;
    }

    public TransportService getTransport() {
        return this.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.measurementReceived = source;
        this.measurementReceivedData = newValue;
        Object object = this.measurementWait;
        synchronized (object) {
            this.measurementWait.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        if (this.responseMessage != null) {
            if (this.responseMessage == message) {
                this.responseMessage = null;
                Object object = this.messageReceivedWait;
                synchronized (object) {
                    this.messageReceivedWait.notify();
                }
                return;
            }
            this.messageReceived = message;
            this.transport.send(this.responseMessage);
            return;
        }
        Object object = this.messageReceivedWait;
        synchronized (object) {
            this.messageReceived = message;
            this.messageReceivedWait.notifyAll();
        }
    }

    public void printTable(Hashtable table, int messageCapacity) {
        Hashtable hashKeys = new Hashtable();
        Iterator iterator = table.entrySet().iterator();
        int count = 0;
        int total = 0;
        int multipleKeys = 0;
        while (iterator.hasNext()) {
            ++count;
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            int hashKey = (key.hashCode() & Integer.MAX_VALUE) % messageCapacity;
            Integer hashKeyObject = new Integer(hashKey);
            Vector counter = (Vector)hashKeys.get(hashKeyObject);
            if (counter == null) {
                counter = new Vector();
                counter.addElement(key);
                hashKeys.put(hashKeyObject, counter);
            } else {
                counter.addElement(key);
                ++multipleKeys;
            }
            Vector list = (Vector)value;
            StringBuffer buffer = new StringBuffer(128);
            buffer.append('\t');
            buffer.append(key);
            buffer.append('\t');
            int size = list.size();
            total += size;
            buffer.append(size);
            buffer.append('\t');
            buffer.append(value);
            System.out.println(buffer.toString());
        }
        StringBuffer tbuffer = new StringBuffer(128);
        tbuffer.append('\t');
        tbuffer.append(count);
        tbuffer.append('\t');
        tbuffer.append(total);
        tbuffer.append('\t');
        tbuffer.append(messageCapacity);
        tbuffer.append('\t');
        tbuffer.append(multipleKeys);
        System.out.println(tbuffer.toString());
        Iterator miterator = hashKeys.entrySet().iterator();
        while (miterator.hasNext()) {
            ++count;
            Map.Entry entry = miterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            Vector list = (Vector)value;
            StringBuffer buffer = new StringBuffer(128);
            buffer.append('\t');
            buffer.append(key);
            buffer.append('\t');
            int size = list.size();
            total += size;
            buffer.append(size);
            buffer.append('\t');
            buffer.append(value);
            System.out.println(buffer.toString());
        }
    }

    public int registerMessageHandler(MessageService message, Dictionary messageHandlers) {
        int count = 0;
        if (message instanceof Messages) {
            MessageService[] messages = ((Messages)message).getMessages();
            int j = 0;
            while (j < messages.length) {
                count += this.registerMessageHandler(messages[j], messageHandlers);
                ++j;
            }
        } else {
            Object key = this.getMessageKey(message);
            if (key != null) {
                Vector<MessageService> counter = (Vector<MessageService>)messageHandlers.get(key);
                if (counter == null) {
                    counter = new Vector<MessageService>();
                    counter.addElement(message);
                    messageHandlers.put(key, counter);
                } else {
                    counter.addElement(message);
                }
                ++count;
            } else {
                DeviceTestcase.fail((String)String.valueOf(message));
            }
        }
        return count;
    }

    public void setCommandReceived(CommandService commandReceived) {
        this.commandReceived = commandReceived;
    }

    public void setCommandReceivedData(Object commandReceivedData) {
        this.commandReceivedData = commandReceivedData;
    }

    public void setDevice(DeviceService device) {
        this.device = device;
    }

    public void setMeasurementReceived(MeasurementService measurementReceived) {
        this.measurementReceived = measurementReceived;
    }

    public void setMeasurementReceivedData(Object measurementReceivedData) {
        this.measurementReceivedData = measurementReceivedData;
    }

    public void setMessageReceived(MessageService messageReceived) {
        this.messageReceived = messageReceived;
    }

    public void setResponseMessage(MessageService responseMessage) {
        this.responseMessage = responseMessage;
    }

    public void setSignalReceived(SignalService signalReceived) {
        this.signalReceived = signalReceived;
    }

    public void setSignalReceivedData(Object signalReceivedData) {
        this.signalReceivedData = signalReceivedData;
    }

    public void setTransport(TransportService transport) {
        this.transport = transport;
    }

    protected void setUp() throws Exception {
        this.setTransport(this.createTransport());
        this.setDevice(this.createDevice());
        this.device.setTransport(this.transport);
        this.startDevice();
        Thread.sleep(15000L);
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        this.signalReceived = source;
        this.signalReceivedData = data;
        Object object = this.signalWait;
        synchronized (object) {
            this.signalWait.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDevice() throws Exception {
        this.device.addDeviceListener((DeviceListener)this);
        this.transport.start();
        this.device.start();
        while (this.transport.getState() != 5) {
            Object object = this.stateWait;
            synchronized (object) {
                this.stateWait.wait(500L);
            }
        }
    }

    protected void tearDown() throws Exception {
        if (this.device != null) {
            this.device.exit();
            this.device = null;
        }
        if (this.transport != null) {
            this.transport.exit();
            this.transport = null;
        }
        super.tearDown();
    }

    public void test_Fields() {
        DeviceService deviceService = this.getDevice();
        try {
            Field field = deviceService.getClass().getField("CLASS_NAME");
            Object value = field.get(null);
            DeviceTestcase.assertEquals((Object)deviceService.getClass().getName(), (Object)value);
        }
        catch (Exception e) {
            DeviceTestcase.fail((String)String.valueOf(e));
        }
    }

    public void test_InterestMask() {
        DeviceService deviceService = this.getDevice();
        Object value = null;
        int count = 0;
        try {
            Method interestMethod = deviceService.getClass().getMethod("getInterest", new Class[0]);
            value = interestMethod.invoke((Object)deviceService, new Object[0]);
            InterestMask interestMask = (InterestMask)value;
            Enumeration enumeration = deviceService.elements();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (!(object instanceof MessageHandler)) continue;
                MessageHandler messageHandler = (MessageHandler)object;
                MessageService message = messageHandler.getMessage();
                DeviceTestcase.assertTrue((String)message.toString(), (boolean)interestMask.isInterested(message));
                ++count;
            }
        }
        catch (Exception e) {
            DeviceTestcase.fail((String)String.valueOf(e));
        }
        DeviceTestcase.assertEquals((boolean)true, (boolean)(value instanceof InterestMask));
    }

    public void test_Interfaces() {
        DeviceService deviceService = this.getDevice();
        Object value = null;
        Class<?>[] interfaces = deviceService.getClass().getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            try {
                Class<?> interfaceClass = interfaces[i];
                Field field = interfaceClass.getField("SERVICE_NAME");
                value = field.get(null);
                DeviceTestcase.assertEquals((Object)interfaceClass.getName(), (Object)value);
            }
            catch (Exception e) {
                DeviceTestcase.fail((String)String.valueOf(e));
            }
            ++i;
        }
    }

    public void test_MessageKey() {
        DeviceService deviceService = this.getDevice();
        try {
            int messageCapacity = 101;
            Method interestMethod = deviceService.getClass().getMethod("getMessageCapacity", new Class[0]);
            Object value = interestMethod.invoke((Object)deviceService, new Object[0]);
            if (value instanceof Number) {
                messageCapacity = ((Number)value).intValue();
            }
            Hashtable messageHandlers = new Hashtable(messageCapacity);
            Enumeration enumeration = deviceService.elements();
            int count = 0;
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (!(object instanceof MessageHandler)) continue;
                MessageHandler messageHandler = (MessageHandler)object;
                MessageService message = messageHandler.getMessage();
                count += this.registerMessageHandler(message, messageHandlers);
            }
            this.printTable(messageHandlers, messageCapacity);
        }
        catch (Exception e) {
            DeviceTestcase.fail((String)String.valueOf(e));
        }
    }
}

