/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device;

import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.Container;
import org.eclipse.soda.dk.device.DeviceListeners;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceControl;
import org.eclipse.soda.dk.device.service.DeviceListener;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.transport.ResponseTransport;
import org.eclipse.soda.dk.transport.service.TransportService;

public class Device
extends Container
implements DeviceService,
Runnable {
    public static final String START_COMMAND_NAME = "start";
    public static final String STOP_COMMAND_NAME = "stop";
    public static final String POLL_COMMAND_NAME = "poll";
    protected static final int STARTED_MASK = 65536;
    private DeviceListener deviceListener;
    private long readTimeout = 4000L;
    private Thread thread;
    private boolean isRunning = false;

    public Device() {
        this.setState(1);
        this.initialize();
    }

    public void addDeviceListener(DeviceListener deviceListener) {
        if (deviceListener != null) {
            int state = this.getState();
            deviceListener.deviceChanged((DeviceService)this, Device.getCurrentTimestamp(), state, state);
        }
        this.setDeviceListener(DeviceListeners.add(this.getDeviceListener(), deviceListener));
    }

    public void controlAdded(EscObject container, Object currentTimestamp, ControlService control) {
        DeviceListener deviceListener = this.getDeviceListener();
        if (deviceListener != null) {
            deviceListener.controlChanged((DeviceService)this, Device.getCurrentTimestamp(), control, 1);
        }
    }

    public void controlRemoved(EscObject container, Object timestamp, ControlService control) {
        DeviceListener deviceListener = this.getDeviceListener();
        if (deviceListener != null) {
            deviceListener.controlChanged((DeviceService)this, Device.getCurrentTimestamp(), control, 0);
        }
    }

    protected void finalize() throws Throwable {
        if (this.getState() > 0) {
            this.exit();
        }
    }

    public void fireContainerChanged(Object timestamp, int newState, int oldState) {
        try {
            DeviceListener deviceListener = this.getDeviceListener();
            if (deviceListener != null) {
                deviceListener.deviceChanged((DeviceService)this, timestamp, newState, oldState);
            }
        }
        catch (Exception exception) {
            this.handleError(exception, 3006, this.deviceListener);
        }
        this.broadcastStatus(timestamp, newState, oldState);
    }

    public void fireErrorOccurred(Object timestamp, Object data) {
        if (this.getDeviceListener() != null) {
            try {
                this.getDeviceListener().errorOccurred((Object)this, timestamp, data);
            }
            catch (Exception exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public MeasurementService getCapabilities() {
        return this.capabilities;
    }

    public MeasurementService getConfiguration() {
        return this.configuration;
    }

    public String getDefaultKey() {
        return "Device";
    }

    public DeviceListener getDeviceListener() {
        return this.deviceListener;
    }

    public int getMessageCapacity() {
        return 101;
    }

    public Object getMessageKey(MessageService message) {
        if (message == null) {
            return this;
        }
        byte[] bytes = message.getBytes();
        if (bytes.length < 1) {
            return null;
        }
        return Device.createInteger((int)(bytes[0] & 0xFF));
    }

    public int getPriority() {
        int priority = this.getInformation() & 0xF;
        if (priority == 0) {
            return 6;
        }
        return priority;
    }

    public long getReadTimeout() {
        if (this.getTransport() instanceof ResponseTransport) {
            long responseTimeout = ((ResponseTransport)this.getTransport()).getResponseTimeout();
            return Math.max(responseTimeout, this.readTimeout);
        }
        return this.readTimeout;
    }

    public MeasurementService getStatus() {
        return this.status;
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean hasListeners() {
        return this.getDeviceListener() != null;
    }

    private void initialize() {
        this.capabilities = new Measurement("Device/Capabilities");
        this.status = new Measurement("Device/Status");
        this.configuration = new Measurement("Device/Configuration");
        this.metrics = new MethodMeasurement("Device/Metrics");
        this.put(this.configuration);
        this.put(this.status);
        this.put(this.capabilities);
        this.put(this.metrics);
    }

    public boolean isAutoStart() {
        return (this.getInformation() & 1) == 1;
    }

    public boolean isBlockProcessing() {
        return (this.getInformation() & 8) == 8;
    }

    public boolean isEvenProcessing() {
        return (this.getInformation() & 4) == 4;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isStarted() {
        return this.getState() >= 5;
    }

    public boolean isThreadNeeded() {
        return this.isInitializeMeasurements() || !this.getControls().isEmpty();
    }

    protected void load(ControlService control) {
        if (control instanceof DeviceControl) {
            ((DeviceControl)control).setDevice((DeviceService)this);
        }
    }

    public void put(String key, ControlService control) {
        super.put(key, control);
        this.controlAdded(this, Device.getCurrentTimestamp(), control);
    }

    public void remove(String key) {
        ControlService control = this.get(key);
        if (control != null && this.hasListeners()) {
            this.controlRemoved(this, Device.getCurrentTimestamp(), control);
        }
        super.remove(key);
    }

    public void removeDeviceListener(DeviceListener deviceListener) {
        this.setDeviceListener(DeviceListeners.remove(this.getDeviceListener(), deviceListener));
    }

    public void restart() {
        this.startup(true);
    }

    public void run() {
        if (this.isRunning()) {
            this.transportStartedWait();
            if (this.isRunning()) {
                this.startupCommands();
                if (this.isRunning()) {
                    this.setState(5);
                }
            }
        }
    }

    public void setDeviceListener(DeviceListener deviceListener) {
        this.deviceListener = deviceListener;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setRunning(boolean running) {
        this.isRunning = running;
    }

    public void setStarted(boolean started) {
        if (started) {
            this.setInformation(this.getInformation() | 0x10000);
        } else {
            this.setInformation(this.getInformation() & 0xFFFEFFFF);
        }
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public synchronized void start() {
        TransportService transport;
        super.start();
        if (this.getState() < 4 && (transport = this.getTransport()) != null) {
            if (transport.getState() == 5) {
                if (this.isThreadNeeded()) {
                    this.startup(true);
                } else {
                    this.setState(5);
                }
            } else {
                transport.start();
            }
            return;
        }
        this.startup(true);
    }

    public void startup(boolean output) {
        if (this.isThreadNeeded()) {
            Thread thread = this.getThread();
            if (thread != null) {
                this.setRunning(false);
                thread.interrupt();
                try {
                    thread.join(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.setThread(new Thread((Runnable)this, String.valueOf(this.getOutputName())));
            this.thread.setPriority(this.getPriority());
            this.thread.setDaemon(true);
            this.setRunning(true);
            this.thread.start();
        } else {
            this.setState(5);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void stop() {
        this.setRunning(false);
        if (this.getState() >= 5) {
            ControlService control = this.get(POLL_COMMAND_NAME);
            if (control instanceof CommandService) {
                try {
                    ((CommandService)control).execute((Object)Boolean.FALSE);
                }
                catch (Exception exception) {}
            }
            if ((control = this.get(STOP_COMMAND_NAME)) instanceof CommandService) {
                try {
                    ((CommandService)control).execute();
                }
                catch (Exception exception) {}
            }
        }
        this.setState(1);
        try {
            try {
                Thread thread = this.getThread();
                if (thread != null) {
                    thread.interrupt();
                    thread.join(10000L);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.thread = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.thread = null;
            return;
        }
    }
}

