/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device;

import java.util.Hashtable;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.Device;
import org.eclipse.soda.dk.device.MessageHandler;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.message.Messages;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.MessageListeners;
import org.eclipse.soda.dk.transport.service.MessageListener;
import org.eclipse.soda.dk.transport.service.TransportListener;
import org.eclipse.soda.dk.transport.service.TransportService;

public abstract class TransportDevice
extends Device
implements TransportListener {
    private TransportService transport;
    private Hashtable messageListeners;

    protected TransportDevice() {
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        ControlService control = this.get("error");
        if (control != null) {
            if (control instanceof CommandService) {
                ((CommandService)control).execute(source);
            }
            if (control instanceof SignalService) {
                ((SignalService)control).trigger(source);
            }
        }
        super.errorOccurred(source, timestamp, data);
    }

    public void exit() {
        super.exit();
        this.messageListeners = null;
        this.setTransport(null);
    }

    public abstract TransportService getDefaultTransport();

    public InterestService getInterest() {
        return null;
    }

    public Hashtable getMessageListeners() {
        return this.messageListeners;
    }

    public TransportService getTransport() {
        return this.transport;
    }

    protected void load(ControlService control) {
        super.load(control);
        if (control instanceof MessageHandler) {
            MessageService messages = ((MessageHandler)control).getMessage();
            this.registerMessageHandler(messages, (MessageHandler)control);
        }
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        MessageListener messageListener;
        Object key = this.getMessageKey(message);
        if (key != null && (messageListener = (MessageListener)this.getMessageListeners().get(key)) != null) {
            try {
                messageListener.messageReceived(transportService, timestamp, message);
            }
            catch (Exception exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public void register(TransportService transport) {
        if (transport != null) {
            if (this.messageListeners == null) {
                this.messageListeners = new Hashtable(this.getMessageCapacity());
            }
            transport.addTransportListener((TransportListener)this);
        }
    }

    public void registerMessageHandler(MessageService[] messages, MessageHandler value) {
        int length = messages.length;
        int i = 0;
        while (i < length) {
            this.registerMessageHandler(messages[i], value);
            ++i;
        }
    }

    public void registerMessageHandler(MessageService message, MessageHandler value) {
        if (message instanceof Messages) {
            MessageService[] messages = ((Messages)message).getMessages();
            int j = 0;
            while (j < messages.length) {
                this.registerMessageHandler(messages[j], value);
                ++j;
            }
        } else {
            Object key = this.getMessageKey(message);
            if (key != null) {
                if (this.messageListeners == null) {
                    this.messageListeners = new Hashtable(this.getMessageCapacity());
                }
                MessageListener messageListener = (MessageListener)this.messageListeners.get(key);
                this.messageListeners.put(key, MessageListeners.add((MessageListener)messageListener, (MessageListener)value));
            }
        }
    }

    public void send(MessageService message) throws RuntimeException {
        TransportService transport = this.getTransport();
        if (transport == null) {
            throw new RuntimeException(this.getResource(3017));
        }
        transport.send(message);
    }

    public void setState(int state) {
        int transportState;
        if (state < 2) {
            super.setState(state);
            return;
        }
        TransportService transport = this.getTransport();
        if (transport != null && (transportState = transport.getState()) > 2) {
            super.setState(transportState);
            return;
        }
        super.setState(2);
    }

    public void setTransport(TransportService transport) {
        if (this.getState() >= 4) {
            this.stop();
            this.unregister(this.transport);
            this.transport = transport;
            this.start();
        } else {
            this.unregister(this.transport);
            this.transport = transport;
        }
        if (this.transport != null) {
            this.register(this.transport);
        }
    }

    public void setup() {
        super.setup();
        if (this.getTransport() == null) {
            this.setTransport(this.getDefaultTransport());
        }
    }

    public void start() {
        if (!this.isStarted()) {
            InterestService interest;
            super.start();
            TransportService transport = this.getTransport();
            if (transport != null && (interest = this.getInterest()) != null) {
                transport.addInterest(interest);
            }
        }
    }

    public synchronized void stop() {
        InterestService interest;
        TransportService transport = this.getTransport();
        if (transport != null && (interest = this.getInterest()) != null) {
            transport.removeInterest(interest);
        }
        this.setRunning(false);
        super.stop();
        if (transport != null) {
            transport.stop();
        }
    }

    public void transportChanged(TransportService transportService, Object timestamp, int newState, int oldState) {
        int mystate = this.getState();
        if (mystate != newState && mystate > 1) {
            if (newState == 5) {
                if (this.isThreadNeeded()) {
                    super.setState(mystate);
                    this.restart();
                } else {
                    this.setState(5);
                }
            } else if (newState > 1) {
                super.setState(newState);
            } else {
                super.setState(2);
            }
        }
    }

    public void unregister(TransportService transport) {
        if (transport != null) {
            transport.removeTransportListener((TransportListener)this);
        }
    }
}

