/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.measurement;

import org.eclipse.soda.dk.device.Control;
import org.eclipse.soda.dk.measurement.MeasurementListeners;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.units.service.UnitsService;

public class Measurement
extends Control
implements MeasurementService {
    private MeasurementListener measurementListener;
    private Object value;
    private Object timestamp;

    public Measurement(String key) {
        this(key, null);
    }

    public Measurement(String key, Object value) {
        super(key);
        this.setValue(value, Measurement.getCurrentTimestamp());
    }

    public synchronized void addMeasurementListener(MeasurementListener measurementListener) {
        if (measurementListener != null) {
            this.setMeasurementListener(MeasurementListeners.add(this.getMeasurementListener(), measurementListener));
            Object newValue = this.getValue();
            if (newValue != null) {
                this.fireValueChanged(measurementListener, this.getTimestamp(), newValue, null);
            }
        }
    }

    public void executeRead() {
    }

    public void executeWrite(Object value) {
        this.setValue(value);
    }

    protected void fireErrorOccurred(MeasurementListener measurementListener, Object timestamp, Object data) {
        try {
            measurementListener.errorOccurred((Object)this, timestamp, data);
        }
        catch (Exception exception) {
            this.handleError(exception, 1);
        }
    }

    public void fireErrorOccurred(Object timestamp, Object data) {
        MeasurementListener measurementListener = this.getMeasurementListener();
        if (measurementListener != null) {
            this.fireErrorOccurred(measurementListener, Measurement.getCurrentTimestamp(), data);
        }
    }

    protected void fireValueChanged(MeasurementListener measurementListener, Object timestamp, Object newValue, Object oldValue) {
        try {
            measurementListener.measurementChanged((MeasurementService)this, timestamp, newValue, oldValue);
        }
        catch (Exception exception) {
            this.handleError(exception, 1);
        }
    }

    protected MeasurementListener getMeasurementListener() {
        return this.measurementListener;
    }

    public Object getTimestamp() {
        return this.timestamp;
    }

    public UnitsService getUnits() {
        return null;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValueRaw() {
        return this.value;
    }

    public Object read(long timeout) {
        return this.getValue();
    }

    public synchronized void removeMeasurementListener(MeasurementListener measurementListener) {
        this.setMeasurementListener(MeasurementListeners.remove(this.getMeasurementListener(), measurementListener));
    }

    protected void reportError(int errorNumber, Throwable error, Object[] errorObjects) throws RuntimeException {
        super.reportError(errorNumber, error, errorObjects);
        MeasurementListener measurementListener = this.getMeasurementListener();
        if (measurementListener != null) {
            this.fireErrorOccurred(measurementListener, Measurement.getCurrentTimestamp(), error);
        }
    }

    public void setMeasurementListener(MeasurementListener measurementListener) {
        this.measurementListener = measurementListener;
    }

    protected void setRawValue(Object data, Object timestamp) {
        this.setValue(data, timestamp);
    }

    public void setTimestamp(Object timestamp) {
        if (this.timestamp != timestamp) {
            this.timestamp = timestamp;
        } else {
            long time = 0L;
            time = timestamp instanceof Number ? ((Number)timestamp).longValue() : System.currentTimeMillis();
            this.timestamp = new Long(time);
        }
    }

    public void setValue(Object value) {
        this.setValue(value, Measurement.getCurrentTimestamp());
    }

    public void setValue(Object value, Object timestamp) {
        if (!this.equalsValue(this.value, value)) {
            Object oldValue = this.value;
            this.value = value;
            this.setTimestamp(timestamp);
            MeasurementListener measurementListener = this.getMeasurementListener();
            if (measurementListener != null) {
                this.fireValueChanged(measurementListener, timestamp, this.value, oldValue);
            }
        } else {
            this.setTimestamp(timestamp);
        }
    }
}

