/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.measurement;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;

public class MeasurementListeners
extends EscObject
implements MeasurementListener {
    private MeasurementListener[] objects;

    public MeasurementListeners(MeasurementListener[] objects) {
        this.setObjects(objects);
    }

    public MeasurementListeners(MeasurementListener currentObject, MeasurementListener newObject) {
        if (currentObject instanceof MeasurementListeners) {
            MeasurementListeners currentMulticaster = (MeasurementListeners)currentObject;
            MeasurementListener[] oldList = currentMulticaster.getObjects();
            this.objects = new MeasurementListener[oldList.length + 1];
            System.arraycopy(oldList, 0, this.objects, 0, oldList.length);
            this.objects[oldList.length] = newObject;
        } else {
            this.objects = new MeasurementListener[]{currentObject, newObject};
        }
    }

    public static MeasurementListener add(MeasurementListener currentObject, MeasurementListener newObject) {
        if (currentObject == null) {
            return newObject;
        }
        if (newObject == null) {
            return currentObject;
        }
        return new MeasurementListeners(currentObject, newObject);
    }

    public static MeasurementListener remove(MeasurementListener currentObject, MeasurementListener removeObject) {
        if (currentObject == removeObject) {
            return null;
        }
        if (currentObject instanceof MeasurementListeners) {
            return ((MeasurementListeners)currentObject).remove(removeObject);
        }
        return currentObject;
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].errorOccurred(source, timestamp, data);
            }
            catch (Exception exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    public MeasurementListener[] getObjects() {
        return this.objects;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].measurementChanged(source, timestamp, newValue, oldValue);
            }
            catch (Exception exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    protected MeasurementListener remove(MeasurementListener removeHandler) {
        MeasurementListener[] oldList = this.getObjects();
        switch (oldList.length) {
            case 0: {
                return null;
            }
            case 1: {
                if (oldList[0] != removeHandler) break;
                return null;
            }
            case 2: {
                if (oldList[1] == removeHandler) {
                    return oldList[0];
                }
                if (oldList[0] != removeHandler) break;
                return oldList[1];
            }
            default: {
                int index = oldList.length - 1;
                while (index >= 0) {
                    if (oldList[index] == removeHandler) {
                        MeasurementListener[] newList = new MeasurementListener[oldList.length - 1];
                        if (index == oldList.length - 1) {
                            System.arraycopy(oldList, 0, newList, 0, newList.length);
                        } else {
                            if (index > 0) {
                                System.arraycopy(oldList, 0, newList, 0, index);
                            }
                            System.arraycopy(oldList, index + 1, newList, index, newList.length - index);
                        }
                        return new MeasurementListeners(newList);
                    }
                    --index;
                }
                break block0;
            }
        }
        return this;
    }

    private void setObjects(MeasurementListener[] objects) {
        this.objects = objects;
    }
}

