/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.signal;

import org.eclipse.soda.dk.device.MessageHandler;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.signal.Signal;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.transport.service.TransportService;

public class MessageSignal
extends Signal
implements MessageHandler {
    private MessageService message;

    public MessageSignal(String key, MessageService message) {
        super(key);
        this.setMessage(message);
    }

    public MessageService getMessage() {
        return this.message;
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        SignalListener signalListener = this.getSignalListener();
        if (signalListener != null && this.getMessage().matches(message) != null) {
            try {
                this.fireSignalOccurred(signalListener, timestamp);
            }
            catch (Exception exception) {
                this.log(1, this.toString(), exception);
            }
        }
    }

    public void setMessage(MessageService message) {
        this.message = message;
    }
}

