/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.signal;

import org.eclipse.soda.dk.device.Control;
import org.eclipse.soda.dk.signal.SignalListeners;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class Signal
extends Control
implements SignalService {
    private SignalListener signalListener;

    public Signal(String key) {
        super(key);
    }

    public synchronized void addSignalListener(SignalListener signalListener) {
        this.setSignalListener(SignalListeners.add(this.getSignalListener(), signalListener));
    }

    public void fireErrorOccurred(Object timestamp, Object data) {
        SignalListener signalListener = this.getSignalListener();
        if (signalListener != null) {
            this.fireErrorOccurred(signalListener, Signal.getCurrentTimestamp(), data);
        }
    }

    protected void fireErrorOccurred(SignalListener signalListener, Object timestamp, Object data) {
        try {
            signalListener.errorOccurred((Object)this, timestamp, data);
        }
        catch (Exception exception) {
            this.handleError(exception, 1);
        }
    }

    public void fireSignalOccurred(SignalListener signalListener, Object timestamp) {
        try {
            signalListener.signalOccurred((SignalService)this, timestamp, null);
        }
        catch (Exception exception) {
            this.handleError(exception, 1);
        }
    }

    public void fireSignalOccurred(SignalListener signalListener, Object timestamp, Object data) {
        try {
            signalListener.signalOccurred((SignalService)this, timestamp, data);
        }
        catch (Exception exception) {
            this.handleError(exception, 1);
        }
    }

    protected SignalListener getSignalListener() {
        return this.signalListener;
    }

    public synchronized void removeSignalListener(SignalListener signalListener) {
        this.setSignalListener(SignalListeners.remove(this.getSignalListener(), signalListener));
    }

    protected void reportError(int errorNumber, Throwable error, Object[] errorObjects) throws RuntimeException {
        super.reportError(errorNumber, error, errorObjects);
        SignalListener signalListener = this.getSignalListener();
        if (signalListener != null) {
            this.fireErrorOccurred(signalListener, Signal.getCurrentTimestamp(), error);
        }
    }

    public void setSignalListener(SignalListener signalListener) {
        this.signalListener = signalListener;
    }

    public void trigger() {
        SignalListener signalListener = this.getSignalListener();
        if (signalListener != null) {
            try {
                this.fireSignalOccurred(signalListener, Signal.getCurrentTimestamp(), null);
            }
            catch (Exception exception) {
                this.log(1, this.toString(), exception);
            }
        }
    }

    public void trigger(Object value) {
        SignalListener signalListener = this.getSignalListener();
        if (signalListener != null) {
            try {
                this.fireSignalOccurred(signalListener, Signal.getCurrentTimestamp(), value);
            }
            catch (Exception exception) {
                this.log(1, this.toString(), exception);
            }
        }
    }

    public void trigger(Object data, Object timestamp) {
        SignalListener signalListener = this.getSignalListener();
        if (signalListener != null) {
            try {
                this.fireSignalOccurred(signalListener, timestamp, data);
            }
            catch (Exception exception) {
                this.log(1, this.toString(), exception);
            }
        }
    }
}

