/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.gpio.profile;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.epcglobal.llrp.gpio.profile.service.EpcglobalLlrpGpioProfileService;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPUtils;
import org.eclipse.soda.dk.epcglobal.llrp.helper.ParameterFactory;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_SET_READER_CONFIG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskListener;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.TaskManager;
import org.eclipse.soda.dk.gpio.profile.GpioProfile;
import org.eclipse.soda.dk.gpio.profile.service.GpioProfileService;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class EpcglobalLlrpGpioProfile
extends GpioProfile
implements ProfileService,
EpcglobalLlrpGpioProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.epcglobal.llrp.gpio.profile.EpcglobalLlrpGpioProfile";
    protected CommandService epcglobalLlrpDeviceServiceSetReaderConfig_ReaderEventNotificationSpec;
    protected CommandService epcglobalLlrpDeviceServiceSetReaderConfig_GPIPortCurrentState;
    protected CommandService epcglobalLlrpDeviceServiceGetReaderConfig_GPIPortCurrentState;
    protected CommandService epcglobalLlrpDeviceServiceSetReaderConfig_GPOWriteData;
    protected SignalService epcglobalLlrpDeviceServiceSetReaderConfigResponse;
    protected SignalService epcglobalLlrpDeviceServiceGPIPortCurrentStateResponse;
    protected SignalService epcglobalLlrpDeviceServiceReaderEventNotification;
    private int gpiPortCount = 4;
    private int gpoPortCount = 8;
    private TaskManager taskManager = new TaskManager("org.eclipse.soda.dk.epcglobal.llrp.gpio.profile.EpcglobalLlrpGpioProfile.TaskManager");
    private ITaskListener taskListner = new ITaskListener(){

        public void taskNotice(String taskName, int status, Object result) {
            if (status == 0) {
                String errorMsg = LLRPUtils.handleErrorResponse((String)taskName, (Map)((Map)result));
                EpcglobalLlrpGpioProfile.this.handleError(new RuntimeException(errorMsg), 1);
                return;
            }
        }
    };
    private ITask setReaderConfig_GPIPortCurrentStateTask;
    private ITask setReaderConfig_ReaderEventNotificationSpecTask;

    public EpcglobalLlrpGpioProfile() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public EpcglobalLlrpGpioProfile(DeviceService device) {
        this.setKey(this.getDefaultKey());
        this.setDevice(device);
        this.initialize();
    }

    public void activate() {
        this.populateTasks();
        this.initGPIEvent();
        super.activate();
    }

    protected void enableGPIEventNotification() {
        this.log(4, "Enable reader event on GPIO input ports.");
        this.taskManager.addTaskToBottom(this.setReaderConfig_ReaderEventNotificationSpecTask, true);
    }

    protected void enableGPIPorts() {
        this.log(4, "Enable GPIO Input ports");
        this.taskManager.addTaskToBottom(this.setReaderConfig_GPIPortCurrentStateTask, true);
    }

    protected void epcEpcglobalLlrpUpdateOutputPort(int gpoPortNumber, Boolean gpoPortState) {
        this.log(4, "Update output pin " + gpoPortNumber + ", " + (gpoPortState != false ? "ON" : "OFF"));
        Hashtable params = new Hashtable();
        ArrayList<Map> GPOWriteData0_N = new ArrayList<Map>();
        Map GPOWriteData = ParameterFactory.getGPOWriteDataParameter((int)gpoPortNumber, (boolean)gpoPortState);
        GPOWriteData0_N.add(GPOWriteData);
        params.put("GPOWriteDataParameter", GPOWriteData0_N);
        this.epcglobalLlrpDeviceServiceSetReaderConfig_GPOWriteData.execute(params);
    }

    protected void epcEpcglobalLlrpUpdateOutputPort(List gpoWriteDatas) {
        this.epcglobalLlrpDeviceServiceSetReaderConfig_GPOWriteData.execute((Object)ParameterFactory.getSetGPOWriteDataParameter((List)gpoWriteDatas));
    }

    public DeviceService getDefaultDevice() {
        return (DeviceService)EpcglobalLlrpGpioProfile.loadService((String)DeviceService.SERVICE_NAME, (String)"org.eclipse.soda.dk.epcglobal.llrp.device.EpcglobalLlrpDevice");
    }

    public String getDefaultKey() {
        return "EpcglobalLlrpGpioProfile";
    }

    private Map getGPICurrentStateParameter(int gpiPortNum) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("GPIPortNum", new Integer(gpiPortNum));
        return parameters;
    }

    public int getGpiPortCount() {
        return this.gpiPortCount;
    }

    public int getGpoPortCount() {
        return this.gpoPortCount;
    }

    protected long getInputCountValue() {
        return this.getGpiPortCount();
    }

    private Map getNewInputMap() {
        Map oldInputMap = (Map)this.input.getValue();
        Hashtable newInputMap = new Hashtable(32);
        if (oldInputMap != null) {
            newInputMap.putAll(oldInputMap);
        }
        return newInputMap;
    }

    protected long getOutputCountValue() {
        return this.getGpoPortCount();
    }

    protected Map getReaderEventNotificationSpecParameter() {
        ArrayList<Map> enableGpis = new ArrayList<Map>();
        enableGpis.add(ParameterFactory.getEventNotificationStateParameter((int)1, (boolean)true));
        return ParameterFactory.getReaderEventNotificationSpecParameter(enableGpis);
    }

    protected Map getSetReaderConfigGPIEventParameter() {
        return ParameterFactory.getSetReaderConfig_ReaderEventNotificationSpecParameter((boolean)false, (Map)this.getReaderEventNotificationSpecParameter());
    }

    protected Map getSetReaderGPICurrentStateParameter() {
        ArrayList<Map> gpis = new ArrayList<Map>();
        int gpiPortNum = 1;
        while (gpiPortNum <= this.getGpiPortCount()) {
            gpis.add(ParameterFactory.getGPIPortCurrentStateParameter((int)gpiPortNum, (boolean)true));
            ++gpiPortNum;
        }
        return ParameterFactory.getSetReaderGPICurrentStateParameter((boolean)false, gpis);
    }

    private void handleEpcglobalLlrpDeviceServiceGetReaderConfig_GPIPortCurrentState(SignalService source, Object timestamp, Object data) {
        List gpiPortCurrentStates = (List)data;
        if (gpiPortCurrentStates != null) {
            Map newInputMap = this.getNewInputMap();
            int i = 0;
            while (i < gpiPortCurrentStates.size()) {
                Map gpiPortCurrentState = (Map)gpiPortCurrentStates.get(i);
                Integer gpiPortNum = (Integer)gpiPortCurrentState.get("GPIPortNum");
                Integer gpiState = (Integer)gpiPortCurrentState.get("State");
                if (gpiPortNum != null && gpiState != null && (long)gpiPortNum.intValue() <= this.getInputCountValue() && gpiPortNum >= 1) {
                    this.log(4, "GPIPortNum: " + gpiPortNum + ", state:" + gpiState);
                    newInputMap.put(GpioProfileService.INPUT_NAMES[gpiPortNum], gpiState == 1 ? Boolean.TRUE : Boolean.FALSE);
                }
                ++i;
            }
            this.input.setValue((Object)newInputMap, timestamp);
        }
    }

    private void handleEpcglobalLlrpDeviceServiceReaderEventNotification(SignalService source, Object timestamp, Object data) {
        Map gpiEventParams;
        Map params = (Map)data;
        Map readerEventNotificationParams = (Map)params.get("ReaderEventNotificationDataParameter");
        if (readerEventNotificationParams != null && (gpiEventParams = (Map)readerEventNotificationParams.get("GPIEventParameter")) != null) {
            short param_GPIPortNumber = (short)((Integer)gpiEventParams.get("GPIPortNumber")).intValue();
            Boolean param_GPIEvent = (Boolean)gpiEventParams.get("GPIEvent");
            this.updateInput(param_GPIPortNumber, param_GPIEvent, timestamp);
        }
    }

    private void initGPIEvent() {
        this.taskManager.reset();
        this.enableGPIPorts();
        this.enableGPIEventNotification();
        this.epcglobalLlrpDeviceServiceGetReaderConfig_GPIPortCurrentState.execute((Object)this.getGPICurrentStateParameter(0));
    }

    private void initialize() {
        this.taskManager.addTaskListener(this.taskListner);
    }

    public boolean isDeviceNeeded() {
        return true;
    }

    protected void populateTasks() {
        this.setReaderConfig_GPIPortCurrentStateTask = new Task_SET_READER_CONFIG(this.epcglobalLlrpDeviceServiceSetReaderConfig_GPIPortCurrentState, this.getSetReaderGPICurrentStateParameter(), this.epcglobalLlrpDeviceServiceSetReaderConfigResponse, "GPIPortCurrentState");
        this.setReaderConfig_ReaderEventNotificationSpecTask = new Task_SET_READER_CONFIG(this.epcglobalLlrpDeviceServiceSetReaderConfig_ReaderEventNotificationSpec, this.getSetReaderConfigGPIEventParameter(), this.epcglobalLlrpDeviceServiceSetReaderConfigResponse, "ReaderEventNotificationSpec");
    }

    public void setDevice(DeviceService device) {
        if (this.getDevice() != null) {
            if (this.epcglobalLlrpDeviceServiceSetReaderConfig_ReaderEventNotificationSpec != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfig_ReaderEventNotificationSpec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceSetReaderConfig_GPIPortCurrentState != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfig_GPIPortCurrentState.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetReaderConfig_GPIPortCurrentState != null) {
                this.epcglobalLlrpDeviceServiceGetReaderConfig_GPIPortCurrentState.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceSetReaderConfig_GPOWriteData != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfig_GPOWriteData.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceSetReaderConfigResponse != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfigResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGPIPortCurrentStateResponse != null) {
                this.epcglobalLlrpDeviceServiceGPIPortCurrentStateResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceReaderEventNotification != null) {
                this.epcglobalLlrpDeviceServiceReaderEventNotification.removeSignalListener((SignalListener)this);
            }
        }
        if (device != null) {
            this.epcglobalLlrpDeviceServiceSetReaderConfig_ReaderEventNotificationSpec = device.getCommand("SetReaderConfig_ReaderEventNotificationSpec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceSetReaderConfig_ReaderEventNotificationSpec);
            this.epcglobalLlrpDeviceServiceSetReaderConfig_GPIPortCurrentState = device.getCommand("SetReaderConfig_GPIPortCurrentState");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceSetReaderConfig_GPIPortCurrentState);
            this.epcglobalLlrpDeviceServiceGetReaderConfig_GPIPortCurrentState = device.getCommand("GetReaderConfig_GPIPortCurrentState");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceGetReaderConfig_GPIPortCurrentState);
            this.epcglobalLlrpDeviceServiceSetReaderConfig_GPOWriteData = device.getCommand("SetReaderConfig_GPOWriteData");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceSetReaderConfig_GPOWriteData);
            this.epcglobalLlrpDeviceServiceSetReaderConfigResponse = device.getSignal("SetReaderConfigResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceSetReaderConfigResponse);
            this.epcglobalLlrpDeviceServiceGPIPortCurrentStateResponse = device.getSignal("GPIPortCurrentStateResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceGPIPortCurrentStateResponse);
            this.epcglobalLlrpDeviceServiceReaderEventNotification = device.getSignal("ReaderEventNotification");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceReaderEventNotification);
        }
        super.setDevice(device);
    }

    public void setGpiPortCount(int gpiPortCount) {
        this.gpiPortCount = gpiPortCount;
    }

    public void setGpoPortCount(int gpoPortCount) {
        this.gpoPortCount = gpoPortCount;
    }

    public void setup() {
        super.setup();
        this.setGpiPortCount(this.getInt("epcgloballlrpgpioprofile.gpiPortCount", this.getGpiPortCount()));
        this.setGpoPortCount(this.getInt("epcgloballlrpgpioprofile.gpoPortCount", this.getGpoPortCount()));
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        if (this.epcglobalLlrpDeviceServiceReaderEventNotification == source) {
            this.handleEpcglobalLlrpDeviceServiceReaderEventNotification(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceGPIPortCurrentStateResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceGetReaderConfig_GPIPortCurrentState(source, timestamp, data);
            return;
        }
        this.taskManager.handleResponse(source, timestamp, data);
    }

    protected void turnOffAllOutputs() {
        this.log(4, "Turn off all output.");
        int totalOutputPins = (int)this.getOutputCountValue();
        ArrayList<Map> gpoWriteDatas = new ArrayList<Map>();
        int i = 1;
        while (i <= totalOutputPins) {
            gpoWriteDatas.add(ParameterFactory.getGPOWriteDataParameter((int)i, (boolean)false));
            ++i;
        }
        this.epcEpcglobalLlrpUpdateOutputPort(gpoWriteDatas);
    }

    protected void turnOnAllOutputs() {
        this.log(4, "Turn on all output.");
        int totalOutputPins = (int)this.getOutputCountValue();
        ArrayList<Map> gpoWriteDatas = new ArrayList<Map>();
        int i = 1;
        while (i <= totalOutputPins) {
            gpoWriteDatas.add(ParameterFactory.getGPOWriteDataParameter((int)i, (boolean)true));
            ++i;
        }
        this.epcEpcglobalLlrpUpdateOutputPort(gpoWriteDatas);
    }

    private void updateInput(int gpiPortNumber, Boolean gpiState, Object timestamp) {
        short totalInputBits = (short)this.getInputCountValue();
        if (gpiPortNumber < 1 || gpiPortNumber > totalInputBits) {
            this.handleError(new RuntimeException("param_GPIPortNumber=" + gpiPortNumber + " is invalid"), 3012);
            return;
        }
        Map newInputMap = this.getNewInputMap();
        newInputMap.put(GpioProfileService.INPUT_NAMES[gpiPortNumber], gpiState);
        this.input.setValue((Object)newInputMap, timestamp);
    }

    protected void updateOutputs(Map fullState, Map individualRequest) {
        if (this.isStarted() && this.getDevice() != null && this.getDevice().isStarted()) {
            Set keyset = individualRequest.keySet();
            Iterator i = keyset.iterator();
            ArrayList<Map> gpoWriteDatas = new ArrayList<Map>();
            while (i.hasNext()) {
                String key = (String)i.next();
                Boolean val = (Boolean)individualRequest.get(key);
                int gpoPortNumber = new Integer(key.substring(1));
                this.log(4, "Update output pin " + gpoPortNumber + ", " + (val != false ? "ON" : "OFF"));
                gpoWriteDatas.add(ParameterFactory.getGPOWriteDataParameter((int)gpoPortNumber, (boolean)val));
            }
            this.epcEpcglobalLlrpUpdateOutputPort(gpoWriteDatas);
        }
    }
}

