/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper;

import java.util.List;
import java.util.Map;

public class LLRPUtils {
    public static String byteArray2Str(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            result.append(Integer.toHexString(bytes[i] & 0xFF));
            if (i != bytes.length - 1) {
                result.append(',');
            }
            ++i;
        }
        return result.toString();
    }

    public static byte[] convertIntListToBytes(List intList) {
        if (intList != null) {
            byte[] readDataBytes = new byte[intList.size() * 2];
            int k = 0;
            while (k < intList.size()) {
                short value = ((Integer)intList.get(k)).shortValue();
                readDataBytes[2 * k] = new Integer(value >> 8 & 0xFF).byteValue();
                readDataBytes[2 * k + 1] = new Integer(value & 0xFF).byteValue();
                ++k;
            }
            return readDataBytes;
        }
        return null;
    }

    public static Integer extractAntennaId(Map antennaIdParam) {
        if (antennaIdParam != null) {
            return (Integer)antennaIdParam.get("AntennaID");
        }
        return null;
    }

    public static String extractTag(Map EPCParameterChoice) {
        if (EPCParameterChoice != null) {
            String tagType = (String)EPCParameterChoice.get("key");
            String tagKey = "";
            if ("EPCDataParameter".equals(tagType)) {
                tagKey = "EPCData_EPC";
            } else if ("EPC_96Parameter".equals(tagType)) {
                tagKey = "EPC_96_EPC";
            }
            byte[] param_EPC = (byte[])EPCParameterChoice.get(tagKey);
            if (param_EPC == null) {
                return null;
            }
            StringBuffer tag = new StringBuffer();
            int j = 0;
            while (j < param_EPC.length) {
                int n = 0;
                while (n < 2) {
                    int nibble = param_EPC[j] >> 4 * (1 - n) & 0xF;
                    char ch = (char)(nibble < 10 ? 48 + nibble : 65 + (nibble - 10));
                    tag.append(ch);
                    ++n;
                }
                ++j;
            }
            return tag.toString();
        }
        return null;
    }

    public static Integer extractTagSeenCount(Map tagSeenCountParam) {
        if (tagSeenCountParam != null) {
            return (Integer)tagSeenCountParam.get("TagCount");
        }
        return null;
    }

    public static String handleErrorResponse(String sourceTask, Map paramMap) {
        if (paramMap == null) {
            return "Task Error: " + sourceTask;
        }
        Map LLRPStatusParam = (Map)paramMap.get("LLRPStatusParameter");
        if (LLRPStatusParam == null) {
            return "";
        }
        Integer statusCode = (Integer)LLRPStatusParam.get("StatusCode");
        String errorDesc = (String)LLRPStatusParam.get("ErrorDescription");
        errorDesc = errorDesc != null && errorDesc.length() > 0 ? "," + errorDesc : "";
        return "Error Occurred In " + sourceTask + ": code=" + statusCode + errorDesc;
    }

    public static String hexStrIncrement(String str, int inc) {
        if (str == null) {
            return null;
        }
        char[] baseStr = str.toCharArray();
        byte[] baseBits = new byte[baseStr.length];
        int i = 0;
        while (i < baseStr.length) {
            baseBits[i] = Integer.valueOf(String.valueOf(baseStr[i]), 16).byteValue();
            ++i;
        }
        char[] incStr = Integer.toHexString(inc).toCharArray();
        int extra = 0;
        int i2 = 1;
        while (i2 <= baseBits.length) {
            if (i2 > incStr.length && extra == 0) break;
            char incChar = i2 <= incStr.length ? incStr[incStr.length - i2] : (char)'0';
            int incBit = Integer.valueOf(String.valueOf(incChar), 16);
            int addition = baseBits[baseBits.length - i2] + incBit + extra;
            char[] resultBits = Integer.toHexString(addition).toCharArray();
            switch (resultBits.length) {
                case 1: {
                    baseStr[baseStr.length - i2] = resultBits[0];
                    extra = 0;
                    break;
                }
                case 2: {
                    baseStr[baseStr.length - i2] = resultBits[1];
                    extra = Integer.valueOf(String.valueOf(resultBits[0]), 16);
                }
            }
            ++i2;
        }
        return new String(baseStr);
    }

    public static boolean isValidTagId(String tagId) {
        try {
            char[] tagIdChars = tagId.toCharArray();
            int i = 0;
            while (i < tagIdChars.length) {
                Integer.valueOf(String.valueOf(tagIdChars[i]), 16);
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

