/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ParameterFactory {
    public static Map getAISpecParameter(int[] antennaIds, Map aISpecStopTriggerParameter, List inventoryParameterSpecParameters) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        Vector<Integer> antennaIdList = new Vector<Integer>();
        int i = 0;
        while (i < antennaIds.length) {
            antennaIdList.add(new Integer(antennaIds[i]));
            ++i;
        }
        parameters.put("AntennaIDs", antennaIdList);
        parameters.put("AISpecStopTriggerParameter", aISpecStopTriggerParameter);
        parameters.put("InventoryParameterSpecParameter", inventoryParameterSpecParameters);
        Hashtable<String, Hashtable<String, Object>> result = new Hashtable<String, Hashtable<String, Object>>();
        result.put("AISpecParameter", parameters);
        return result;
    }

    public static Map getAISpecStopTriggerParameter(int type, int duration, Map gPITriggerValueParameter, Map tagObservationTriggerParameter) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("AISpecStopTriggerType", new Integer(type));
        parameters.put("DurationTrigger", new Integer(duration));
        if (gPITriggerValueParameter != null) {
            parameters.put("GPITriggerValueParameter", gPITriggerValueParameter);
        }
        if (tagObservationTriggerParameter != null) {
            parameters.put("TagObservationTriggerParameter", tagObservationTriggerParameter);
        }
        return parameters;
    }

    public static Map getAccessCommandParameter(List airProtocolTagSpecChoice, List accessCommandOpSpecChoice) {
        Hashtable<String, List> parameters = new Hashtable<String, List>();
        parameters.put("AirProtocolTagSpecChoice", airProtocolTagSpecChoice);
        parameters.put("AccessCommandOpSpecChoice", accessCommandOpSpecChoice);
        return parameters;
    }

    public static Map getAccessCommandParameter(Map airProtocolTagSpecChoice, Map accessCommandOpSpecChoice) {
        ArrayList<Map> airProtocolTagSpecChoiceList = new ArrayList<Map>();
        airProtocolTagSpecChoiceList.add(airProtocolTagSpecChoice);
        ArrayList<Map> accessCommandOpSpecChoiceList = new ArrayList<Map>();
        accessCommandOpSpecChoiceList.add(accessCommandOpSpecChoice);
        return ParameterFactory.getAccessCommandParameter(airProtocolTagSpecChoiceList, accessCommandOpSpecChoiceList);
    }

    public static Map getAccessCommandParameter(Map airProtocolTagSpecChoice, List accessCommandOpSpecChoiceList) {
        ArrayList<Map> airProtocolTagSpecChoiceList = new ArrayList<Map>();
        airProtocolTagSpecChoiceList.add(airProtocolTagSpecChoice);
        return ParameterFactory.getAccessCommandParameter(airProtocolTagSpecChoiceList, accessCommandOpSpecChoiceList);
    }

    public static Map getAccessReportSpecParameter(int accessReportTrigger) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("AccessReportTrigger", new Integer(accessReportTrigger));
        return parameters;
    }

    public static Map getAccessSpecIDParameter(int accessSpecId) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("AccessSpecID", new Integer(accessSpecId));
        return parameters;
    }

    public static Map getAccessSpecParameter(int accessSpecId, int antennaId, int protocolId, int currentState, int ROSpecId, Map accessSpecStopTriggerParameter, Map accessCommandParameter, Map accessReportSpecParameter) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("AccessSpecID", new Integer(accessSpecId));
        parameters.put("AntennaID", new Integer(antennaId));
        parameters.put("ProtocolID", new Integer(protocolId));
        parameters.put("AccessSpec_CurrentState", new Integer(currentState));
        parameters.put("ROSpecID", new Integer(ROSpecId));
        parameters.put("AccessSpecStopTriggerParameter", accessSpecStopTriggerParameter);
        parameters.put("AccessCommandParameter", accessCommandParameter);
        if (accessReportSpecParameter != null) {
            parameters.put("AccessReportSpecParameter", accessReportSpecParameter);
        }
        return parameters;
    }

    public static Map getAccessSpecStopTriggerParameter(int accessSpecStopTrigger, int operationCountValue) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("AccessSpecStopTrigger", new Integer(accessSpecStopTrigger));
        parameters.put("OperationCountValue", new Integer(operationCountValue));
        return parameters;
    }

    public static Map getAddAccessSpecCommandParameters(int accessSpecId, int antennaId, int protocolId, int currentState, int rospecId, Map accessSpecStopTriggerParameter, Map accessCommandParameter, Map accessReportSpecParameter) {
        Hashtable<String, Map> parameters = new Hashtable<String, Map>();
        parameters.put("AccessSpecParameter", ParameterFactory.getAccessSpecParameter(accessSpecId, antennaId, protocolId, currentState, rospecId, accessSpecStopTriggerParameter, accessCommandParameter, accessReportSpecParameter));
        return parameters;
    }

    public static Map getAddROSpecCommandParameters(int rospecId, int priority, int currentState, Map rOBoundarySpecParameter, List specParameterChoice, Map rOReportSpecParameter) {
        Hashtable<String, Map> parameters = new Hashtable<String, Map>();
        parameters.put("ROSpecParameter", ParameterFactory.getROSpecParameter(rospecId, priority, currentState, rOBoundarySpecParameter, specParameterChoice, rOReportSpecParameter));
        return parameters;
    }

    public static Map getC1G2BlockEraseParameter(int OpSpecId, int accessPassword, int memoryBank, int wordPointer, int wordCount) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("OpSpecID", new Integer(OpSpecId));
        parameters.put("AccessPassword", new Integer(accessPassword));
        parameters.put("MB", new Integer(memoryBank));
        parameters.put("WordPointer", new Integer(wordPointer));
        parameters.put("WordCount", new Integer(wordCount));
        Hashtable<String, Hashtable<String, Integer>> result = new Hashtable<String, Hashtable<String, Integer>>();
        result.put("C1G2BlockEraseParameter", parameters);
        return result;
    }

    public static Map getC1G2BlockWriteParameter(int OpSpecId, int accessPassword, int memoryBank, int wordPointer, String writeData) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("OpSpecID", new Integer(OpSpecId));
        parameters.put("AccessPassword", new Integer(accessPassword));
        parameters.put("MB", new Integer(memoryBank));
        parameters.put("WordPointer", new Integer(wordPointer));
        parameters.put("WriteDatas", ParameterFactory.str2wordList(writeData));
        Hashtable<String, Hashtable<String, Object>> result = new Hashtable<String, Hashtable<String, Object>>();
        result.put("C1G2BlockWriteParameter", parameters);
        return result;
    }

    public static Map getC1G2EPCMemorySelectorParameter(int enableCRC, int enablePCBits) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("EnableCRC", new Integer(enableCRC));
        parameters.put("EnablePCBits", new Integer(enablePCBits));
        Hashtable<String, Hashtable<String, Integer>> result = new Hashtable<String, Hashtable<String, Integer>>();
        result.put("C1G2EPCMemorySelectorParameter", parameters);
        return result;
    }

    public static Map getC1G2KillParameter(int OpSpecId, int killPassword) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("OpSpecID", new Integer(OpSpecId));
        parameters.put("KillPassword", new Integer(killPassword));
        Hashtable<String, Hashtable<String, Integer>> result = new Hashtable<String, Hashtable<String, Integer>>();
        result.put("C1G2KillParameter", parameters);
        return result;
    }

    public static Map getC1G2LockParameter(int OpSpecId, int accessPassword, List c1g2LockPayload) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("OpSpecID", new Integer(OpSpecId));
        parameters.put("AccessPassword", new Integer(accessPassword));
        parameters.put("C1G2LockPayloadParameter", c1g2LockPayload);
        Hashtable<String, Hashtable<String, Object>> result = new Hashtable<String, Hashtable<String, Object>>();
        result.put("C1G2LockParameter", parameters);
        return result;
    }

    public static Map getC1G2LockPayloadParameter(int privilege, int datafield) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("Privilege", new Integer(privilege));
        parameters.put("DataField", new Integer(datafield));
        return parameters;
    }

    public static Map getC1G2ReadParameter(int OpSpecId, int accessPassword, int memoryBank, int wordPointer, int wordCount) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("OpSpecID", new Integer(OpSpecId));
        parameters.put("AccessPassword", new Integer(accessPassword));
        parameters.put("MB", new Integer(memoryBank));
        parameters.put("WordPointer", new Integer(wordPointer));
        parameters.put("WordCount", new Integer(wordCount));
        Hashtable<String, Hashtable<String, Integer>> result = new Hashtable<String, Hashtable<String, Integer>>();
        result.put("C1G2ReadParameter", parameters);
        return result;
    }

    public static Map getC1G2TagSpecParameter() {
        return ParameterFactory.getC1G2TagSpecParameter(ParameterFactory.getC1G2TargetTagParameter(1, true, 32, "00,00,00,00,00,00,00,00,00,00,00,00", "00,00,00,00,00,00,00,00,00,00,00,00"));
    }

    public static Map getC1G2TagSpecParameter(Map c1G2TargetTagParameter) {
        Hashtable<String, Map> parameters = new Hashtable<String, Map>();
        parameters.put("C1G2TargetTagParameter", c1G2TargetTagParameter);
        Hashtable<String, Hashtable<String, Map>> result = new Hashtable<String, Hashtable<String, Map>>();
        result.put("C1G2TagSpecParameter", parameters);
        return result;
    }

    public static Map getC1G2TagSpecParameter(Map c1G2TargetTagParameter, Map c1G2TargetTagParameter2) {
        Hashtable<String, Map> parameters = new Hashtable<String, Map>();
        parameters.put("C1G2TargetTagParameter", c1G2TargetTagParameter);
        parameters.put("C1G2TargetTagParameter2", c1G2TargetTagParameter2);
        Hashtable<String, Hashtable<String, Map>> result = new Hashtable<String, Hashtable<String, Map>>();
        result.put("C1G2TagSpecParameter", parameters);
        return result;
    }

    public static Map getC1G2TargetTagParameter(int memoryBank, boolean match, int pointer, String tagMask, String tagData) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("MB", new Integer(memoryBank));
        parameters.put("Match", new Boolean(match));
        parameters.put("Pointer", new Integer(pointer));
        parameters.put("TagMask", ParameterFactory.str2byteArray(tagMask));
        parameters.put("TagData", ParameterFactory.str2byteArray(tagData));
        return parameters;
    }

    public static Map getC1G2WriteParameter(int OpSpecId, int accessPassword, int memoryBank, int wordPointer, String writeData) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("OpSpecID", new Integer(OpSpecId));
        parameters.put("AccessPassword", new Integer(accessPassword));
        parameters.put("MB", new Integer(memoryBank));
        parameters.put("WordPointer", new Integer(wordPointer));
        parameters.put("WriteDatas", ParameterFactory.str2wordList(writeData));
        Hashtable<String, Hashtable<String, Object>> result = new Hashtable<String, Hashtable<String, Object>>();
        result.put("C1G2WriteParameter", parameters);
        return result;
    }

    public static Map getC1G2WriteParameterAddId(int OpSpecId, Map c1G2WriteParameterNoId) {
        Map parameters = (Map)c1G2WriteParameterNoId.get("C1G2WriteParameter");
        parameters.put("OpSpecID", new Integer(OpSpecId));
        return c1G2WriteParameterNoId;
    }

    public static Map getC1G2WriteParameterNoId(int accessPassword, int memoryBank, int wordPointer, String writeData) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("AccessPassword", new Integer(accessPassword));
        parameters.put("MB", new Integer(memoryBank));
        parameters.put("WordPointer", new Integer(wordPointer));
        parameters.put("WriteDatas", ParameterFactory.str2wordList(writeData));
        Hashtable<String, Hashtable<String, Object>> result = new Hashtable<String, Hashtable<String, Object>>();
        result.put("C1G2WriteParameter", parameters);
        return result;
    }

    public static Map getEventNotificationStateParameter(int eventType, boolean enable) {
        Hashtable<String, Constable> parameters = new Hashtable<String, Constable>();
        parameters.put("EventNotificationState_EventType", new Integer(eventType));
        parameters.put("NotificationState", new Boolean(enable));
        return parameters;
    }

    public static Map getGPIPortCurrentStateParameter(int gpiPortNum, boolean enable) {
        Hashtable<String, Constable> parameters = new Hashtable<String, Constable>();
        parameters.put("GPIPortNum", new Integer(gpiPortNum));
        parameters.put("Config", new Boolean(enable));
        parameters.put("State", new Integer(0));
        return parameters;
    }

    public static Map getGPOWriteDataParameter(int gpoPortNum, boolean gpoPortState) {
        Hashtable<String, Constable> parameters = new Hashtable<String, Constable>();
        parameters.put("GPOPortNumber", new Integer(gpoPortNum));
        parameters.put("GPOData", new Boolean(gpoPortState));
        return parameters;
    }

    public static Map getInventoryParameterSpecParameter(int specId, int protocolId) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("InventoryParameterSpecID", new Integer(specId));
        parameters.put("ProtocolID", new Integer(protocolId));
        return parameters;
    }

    public static Map getROBoundarySpecParameter(Map rOSpecStartTriggerParameter, Map ROSpecStopTriggerParameter) {
        Hashtable<String, Map> parameters = new Hashtable<String, Map>();
        parameters.put("ROSpecStartTriggerParameter", rOSpecStartTriggerParameter);
        parameters.put("ROSpecStopTriggerParameter", ROSpecStopTriggerParameter);
        return parameters;
    }

    public static Map getROReportSpecParameter(int trigger, int tagNum, Map tagReportContentSelectorParameter) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("ROReportTrigger", new Integer(trigger));
        parameters.put("ROReportSpec_N", new Integer(tagNum));
        parameters.put("TagReportContentSelectorParameter", tagReportContentSelectorParameter);
        return parameters;
    }

    public static Map getROSpecIDParameter(int rospecId) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("ROSpecID", new Integer(rospecId));
        return parameters;
    }

    public static Map getROSpecParameter(int rospecId, int priority, int currentState, Map rOBoundarySpecParameter, List specParameterChoice, Map rOReportSpecParameter) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("ROSpecID", new Integer(rospecId));
        parameters.put("Priority", new Integer(priority));
        parameters.put("ROSpec_CurrentState", new Integer(currentState));
        parameters.put("ROBoundarySpecParameter", rOBoundarySpecParameter);
        parameters.put("SpecParameterChoice", specParameterChoice);
        if (rOReportSpecParameter != null) {
            parameters.put("ROReportSpecParameter", rOReportSpecParameter);
        }
        return parameters;
    }

    public static Map getROSpecStartTriggerParameter(int type) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("ROSpecStartTriggerType", new Integer(type));
        return parameters;
    }

    public static Map getROSpecStopTriggerParameter(int type, int duration) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("ROSpecStopTriggerType", new Integer(type));
        parameters.put("DurationTriggerValue", new Integer(duration));
        return parameters;
    }

    public static Map getReaderEventNotificationSpecParameter(List eventNotificationStates) {
        Hashtable<String, List> parameters = new Hashtable<String, List>();
        parameters.put("EventNotificationStateParameter", eventNotificationStates);
        return parameters;
    }

    public static Map getSetGPOWriteDataParameter(List gpoWriteDatas) {
        Hashtable<String, List> parameters = new Hashtable<String, List>();
        parameters.put("GPOWriteDataParameter", gpoWriteDatas);
        return parameters;
    }

    public static Map getSetReaderConfig_ReaderEventNotificationSpecParameter(boolean reset, Map readerEventNotificationSpecParameter) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("ResetToFactoryDefault", new Boolean(reset));
        parameters.put("ReaderEventNotificationSpecParameter", readerEventNotificationSpecParameter);
        return parameters;
    }

    public static Map getSetReaderGPICurrentStateParameter(boolean reset, List gpiCurrentStates) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("ResetToFactoryDefault", new Boolean(reset));
        parameters.put("GPIPortCurrentStateParameter", gpiCurrentStates);
        return parameters;
    }

    public static Map getTagReportContentSelectorParameter() {
        ArrayList<Map> airProtocolEPCMemorySelectorChoice = new ArrayList<Map>();
        airProtocolEPCMemorySelectorChoice.add(ParameterFactory.getC1G2EPCMemorySelectorParameter(0, 0));
        return ParameterFactory.getTagReportContentSelectorParameter(1, 1, 1, 1, 1, 1, 1, 1, 1, airProtocolEPCMemorySelectorChoice);
    }

    public static Map getTagReportContentSelectorParameter(int enableROSpecID, int enableSpecIndex, int enableInventoryParameterSpecID, int enableChannelIndex, int enablePeakRSSI, int enableFirstSeenTimestamp, int enableLastSeenTimestamp, int enableTagSeenCount, int enableAccessSpecID, List airProtocolEPCMemorySelectorChoice) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("EnableROSpecID", new Integer(enableROSpecID));
        parameters.put("EnableSpecIndex", new Integer(enableSpecIndex));
        parameters.put("EnableInventoryParameterSpecID", new Integer(1));
        parameters.put("EnableAntennaID", new Integer(enableInventoryParameterSpecID));
        parameters.put("EnableChannelIndex", new Integer(enableChannelIndex));
        parameters.put("EnablePeakRSSI", new Integer(enablePeakRSSI));
        parameters.put("EnableFirstSeenTimestamp", new Integer(enableFirstSeenTimestamp));
        parameters.put("EnableLastSeenTimestamp", new Integer(enableLastSeenTimestamp));
        parameters.put("EnableTagSeenCount", new Integer(enableTagSeenCount));
        parameters.put("EnableAccessSpecID", new Integer(enableAccessSpecID));
        if (airProtocolEPCMemorySelectorChoice != null && airProtocolEPCMemorySelectorChoice.size() > 0) {
            parameters.put("AirProtocolEPCMemorySelectorChoice", airProtocolEPCMemorySelectorChoice);
        }
        return parameters;
    }

    public static byte[] str2byteArray(String str) {
        char[] strChars = str.toCharArray();
        ArrayList<String> byteStrs = new ArrayList<String>();
        int i = 0;
        while (i < strChars.length) {
            StringBuffer byteStr = new StringBuffer();
            byteStr.append(strChars[i++]);
            if (i < strChars.length) {
                byteStr.append(strChars[i]);
            }
            if (i + 1 < strChars.length && strChars[i + 1] == ',') {
                ++i;
            }
            byteStrs.add(byteStr.toString());
            ++i;
        }
        byte[] bytes = new byte[byteStrs.size()];
        int i2 = 0;
        while (i2 < byteStrs.size()) {
            String byteStr = (String)byteStrs.get(i2);
            bytes[i2] = Integer.valueOf(byteStr, 16).byteValue();
            ++i2;
        }
        return bytes;
    }

    public static List str2wordList(String str) {
        Vector<Integer> result = new Vector<Integer>();
        int i = 0;
        while (i < str.length() / 4) {
            String wordStr = str.substring(4 * i, 4 * (i + 1));
            result.add(Integer.valueOf(wordStr, 16));
            ++i;
        }
        return result;
    }
}

