/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper.task;

import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.AbstractTask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class Task_Array
extends AbstractTask
implements ITaskListener {
    private String taskName;
    private ITask[] tasks;
    private int currentTask = -1;

    public Task_Array(String taskName, ITask[] tasks) {
        this.taskName = taskName;
        this.tasks = tasks;
    }

    public boolean duplicateTask(ITask task) {
        return task.getTaskName().equals(this.taskName);
    }

    public String getTaskName() {
        return this.taskName;
    }

    public synchronized void handleResponse(SignalService source, Object timestamp, Object data) {
        if (this.currentTask < 0) {
            return;
        }
        this.tasks[this.currentTask].handleResponse(source, timestamp, data);
    }

    public boolean launchTask() {
        if (this.tasks.length == 0 || this.tasks[0] == null) {
            return false;
        }
        this.currentTask = -1;
        this.tasks[0].addTaskListener(this);
        if (this.tasks[0].launchTask()) {
            this.log(4, "Started task: " + this.tasks[0].getTaskName() + " in " + this.taskName);
            this.currentTask = 0;
            return true;
        }
        return false;
    }

    public synchronized void taskNotice(String taskName, int status, Object result) {
        if (status == 0 || status == 2) {
            this.log(4, "Task Error|Timeout: " + taskName + " in " + this.taskName);
            this.notifyListener(this.taskName, status, result);
            return;
        }
        if (status == 1) {
            this.tasks[this.currentTask].removeTaskListener(this);
            if (this.currentTask + 1 < this.tasks.length) {
                boolean started = false;
                if (this.tasks[this.currentTask + 1] != null) {
                    this.tasks[this.currentTask + 1].addTaskListener(this);
                    if (this.tasks[this.currentTask + 1].launchTask()) {
                        ++this.currentTask;
                        started = true;
                        this.log(4, "Started task: " + this.tasks[this.currentTask].getTaskName() + " in " + this.taskName);
                    }
                }
                if (!started) {
                    this.notifyListener(this.taskName, 0, "Fail to start task: " + this.tasks[this.currentTask + 1].getTaskName() + " in " + this.taskName);
                }
            } else {
                this.notifyListener(this.taskName, 1, result);
                this.currentTask = -1;
            }
        }
    }
}

