/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper.task;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.AbstractLLRPTask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.signal.service.SignalService;

public class Task_GET_ACCESSSPECS
extends AbstractLLRPTask {
    private static final String TASKNAME = "Task_GET_ACCESSSPEC";
    private Map accessspecsList;

    public Task_GET_ACCESSSPECS(CommandService command, Map parameters, SignalService signal) {
        super(command, parameters, signal);
    }

    public Task_GET_ACCESSSPECS(CommandService command, Map parameters, SignalService signal, long timeout) {
        super(command, parameters, signal, timeout);
    }

    public boolean containsAccessSpecId(int accessspecId) {
        if (this.accessspecsList != null && !this.accessspecsList.isEmpty()) {
            return this.accessspecsList.containsKey(new Integer(accessspecId));
        }
        return false;
    }

    public boolean duplicateTask(ITask task) {
        return this.isSameTaskType(task);
    }

    public List getAccessSpecs() {
        ArrayList accessspecs = new ArrayList();
        if (this.accessspecsList != null && this.accessspecsList.size() > 0) {
            accessspecs.addAll(this.accessspecsList.entrySet());
        }
        return accessspecs;
    }

    public String getTaskName() {
        return TASKNAME;
    }

    public synchronized void handleResponse(SignalService source, Object timestamp, Object data) {
        Map responseMap;
        if (source == this.getSignal() && data instanceof Map && this.successInLLRPStatus(responseMap = (Map)data)) {
            this.populateAccessSpecsList(responseMap);
            this.log(4, "Task " + this.getTaskName() + " received success response.");
            this.notifyListener(this.getTaskName(), 1, responseMap);
        }
    }

    protected boolean isSameTaskType(ITask task) {
        return task instanceof Task_GET_ACCESSSPECS;
    }

    private void populateAccessSpecsList(Map responseMap) {
        List existingAccessSpecs = (List)responseMap.get("AccessSpecParameter");
        this.accessspecsList = new Hashtable();
        if (existingAccessSpecs != null && existingAccessSpecs.size() > 0) {
            int i = 0;
            while (i < existingAccessSpecs.size()) {
                Map accessspec = (Map)existingAccessSpecs.get(i);
                if (accessspec != null) {
                    Integer accessspecId = (Integer)accessspec.get("AccessSpecID");
                    this.accessspecsList.put(accessspecId, accessspec);
                }
                ++i;
            }
        }
    }
}

